/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock.observingparameters;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.AttachableToTarget;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.AbstractInstrumentSpec;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.editors.misc.ExpertParametersEditor;
import alma.obsprep.ot.editors.schedblock.observingparameters.ScienceParameterEditor;
import alma.obsprep.ot.models.schedblock.observingparameters.ObservingParameterModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.valuetypes.Time;
import java.text.DecimalFormat;

public class ScienceParameterModel
extends ObservingParameterModel {
    private final ValueUnitPairModel representativeBandwidthModel = new ValueUnitPairModel(null, ScienceParameterEditor.FID_REPRESENTATIVEBANDWIDTH_VALUE, ScienceParameterEditor.FID_REPRESENTATIVEBANDWIDTH_UNIT);
    private final ValueUnitPairModel representativeFrequencyModel = new ValueUnitPairModel(null, ScienceParameterEditor.FID_REPRESENTATIVEFREQUENCY_VALUE, ScienceParameterEditor.FID_REPRESENTATIVEFREQUENCY_UNIT);
    private final ValueUnitPairModel sensitivityGoalModel = new ValueUnitPairModel(null, ScienceParameterEditor.FID_SENSITIVITYGOAL_VALUE, ScienceParameterEditor.FID_SENSITIVITYGOAL_UNIT);
    private final ValueUnitPairModel integrationTimeModel;
    private final ValueUnitPairModel subScanDurationModel;

    public ScienceParameterModel(ScienceParameters scienceParameters) {
        super((ObservingParameters)((Object)scienceParameters));
        this.sensitivityGoalModel.setNumberFormat(new DecimalFormat("0.0000000"));
        this.integrationTimeModel = new ValueUnitPairModel(null, ScienceParameterEditor.FID_INTEGRATIONTIME_VALUE, ScienceParameterEditor.FID_INTEGRATIONTIME_UNIT);
        this.subScanDurationModel = new ValueUnitPairModel(null, ScienceParameterEditor.FID_SUBSCANDURATION_VALUE, ScienceParameterEditor.FID_SUBSCANDURATION_UNIT);
        this.registerSubModel(this.representativeBandwidthModel);
        this.registerSubModel(this.representativeFrequencyModel);
        this.registerSubModel(this.sensitivityGoalModel);
        this.registerSubModel(this.integrationTimeModel);
        this.registerSubModel(this.subScanDurationModel);
        this.setDocument((Object)scienceParameters);
    }

    public ScienceParameters getScienceParameters() {
        return (ScienceParameters)((Object)this.getDocument());
    }

    @Override
    public void publish() {
        if (this.getDocument() == null) {
            return;
        }
        this.publish(ScienceParameterEditor.FID_NAME, this.getScienceParameters().getName());
        this.publish(ExpertParametersEditor.KEYWORDVALUE_TABLE_FID, this.getScienceParameters().getExpertParameterList());
        this.publish(ScienceParameterEditor.FID_FORCEATMCAL, this.getScienceParameters().getForceAtmCal());
        if (this.representativeBandwidthModel != null) {
            this.representativeBandwidthModel.publish();
        }
        if (this.representativeFrequencyModel != null) {
            this.representativeFrequencyModel.publish();
        }
        if (this.sensitivityGoalModel != null) {
            this.sensitivityGoalModel.publish();
        }
        if (this.integrationTimeModel != null) {
            this.integrationTimeModel.publish();
        }
        if (this.expertParametersModel != null) {
            this.expertParametersModel.publish();
        }
        if (this.subScanDurationModel != null) {
            this.subScanDurationModel.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(ScienceParameterEditor.FID_NAME)) {
            String string = (String)object;
            this.getScienceParameters().setName(string);
            return string;
        }
        if (fieldID.equals(ScienceParameterEditor.FID_SPADJUST_BUTTON)) {
            AbstractInstrumentSpec abstractInstrumentSpec;
            Target[] targetArray = this.getScienceParameters().getTargetList();
            if (targetArray.length > 0 && (abstractInstrumentSpec = targetArray[0].getAbstractInstrumentSpec()) != null && !(abstractInstrumentSpec instanceof OpticalCameraSpec)) {
                SpectralSpec spectralSpec = (SpectralSpec)((Object)abstractInstrumentSpec);
                AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getAbstractCorrelatorConfiguration();
                if (abstractCorrelatorConfiguration == null) {
                    return object;
                }
                CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(abstractCorrelatorConfiguration.getCorrelatorType());
                double d = this.getScienceParameters().getSubScanDuration().getContentInUnits(Time.UNIT_S);
                double d2 = abstractCorrelatorConfiguration.getIntegrationDuration().getContentInUnits(Time.UNIT_S);
                double d3 = correlatorExpert.calcSubscanDuration(d, d2, 1);
                this.getScienceParameters().getSubScanDuration().setContentAndUnit((ValueUnitPair)Time.createTimeSec(d3));
                this.getSubScanDurationModel().publish();
            }
        } else if (fieldID.equals(ScienceParameterEditor.FID_FORCEATMCAL)) {
            Boolean bl = (Boolean)object;
            this.getScienceParameters().setForceAtmCal(bl);
        }
        return object;
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        if (object == null) {
            return;
        }
        ScienceParameters scienceParameters = null;
        if (object instanceof Target) {
            ScienceParameters[] scienceParametersArray = ((Target)object).getScienceParametersList();
            scienceParameters = scienceParametersArray.length > 0 ? scienceParametersArray[0] : null;
        } else if (object instanceof ScienceParameters) {
            scienceParameters = (ScienceParameters)((Object)object);
        } else {
            Log.logger((Object)this).warning("Unexpected document : " + object.getClass());
            return;
        }
        this.document = scienceParameters;
        this.getUsedByTargetModel().setDocument((AttachableToTarget)((Object)scienceParameters), this.isTargetContext());
        if (scienceParameters != null) {
            this.representativeBandwidthModel.setDocument((Object)scienceParameters.getRepresentativeBandwidth());
            this.representativeFrequencyModel.setDocument((Object)scienceParameters.getRepresentativeFrequency());
            this.sensitivityGoalModel.setDocument((Object)scienceParameters.getSensitivityGoal());
            this.integrationTimeModel.setDocument((Object)scienceParameters.getIntegrationTime());
            this.getExpertParametersModel().setDocument((Object)scienceParameters);
            this.subScanDurationModel.setDocument(scienceParameters.getSubScanDuration());
        }
        this.publish();
    }

    public ValueUnitPairModel getRepresentativeBandwidthModel() {
        return this.representativeBandwidthModel;
    }

    public ValueUnitPairModel getRepresentativeFrequencyModel() {
        return this.representativeFrequencyModel;
    }

    public ValueUnitPairModel getSensitivityGoalModel() {
        return this.sensitivityGoalModel;
    }

    public ValueUnitPairModel getIntegrationTimeModel() {
        return this.integrationTimeModel;
    }

    public ValueUnitPairModel getSubScanDurationModel() {
        return this.subScanDurationModel;
    }
}

