/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.obsprep.bo.obsproject.ObservatoryGoalTargetParameters;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.ot.editors.misc.TableRowsLoader;
import alma.obsprep.util.Convert;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Flux;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.util.ArrayList;
import java.util.List;

public class ObservatoryGoalTargetTableLoader
extends TableRowsLoader {
    private final int COL_SOURCENAME = 0;
    private static final int COL_RA = 1;
    private static final int COL_DEC = 2;
    private static final int COL_FLUX = 3;
    private final List<ObservatoryGoalTargetParameters> list = new ArrayList<ObservatoryGoalTargetParameters>();

    @Override
    public void parse(String[] stringArray, StringBuffer stringBuffer) {
        double d;
        ObservatoryGoalTargetParameters observatoryGoalTargetParameters = ObservatoryGoalTargetParameters.createObservatoryGoalTargetParameters();
        String string = stringArray[0];
        observatoryGoalTargetParameters.setSourceName(string);
        Longitude longitude = Longitude.createLongitude();
        try {
            longitude.setContentInDeg(Convert.HHMMSSToDeg(stringArray[1]));
        }
        catch (InvalidCoordException | NumberFormatException exception) {
            GUIUtilities.warning(null, "Target " + string + ": Error parsing RA, set to 0.0");
            longitude.setContentInDeg(0.0);
        }
        Latitude latitude = Latitude.createLatitude();
        try {
            latitude.setContentInDeg(Convert.DDMMSSToDeg(stringArray[2]));
        }
        catch (InvalidCoordException | NumberFormatException exception) {
            GUIUtilities.warning(null, "Target " + string + ": Error parsing Dec, set to 0.0");
            latitude.setContentInDeg(0.0);
        }
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates(SkyCoordinates.TYPE_ABSOLUTE);
        skyCoordinates.setSystem(SkyCoordinates.SYSTEM_J2000);
        skyCoordinates.setLongitude(longitude);
        skyCoordinates.setLatitude(latitude);
        observatoryGoalTargetParameters.setSourceCoordinates(skyCoordinates);
        try {
            d = Double.parseDouble(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            GUIUtilities.warning(null, "Target " + string + ": Error parsing flux, set to 0.0 Jy");
            d = 0.0;
        }
        Flux flux = Flux.createFlux((double)d, (String)Flux.UNIT_JY);
        observatoryGoalTargetParameters.setFlux(flux);
        this.list.add(observatoryGoalTargetParameters);
    }

    public List<ObservatoryGoalTargetParameters> getTargets() {
        return new ArrayList<ObservatoryGoalTargetParameters>(this.list);
    }

    @Override
    public void init() {
        this.list.clear();
    }
}

