/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.widgets;

import alma.obsprep.ot.gui.widgets.RangeSlider;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

class RangeSliderUI
extends BasicSliderUI {
    private final Color rangeColor = UIManager.getColor("textHighlight");
    private final Color trackColor = UIManager.getColor("Slider.tickColor");
    private final Icon thumbIcon = this.createImageIcon("resources/filter_slide_knob.png", "Range Slider Knob");
    private BufferedImage lowerHorizontalThumbImage;
    private BufferedImage upperHorizontalThumbImage;
    private BufferedImage verticalThumbImage;
    private Rectangle upperThumbRect;
    private boolean upperThumbSelected;
    private transient boolean lowerDragging;
    private transient boolean upperDragging;

    public RangeSliderUI(RangeSlider rangeSlider) {
        super(rangeSlider);
        this.initResources();
    }

    protected ImageIcon createImageIcon(String string, String string2) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL, string2);
        }
        System.err.println("Couldn't find file: " + string);
        return null;
    }

    private void initResources() {
        if (this.thumbIcon instanceof ImageIcon) {
            this.lowerHorizontalThumbImage = new BufferedImage(this.thumbIcon.getIconWidth(), this.thumbIcon.getIconHeight(), 2);
            Graphics2D graphics2D = this.lowerHorizontalThumbImage.createGraphics();
            graphics2D.drawImage(((ImageIcon)this.thumbIcon).getImage(), 0, 0, null);
            graphics2D.dispose();
            this.upperHorizontalThumbImage = new BufferedImage(this.thumbIcon.getIconWidth(), this.thumbIcon.getIconHeight(), 2);
            graphics2D = this.upperHorizontalThumbImage.createGraphics();
            graphics2D.drawImage(((ImageIcon)this.thumbIcon).getImage(), 0, 0, null);
            graphics2D.dispose();
            AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
            affineTransform.translate(0.0, -this.upperHorizontalThumbImage.getHeight(null));
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
            this.upperHorizontalThumbImage = affineTransformOp.filter(this.upperHorizontalThumbImage, null);
            this.verticalThumbImage = new BufferedImage(this.thumbIcon.getIconHeight(), this.thumbIcon.getIconWidth(), 2);
            graphics2D = this.verticalThumbImage.createGraphics();
            graphics2D.translate(0, this.thumbIcon.getIconWidth());
            graphics2D.rotate(-1.5707963267948966);
            graphics2D.drawImage(((ImageIcon)this.thumbIcon).getImage(), 0, 0, null);
            graphics2D.dispose();
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.upperThumbRect = new Rectangle();
        super.installUI(jComponent);
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        this.focusInsets = new Insets(0, 0, 0, 0);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new RangeTrackListener();
    }

    @Override
    protected ChangeListener createChangeListener(JSlider jSlider) {
        return new ChangeHandler();
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.upperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    @Override
    protected void calculateThumbLocation() {
        int n;
        super.calculateThumbLocation();
        if (this.slider.getSnapToTicks()) {
            int n2 = n = this.slider.getValue() + this.slider.getExtent();
            int n3 = this.slider.getMajorTickSpacing();
            int n4 = this.slider.getMinorTickSpacing();
            int n5 = 0;
            if (n4 > 0) {
                n5 = n4;
            } else if (n3 > 0) {
                n5 = n3;
            }
            if (n5 != 0) {
                if ((n - this.slider.getMinimum()) % n5 != 0) {
                    float f = (float)(n - this.slider.getMinimum()) / (float)n5;
                    int n6 = Math.round(f);
                    n2 = this.slider.getMinimum() + n6 * n5;
                }
                if (n2 != n) {
                    this.slider.setExtent(n2 - this.slider.getValue());
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            n = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = n - this.upperThumbRect.width / 2;
            this.upperThumbRect.y = this.trackRect.y;
        } else {
            n = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = this.trackRect.x;
            this.upperThumbRect.y = n - this.upperThumbRect.height / 2;
        }
    }

    @Override
    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 0 && this.lowerHorizontalThumbImage != null) {
            return new Dimension(this.lowerHorizontalThumbImage.getWidth(), this.lowerHorizontalThumbImage.getHeight());
        }
        if (this.slider.getOrientation() == 1 && this.verticalThumbImage != null) {
            return new Dimension(this.verticalThumbImage.getWidth(), this.verticalThumbImage.getHeight());
        }
        return super.getThumbSize();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        Rectangle rectangle = graphics.getClipBounds();
        boolean bl = ((RangeSlider)this.slider).isLowerThumbEnabled();
        boolean bl2 = ((RangeSlider)this.slider).isUpperThumbEnabled();
        if (this.upperThumbSelected) {
            if (rectangle.intersects(this.thumbRect) && bl) {
                this.paintLowerThumb(graphics);
            }
            if (rectangle.intersects(this.upperThumbRect) && bl2) {
                this.paintUpperThumb(graphics);
            }
        } else {
            if (rectangle.intersects(this.upperThumbRect) && bl2) {
                this.paintUpperThumb(graphics);
            }
            if (rectangle.intersects(this.thumbRect) && bl) {
                this.paintLowerThumb(graphics);
            }
        }
    }

    @Override
    public void paintTicks(Graphics graphics) {
        Rectangle rectangle = this.tickRect;
        graphics.setColor(this.trackColor);
        int n = this.slider.getMajorTickSpacing();
        int n2 = this.slider.getMinorTickSpacing();
        if (this.slider.getOrientation() == 0) {
            int n3;
            graphics.translate(0, rectangle.y);
            int n4 = 0;
            if (n2 > 0) {
                for (n3 = (int)(Math.floor((this.slider.getMinimum() + n2) / n2) * (double)n2); n3 <= this.slider.getMaximum(); n3 += n2) {
                    n4 = this.xPositionForValue(n3);
                    this.paintMinorTickForHorizSlider(graphics, rectangle, n4);
                }
            }
            if (n > 0) {
                for (n3 = (int)(Math.floor((this.slider.getMinimum() + n) / n) * (double)n); n3 <= this.slider.getMaximum(); n3 += n) {
                    n4 = this.xPositionForValue(n3);
                    this.paintMajorTickForHorizSlider(graphics, rectangle, n4);
                }
            }
            graphics.translate(0, -rectangle.y);
        }
    }

    @Override
    public void paintTrack(Graphics graphics) {
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int n;
            int n2 = this.thumbRect.x + this.thumbRect.width / 2;
            int n3 = this.upperThumbRect.x + this.upperThumbRect.width / 2;
            int n4 = rectangle.height / 2;
            int n5 = rectangle.width;
            Color color = graphics.getColor();
            graphics.translate(rectangle.x, rectangle.y + n4);
            graphics.setColor(this.rangeColor);
            for (n = -2; n <= 3; ++n) {
                graphics.drawLine(n2 - rectangle.x, n, n3 - rectangle.x, n);
            }
            graphics.setColor(this.trackColor);
            for (n = 0; n < n5 - 1; n += 2) {
                graphics.drawLine(n, 0, n, 0);
            }
            graphics.drawLine(0, 1, n5 - 1, 1);
            graphics.translate(-rectangle.x, -(rectangle.y + n4));
            graphics.setColor(color);
        } else {
            int n;
            int n6 = this.thumbRect.y + this.thumbRect.height / 2;
            int n7 = this.upperThumbRect.y + this.upperThumbRect.height / 2;
            int n8 = rectangle.width / 2;
            int n9 = rectangle.height;
            Color color = graphics.getColor();
            graphics.translate(rectangle.x + n8, rectangle.y);
            graphics.setColor(this.rangeColor);
            for (n = -2; n <= 3; ++n) {
                graphics.drawLine(n, n6 - rectangle.y, n, n7 - rectangle.y);
            }
            graphics.setColor(this.trackColor);
            for (n = 0; n < n9 - 1; n += 2) {
                graphics.drawLine(0, n, 0, n);
            }
            graphics.drawLine(1, 0, 1, n9 - 1);
            graphics.translate(-(rectangle.x + n8), -rectangle.y);
            graphics.setColor(color);
        }
    }

    @Override
    public void paintThumb(Graphics graphics) {
    }

    private void paintLowerThumb(Graphics graphics) {
        BufferedImage bufferedImage;
        Rectangle rectangle = this.thumbRect;
        int n = rectangle.width;
        int n2 = rectangle.height;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        BufferedImage bufferedImage2 = bufferedImage = this.slider.getOrientation() == 0 ? this.lowerHorizontalThumbImage : this.verticalThumbImage;
        if (bufferedImage != null) {
            graphics2D.drawImage((Image)bufferedImage, rectangle.x, rectangle.y, null);
        } else {
            Shape shape = this.createThumbShape(n - 1, n2 - 1, false);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.translate(rectangle.x, rectangle.y);
            graphics2D.setColor(Color.CYAN);
            graphics2D.fill(shape);
            graphics2D.setColor(Color.BLUE);
            graphics2D.draw(shape);
        }
        graphics2D.dispose();
    }

    private void paintUpperThumb(Graphics graphics) {
        BufferedImage bufferedImage;
        Rectangle rectangle = this.upperThumbRect;
        int n = rectangle.width;
        int n2 = rectangle.height;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        BufferedImage bufferedImage2 = bufferedImage = this.slider.getOrientation() == 0 ? this.upperHorizontalThumbImage : this.verticalThumbImage;
        if (bufferedImage != null) {
            graphics2D.drawImage((Image)bufferedImage, rectangle.x, rectangle.y, null);
        } else {
            Shape shape = this.createThumbShape(n - 1, n2 - 1, true);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.translate(rectangle.x, rectangle.y);
            graphics2D.setColor(Color.PINK);
            graphics2D.fill(shape);
            graphics2D.setColor(Color.RED);
            graphics2D.draw(shape);
        }
        graphics2D.dispose();
    }

    private Shape createThumbShape(int n, int n2, boolean bl) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, n, n2);
        return double_;
    }

    private void setUpperThumbLocation(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.upperThumbRect);
        this.upperThumbRect.setLocation(n, n2);
        SwingUtilities.computeUnion(this.upperThumbRect.x, this.upperThumbRect.y, this.upperThumbRect.width, this.upperThumbRect.height, rectangle);
        this.slider.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByBlock(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (n2 <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                n2 = 1;
            }
            int n3 = n2 * (n > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int n4 = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(n4 + n3);
            } else {
                int n5 = this.slider.getValue();
                this.slider.setValue(n5 + n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = 1 * (n > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int n3 = ((RangeSlider)this.slider).getUpperValue();
                ((RangeSlider)this.slider).setUpperValue(n3 + n2);
            } else {
                int n4 = this.slider.getValue();
                this.slider.setValue(n4 + n2);
            }
        }
    }

    public class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        public RangeTrackListener() {
            super(RangeSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (RangeSliderUI.this.slider.isRequestFocusEnabled()) {
                RangeSliderUI.this.slider.requestFocus();
            }
            boolean bl = false;
            boolean bl2 = false;
            if (RangeSliderUI.this.upperThumbSelected) {
                if (RangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    bl2 = true;
                } else if (RangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    bl = true;
                }
            } else if (RangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                bl = true;
            } else if (RangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                bl2 = true;
            }
            boolean bl3 = ((RangeSlider)RangeSliderUI.this.slider).isLowerThumbEnabled();
            if (bl3 && bl) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((RangeSliderUI)RangeSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((RangeSliderUI)RangeSliderUI.this).thumbRect.x;
                    }
                }
                RangeSliderUI.this.upperThumbSelected = false;
                RangeSliderUI.this.lowerDragging = true;
                return;
            }
            RangeSliderUI.this.lowerDragging = false;
            boolean bl4 = ((RangeSlider)RangeSliderUI.this.slider).isUpperThumbEnabled();
            if (bl4 && bl2) {
                switch (RangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - RangeSliderUI.this.upperThumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - RangeSliderUI.this.upperThumbRect.x;
                    }
                }
                RangeSliderUI.this.upperThumbSelected = true;
                RangeSliderUI.this.upperDragging = true;
                return;
            }
            RangeSliderUI.this.upperDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            RangeSliderUI.this.lowerDragging = false;
            RangeSliderUI.this.upperDragging = false;
            RangeSliderUI.this.slider.setValueIsAdjusting(false);
            super.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!RangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (RangeSliderUI.this.lowerDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveLowerThumb();
            } else if (RangeSliderUI.this.upperDragging) {
                RangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveUpperThumb();
            }
        }

        @Override
        public boolean shouldScroll(int n) {
            return false;
        }

        private void moveLowerThumb() {
            int n = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int n3 = this.currentMouseY - this.offset;
                    int n4 = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int n5 = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int n6 = RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent());
                    if (RangeSliderUI.this.drawInverted()) {
                        n5 = n6;
                    } else {
                        n4 = n6;
                    }
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    RangeSliderUI.this.setThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, n3);
                    n = n3 + n2;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForYPosition(n));
                    break;
                }
                case 0: {
                    int n7 = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int n8 = this.currentMouseX - this.offset;
                    int n9 = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int n10 = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int n11 = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue() + RangeSliderUI.this.slider.getExtent());
                    if (RangeSliderUI.this.drawInverted()) {
                        n9 = n11;
                    } else {
                        n10 = n11;
                    }
                    n8 = Math.max(n8, n9 - n7);
                    n8 = Math.min(n8, n10 - n7);
                    RangeSliderUI.this.setThumbLocation(n8, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    n = n8 + n7;
                    RangeSliderUI.this.slider.setValue(RangeSliderUI.this.valueForXPosition(n));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        private void moveUpperThumb() {
            int n = 0;
            switch (RangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = ((RangeSliderUI)RangeSliderUI.this).thumbRect.height / 2;
                    int n3 = this.currentMouseY - this.offset;
                    int n4 = ((RangeSliderUI)RangeSliderUI.this).trackRect.y;
                    int n5 = ((RangeSliderUI)RangeSliderUI.this).trackRect.y + (((RangeSliderUI)RangeSliderUI.this).trackRect.height - 1);
                    int n6 = RangeSliderUI.this.yPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        n4 = n6;
                    } else {
                        n5 = n6;
                    }
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    RangeSliderUI.this.setUpperThumbLocation(((RangeSliderUI)RangeSliderUI.this).thumbRect.x, n3);
                    n = n3 + n2;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForYPosition(n) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                case 0: {
                    int n7 = ((RangeSliderUI)RangeSliderUI.this).thumbRect.width / 2;
                    int n8 = this.currentMouseX - this.offset;
                    int n9 = ((RangeSliderUI)RangeSliderUI.this).trackRect.x;
                    int n10 = ((RangeSliderUI)RangeSliderUI.this).trackRect.x + (((RangeSliderUI)RangeSliderUI.this).trackRect.width - 1);
                    int n11 = RangeSliderUI.this.xPositionForValue(RangeSliderUI.this.slider.getValue());
                    if (RangeSliderUI.this.drawInverted()) {
                        n10 = n11;
                    } else {
                        n9 = n11;
                    }
                    n8 = Math.max(n8, n9 - n7);
                    n8 = Math.min(n8, n10 - n7);
                    RangeSliderUI.this.setUpperThumbLocation(n8, ((RangeSliderUI)RangeSliderUI.this).thumbRect.y);
                    n = n8 + n7;
                    RangeSliderUI.this.slider.setExtent(RangeSliderUI.this.valueForXPosition(n) - RangeSliderUI.this.slider.getValue());
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!RangeSliderUI.this.lowerDragging && !RangeSliderUI.this.upperDragging) {
                RangeSliderUI.this.calculateThumbLocation();
                RangeSliderUI.this.slider.repaint();
            }
        }
    }
}

