/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.obsprep.obstooluserprefs.DialogSettings;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.util.GUIUtilities;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;

public class UserStartupDialog
extends GuiFactory.Dialog {
    private DialogId dialogId = new DialogId("Startup.UserDialog", "Display initial start-up options");
    private static volatile UserStartupDialog instance = null;
    private UserStartupChoice userStartupChoice = UserStartupChoice.NEW_PROPOSAL;
    private UserStartupPanel userStartupPanel = null;
    private boolean doNotShowAgain = false;
    private boolean advancedOptions = false;

    public static UserStartupDialog getMyInstance() {
        return instance;
    }

    public UserStartupDialog(Frame frame, boolean bl) {
        super(frame);
        instance = this;
        this.advancedOptions = bl;
        this.setTitle("Startup Options");
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.userStartupPanel = new UserStartupPanel(this);
        this.add(this.userStartupPanel);
        super.setDefaultButton(this.userStartupPanel.buttonOK);
    }

    public UserStartupChoice getUserStartupChoice() {
        return this.userStartupChoice;
    }

    public boolean getDoNotShowAgain() {
        return this.doNotShowAgain;
    }

    public UserStartupChoice showOnTheFlyDialog() {
        this.userStartupChoice = UserStartupChoice.NEW_PROPOSAL;
        DialogSettings dialogSettings = GUIUtilities.dialogSettings(this.dialogId);
        if (dialogSettings.getSuppress()) {
            return this.userStartupChoice;
        }
        if (this.getX() == 0 && this.getY() == 0) {
            this.setLocationRelativeTo(this.getOwner());
        }
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
        if (this.doNotShowAgain) {
            GUIUtilities.automatiseDialog(this.dialogId, 0);
        }
        return this.userStartupChoice;
    }

    public static void main(String[] stringArray) {
        UserStartupDialog userStartupDialog = new UserStartupDialog(null, true);
        userStartupDialog.setDefaultCloseOperation(2);
        userStartupDialog.pack();
        userStartupDialog.setVisible(true);
        System.out.println("Got user option: " + userStartupDialog.getUserStartupChoice().value());
        userStartupDialog.dispose();
    }

    public class UserStartupPanel
    extends JPanel {
        private GuiFactory.Dialog mainDialog = null;
        private ButtonGroup buttonGroup;
        private JButton buttonOK;
        private JCheckBox checkDoNotShow;
        private JLabel labelAdvancedOptions;
        private JLabel labelWhatToDo;
        private JRadioButton radioCommissionProject;
        private JRadioButton radioCreateProposal;
        private JRadioButton radioCreateDDTProposal;
        private JRadioButton radioOpenProject;
        private JRadioButton radioPhaseIIProject;
        private JRadioButton radioRetrieveProject;

        public UserStartupPanel(GuiFactory.Dialog dialog) {
            this.mainDialog = dialog;
            this.initComponents();
        }

        private void initComponents() {
            this.buttonGroup = new ButtonGroup();
            this.labelWhatToDo = new JLabel();
            this.labelAdvancedOptions = new JLabel();
            this.radioCreateProposal = new JRadioButton();
            this.radioCreateDDTProposal = new JRadioButton();
            this.radioOpenProject = new JRadioButton();
            this.radioRetrieveProject = new JRadioButton();
            if (UserStartupDialog.this.advancedOptions) {
                this.radioPhaseIIProject = new JRadioButton();
                this.radioCommissionProject = new JRadioButton();
                this.radioPhaseIIProject.setName("UserStartupDialog.Phase2ProjectRadio");
                this.radioCommissionProject.setName("UserStartupDialog.CommissionProjectRadio");
            }
            this.checkDoNotShow = new JCheckBox();
            this.buttonOK = new JButton();
            this.setName("UserStartupDialog");
            this.radioCreateProposal.setName("UserStartupDialog.CreateNewProposalRadio");
            this.radioCreateDDTProposal.setName("UserStartupDialog.CreateNewDDTProposalRadio");
            this.radioOpenProject.setName("UserStartupDialog.OpenProjectRadio");
            this.radioRetrieveProject.setName("UserStartupDialog.RetrieveProjectRadio");
            this.buttonOK.setName("UserStartupDialog.OkButton");
            this.labelWhatToDo.setText("What would you like to do?");
            this.labelAdvancedOptions.setText("Advanced options");
            this.buttonGroup.add(this.radioCreateProposal);
            this.radioCreateProposal.setSelected(true);
            this.radioCreateProposal.setText(UserStartupChoice.NEW_PROPOSAL.value());
            this.radioCreateProposal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserStartupPanel.this.radioCreateProposalActionPerformed(actionEvent);
                }
            });
            this.buttonGroup.add(this.radioCreateDDTProposal);
            this.radioCreateDDTProposal.setText(UserStartupChoice.NEW_DDT_PROPOSAL.value());
            this.radioCreateDDTProposal.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserStartupPanel.this.radioCreateDDTProposalActionPerformed(actionEvent);
                }
            });
            this.buttonGroup.add(this.radioOpenProject);
            this.radioOpenProject.setText(UserStartupChoice.OPEN_PROJECT.value());
            this.radioOpenProject.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserStartupPanel.this.radioOpenProjectActionPerformed(actionEvent);
                }
            });
            this.buttonGroup.add(this.radioRetrieveProject);
            this.radioRetrieveProject.setText(UserStartupChoice.RETRIEVE_PROJECT.value());
            this.radioRetrieveProject.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserStartupPanel.this.radioRetrieveProjectActionPerformed(actionEvent);
                }
            });
            if (UserStartupDialog.this.advancedOptions) {
                this.buttonGroup.add(this.radioPhaseIIProject);
                this.radioPhaseIIProject.setText(UserStartupChoice.PHASEII_PROJECT.value());
                this.radioPhaseIIProject.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        UserStartupPanel.this.radioPhaseIIProjectActionPerformed(actionEvent);
                    }
                });
                this.buttonGroup.add(this.radioCommissionProject);
                this.radioCommissionProject.setText(UserStartupChoice.COMMISSION_PROJECT.value());
                this.radioCommissionProject.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        UserStartupPanel.this.radioCommissionProjectActionPerformed(actionEvent);
                    }
                });
            }
            this.checkDoNotShow.setText("Do not show this message again");
            this.checkDoNotShow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserStartupPanel.this.checkDoNotShowActionPerformed(actionEvent);
                }
            });
            this.buttonOK.setText("OK");
            this.buttonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    UserStartupPanel.this.buttonOKActionPerformed(actionEvent);
                }
            });
            GroupLayout groupLayout = new GroupLayout(this);
            this.setLayout(groupLayout);
            if (UserStartupDialog.this.advancedOptions) {
                groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.labelWhatToDo)).addGroup(groupLayout.createSequentialGroup().addGap(40, 40, 40).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioOpenProject).addComponent(this.radioCreateProposal).addComponent(this.radioCreateDDTProposal).addComponent(this.radioRetrieveProject).addComponent(this.radioPhaseIIProject).addComponent(this.radioCommissionProject))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.labelAdvancedOptions)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.checkDoNotShow)).addGroup(groupLayout.createSequentialGroup().addGap(142, 142, 142).addComponent(this.buttonOK, -2, 70, -2))).addContainerGap(-1, Short.MAX_VALUE)));
                groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.labelWhatToDo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioCreateProposal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioCreateDDTProposal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioOpenProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioRetrieveProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelAdvancedOptions).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioPhaseIIProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioCommissionProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDoNotShow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOK, -1, -1, Short.MAX_VALUE).addContainerGap()));
            } else {
                groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.labelWhatToDo)).addGroup(groupLayout.createSequentialGroup().addGap(40, 40, 40).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.radioOpenProject).addComponent(this.radioCreateProposal).addComponent(this.radioCreateDDTProposal).addComponent(this.radioRetrieveProject))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.checkDoNotShow)).addGroup(groupLayout.createSequentialGroup().addGap(142, 142, 142).addComponent(this.buttonOK, -2, 70, -2))).addContainerGap(-1, Short.MAX_VALUE)));
                groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.labelWhatToDo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioCreateProposal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioCreateDDTProposal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioOpenProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioRetrieveProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkDoNotShow).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonOK, -1, -1, Short.MAX_VALUE).addContainerGap()));
            }
        }

        private void radioCreateProposalActionPerformed(ActionEvent actionEvent) {
            UserStartupDialog.this.userStartupChoice = UserStartupChoice.NEW_PROPOSAL;
        }

        private void radioCreateDDTProposalActionPerformed(ActionEvent actionEvent) {
            UserStartupDialog.this.userStartupChoice = UserStartupChoice.NEW_DDT_PROPOSAL;
        }

        private void radioOpenProjectActionPerformed(ActionEvent actionEvent) {
            UserStartupDialog.this.userStartupChoice = UserStartupChoice.OPEN_PROJECT;
        }

        private void radioRetrieveProjectActionPerformed(ActionEvent actionEvent) {
            UserStartupDialog.this.userStartupChoice = UserStartupChoice.RETRIEVE_PROJECT;
        }

        private void radioPhaseIIProjectActionPerformed(ActionEvent actionEvent) {
            UserStartupDialog.this.userStartupChoice = UserStartupChoice.PHASEII_PROJECT;
        }

        private void radioCommissionProjectActionPerformed(ActionEvent actionEvent) {
            UserStartupDialog.this.userStartupChoice = UserStartupChoice.COMMISSION_PROJECT;
        }

        private void checkDoNotShowActionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            UserStartupDialog.this.doNotShowAgain = jCheckBox.isSelected();
        }

        private void buttonOKActionPerformed(ActionEvent actionEvent) {
            this.mainDialog.setVisible(false);
        }
    }

    public static enum UserStartupChoice {
        NEW_PROPOSAL("Create a new proposal"),
        NEW_DDT_PROPOSAL("Create a new DDT proposal"),
        OPEN_PROJECT("Open an existing project from disk"),
        RETRIEVE_PROJECT("Retrieve a project from the ALMA science archive"),
        PHASEII_PROJECT("Create a new phase II project"),
        COMMISSION_PROJECT("Create a new commissioning project"),
        VLBI_PROJECT("Create a new VLBI project"),
        SUPPLEMENTAL_CALL_PROJECT("Create a new ACA supplemental call project");

        private final String value;

        String value() {
            return this.value;
        }

        private UserStartupChoice(String string2) {
            this.value = string2;
        }
    }
}

