/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.ot.editors.investigator.InvestigatorSearchDialog;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import alma.obsprep.ot.persistence.CredentialsProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class UserAuthenticator
implements PreferencesReadWrite,
CredentialsProvider {
    public volatile boolean suppressGraphics = false;
    private final Credentials userCredentials = new Credentials();
    private WeakHashMap<CredentialPanel, Void> knownCredPanels = new WeakHashMap();
    volatile OnTheFlyPanel onthefly;
    boolean returnValue;
    private final ArrayList<UserAuthenticationSettingsChangeListener> ualis = new ArrayList();
    private List<UserAuthenticationSettingsChangeListener> ualis_ro = Collections.emptyList();

    @Override
    public String[] getCredentials(String string) {
        if (this.suppressGraphics) {
            return new String[]{this.getUsername(), this.getPassword()};
        }
        if (!this.areCredentialsGiven() && !this.launchPasswordDialog("Requested operation: " + string + "\n\nA valid ALMA username and password are required to continue.\nPlease enter your username and password.")) {
            return null;
        }
        return new String[]{this.getUsername(), this.getPassword()};
    }

    @Override
    public String[] getCredentialsAgain() {
        if (this.suppressGraphics) {
            return null;
        }
        if (!this.launchPasswordDialog("Login failed.\nPlease check your username and password.")) {
            return null;
        }
        return new String[]{this.getUsername(), this.getPassword()};
    }

    public void setNameAndPasswordAndServer(String string, char[] cArray, String string2) {
        String string3 = string;
        char[] cArray2 = cArray;
        String string4 = string2;
        this.userCredentials.setCredentials(string3, cArray2, string4);
    }

    @Override
    public void readPreferences(ObsToolUserPrefs obsToolUserPrefs) {
        String string = obsToolUserPrefs.getUserAuthenticationUsername();
        char[] cArray = null;
        String string2 = InitServices.getPropertyHandler().getProperty("ot.submission.host");
        this.userCredentials.setCredentials(string, cArray, string2);
    }

    @Override
    public void writePreferences(ObsToolUserPrefs obsToolUserPrefs) {
        obsToolUserPrefs.setUserAuthenticationUsername(this.userCredentials.getAccount());
    }

    public String getUsername() {
        return this.userCredentials.getAccount();
    }

    public String getPassword() {
        return new String(this.userCredentials.getPassword());
    }

    public String getServerUrl() {
        return this.userCredentials.getServerUrl();
    }

    public boolean areCredentialsGiven() {
        return this.userCredentials.isGiven();
    }

    public boolean launchPasswordDialog(String string) {
        boolean bl = this.showOnTheFlyDialog(string);
        return bl;
    }

    public CredentialPanel getCredentialPanel(boolean bl) {
        CredentialPanel credentialPanel = new CredentialPanel(bl);
        this.knownCredPanels.put(credentialPanel, null);
        return credentialPanel;
    }

    public void fillCredentialPanel(CredentialPanel credentialPanel) {
        credentialPanel.usernameField.setText(this.userCredentials.getAccount());
        String string = InitServices.getPropertyHandler().getProperty("alma.obsprep.password");
        if (string != null) {
            credentialPanel.passwordField.setText(string);
        } else {
            credentialPanel.passwordField.setText(new String(this.userCredentials.getPassword()));
        }
        credentialPanel.serverUrlField.setText(this.userCredentials.getServerUrl());
    }

    public void copyNewServerSettingOverToCredentialPanel(String string, CredentialPanel credentialPanel) {
        credentialPanel.serverUrlField.setText(string);
    }

    public void consumeCredentialPanel(CredentialPanel credentialPanel) {
        String string = credentialPanel.usernameField.getText();
        char[] cArray = credentialPanel.passwordField.getPassword();
        String string2 = credentialPanel.serverUrlField.getText();
        String string3 = new String(cArray);
        for (CredentialPanel credentialPanel2 : this.knownCredPanels.keySet()) {
            credentialPanel2.usernameField.setText(string);
            credentialPanel2.passwordField.setText(string3);
            credentialPanel2.serverUrlField.setText(string2);
        }
        this.userCredentials.setCredentials(string, cArray, string2);
    }

    private boolean showOnTheFlyDialog(String string) {
        if (this.onthefly == null) {
            this.onthefly = new OnTheFlyPanel();
        }
        this.fillCredentialPanel(this.onthefly.credPanel);
        this.returnValue = false;
        this.onthefly.lblAdditionalMessage.setText(string);
        if (this.onthefly.getX() == 0 && this.onthefly.getY() == 0) {
            this.onthefly.setLocationRelativeTo(this.onthefly.getOwner());
        }
        this.onthefly.credPanel.usernameField.requestFocusInWindow();
        this.onthefly.pack();
        this.onthefly.setVisible(true);
        if (this.returnValue) {
            this.consumeCredentialPanel(this.onthefly.credPanel);
        }
        return this.returnValue;
    }

    private void fireUserAuthenticationSettingsChanged() {
        for (UserAuthenticationSettingsChangeListener userAuthenticationSettingsChangeListener : this.ualis_ro) {
            userAuthenticationSettingsChangeListener.userAuthenticationSettingsChanged(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(UserAuthenticationSettingsChangeListener userAuthenticationSettingsChangeListener) {
        ArrayList<UserAuthenticationSettingsChangeListener> arrayList = this.ualis;
        synchronized (arrayList) {
            if (this.ualis.add(userAuthenticationSettingsChangeListener)) {
                this.ualis_ro = (List)this.ualis.clone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(UserAuthenticationSettingsChangeListener userAuthenticationSettingsChangeListener) {
        ArrayList<UserAuthenticationSettingsChangeListener> arrayList = this.ualis;
        synchronized (arrayList) {
            if (this.ualis.remove(userAuthenticationSettingsChangeListener)) {
                this.ualis_ro = (List)this.ualis.clone();
            }
        }
    }

    public static interface UserAuthenticationSettingsChangeListener {
        public void userAuthenticationSettingsChanged(UserAuthenticator var1);
    }

    public class CredentialPanel
    extends JPanel {
        private JPasswordField passwordField;
        private JLabel passwordLabel;
        private JButton searchButton;
        private JLabel usernameLabel;
        private JTextField usernameField;
        private JLabel serverUrlLabel;
        private JLabel serverUrlField;

        CredentialPanel(boolean bl) {
            this.initComponents();
            this.setName("Credentials");
            this.passwordField.setName("Credentials.passwordField");
            this.usernameField.setName("Credentials.uidTextField");
            this.serverUrlField.setName("Credentials.serverUrlField");
            this.searchButton.setName("Credentials.searchButton");
            if (bl) {
                this.searchButton.setVisible(false);
                this.usernameField.setEditable(false);
                this.usernameField.setEnabled(false);
                this.usernameField.setBorder(null);
                this.passwordField.setEditable(false);
                this.passwordField.setEnabled(false);
                this.passwordField.setBorder(null);
            }
        }

        private void initComponents() {
            this.usernameLabel = new JLabel();
            this.usernameField = new JTextField();
            this.searchButton = new JButton();
            this.passwordLabel = new JLabel();
            this.passwordField = new JPasswordField();
            this.serverUrlLabel = new JLabel();
            this.serverUrlField = new JLabel();
            this.usernameLabel.setText("ALMA ID");
            this.searchButton.setText("Search...");
            this.searchButton.setToolTipText("Click to search the ALMA User Repository");
            this.searchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CredentialPanel.this.searchButtonActionPerformed(actionEvent);
                }
            });
            this.passwordLabel.setText("Password");
            this.serverUrlLabel.setText("Server URL");
            GroupLayout groupLayout = new GroupLayout(this);
            this.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serverUrlLabel, GroupLayout.Alignment.TRAILING).addComponent(this.passwordLabel, GroupLayout.Alignment.TRAILING).addComponent(this.usernameLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.serverUrlField, -1, 256, Short.MAX_VALUE).addComponent(this.passwordField, -1, 256, Short.MAX_VALUE).addComponent(this.usernameField, -1, 256, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton).addContainerGap()));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usernameField, -2, -1, -2).addComponent(this.searchButton).addComponent(this.usernameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordField, -2, -1, -2).addComponent(this.passwordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverUrlField, -2, -1, -2).addComponent(this.serverUrlLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        }

        public void setServerURLField(String string) {
            this.serverUrlField.setText(string);
        }

        private void searchButtonActionPerformed(ActionEvent actionEvent) {
            List<Investigator> list = InvestigatorSearchDialog.showDialog(true, "Use ALMA ID");
            if (list.size() == 1) {
                Investigator investigator = list.get(0);
                this.usernameField.setText(investigator.getUserId());
            }
        }
    }

    class OnTheFlyPanel
    extends GuiFactory.Dialog {
        JButton btnOk = new JButton();
        JButton btnCancel = new JButton();
        JPanel pnl0 = new JPanel();
        JPanel pnl2 = new JPanel();
        CredentialPanel credPanel = UserAuthenticator.this.getCredentialPanel(false);
        Border brdDialog = new EmptyBorder(5, 5, 5, 5);
        Border brdMessage = new EmptyBorder(5, 5, 5, 5);
        JTextArea lblAdditionalMessage = new JTextArea();
        protected Action actOk = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserAuthenticator.this.returnValue = true;
                OnTheFlyPanel.this.setVisible(false);
            }
        };
        protected Action actCancel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OnTheFlyPanel.this.setVisible(false);
            }
        };

        OnTheFlyPanel() {
            this.setTitle("Please authenticate yourself");
            this.setModal(true);
            this.pnl0.setBorder(this.brdDialog);
            this.pnl0.add(this.lblAdditionalMessage);
            this.pnl0.add(this.credPanel);
            this.pnl2.add(this.btnOk);
            this.pnl2.add(this.btnCancel);
            this.pnl0.add(this.pnl2);
            this.add(this.pnl0);
            this.pnl0.setLayout(new BoxLayout(this.pnl0, 1));
            this.pnl0.add(Box.createVerticalStrut(10), 1);
            this.lblAdditionalMessage.setEditable(false);
            this.lblAdditionalMessage.setRows(6);
            this.lblAdditionalMessage.setColumns(40);
            this.lblAdditionalMessage.setLineWrap(true);
            this.lblAdditionalMessage.setWrapStyleWord(true);
            this.lblAdditionalMessage.setBorder(this.brdMessage);
            this.lblAdditionalMessage.setFocusable(false);
            this.actOk.putValue("Name", "Ok");
            this.actCancel.putValue("Name", "Cancel");
            this.btnOk.setAction(this.actOk);
            this.btnCancel.setAction(this.actCancel);
            super.setDefaultButton(this.btnOk);
        }
    }

    class Credentials {
        private volatile String account = "";
        private volatile char[] password = new char[0];
        private volatile String serverUrl = "";
        private volatile boolean revoked;

        Credentials() {
        }

        void setCredentials(String string, char[] cArray, String string2) {
            boolean bl;
            if (string == null) {
                string = "";
            }
            if (cArray == null) {
                cArray = new char[]{};
            }
            if (string2 == null) {
                string2 = "";
            }
            boolean bl2 = bl = this.account.equals(string) && Arrays.equals(this.password, cArray) && this.serverUrl.equals(string2);
            if (!this.serverUrl.equals(string2)) {
                Log.logger((Object)this).config("Running with server at " + string2);
            }
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = '\u0000';
            }
            this.account = string;
            this.password = cArray;
            this.serverUrl = string2;
            this.revoked = false;
            if (!bl) {
                UserAuthenticator.this.fireUserAuthenticationSettingsChanged();
            }
        }

        String getAccount() {
            return this.account;
        }

        char[] getPassword() {
            return this.password;
        }

        String getServerUrl() {
            return this.serverUrl;
        }

        boolean isGiven() {
            return !this.getAccount().isEmpty() && this.getPassword().length != 0;
        }

        void revoke() {
            this.revoked = true;
        }

        boolean isRevoked() {
            return this.revoked;
        }
    }
}

