/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.toplevel;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.data.ObsProjectData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.perspectives.PerspectiveRepository;
import alma.obsprep.obstooluserprefs.DialogSettings;
import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.obstooluserprefs.types.DefaultEditorTypeType;
import alma.obsprep.ot.actions.OTActions;
import alma.obsprep.ot.actions.Quitter;
import alma.obsprep.ot.gui.toplevel.AbstractObservingToolController;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.EditorManager;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.PreferencesListener;
import alma.obsprep.ot.gui.toplevel.ProjectBackupTimerAction;
import alma.obsprep.ot.gui.toplevel.ProjectFactory;
import alma.obsprep.ot.gui.toplevel.SplashScreen;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.ot.gui.toplevel.UserStartupDialog;
import alma.obsprep.ot.persistence.ProjectRepositoryHttp;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.roledirectory.OTOperation;
import alma.obsprep.services.experts.spectralline.SpectralLineCatalogue;
import alma.obsprep.services.network.NetworkService;
import alma.obsprep.services.network.NetworkServiceHandler;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.versioncheck.UpdateStatus;
import alma.obsprep.services.network.versioncheck.VersionCheckResult;
import alma.obsprep.services.network.versioncheck.VersionChecker;
import alma.obsprep.services.network.versioncheck.VersionCheckerService;
import alma.obsprep.services.userlookup.UserLookup;
import alma.obsprep.services.userlookup.UserLookupRemote;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.LoggingSetup;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.job.AbstractJob;
import alma.obsprep.util.job.ObsprepThreadGroup;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.exolab.castor.xml.CastorException;
import org.xml.sax.SAXException;

public class ObservingToolController
extends AbstractObservingToolController {
    static long modificationTimeOfPreferencesWhenImportedOrSaved;
    static File PREFERENCES_LOCATION;
    static File RESOURCES_LOCATION;
    static String COOKBOOK_HELPSET_NAME;
    static String COOKBOOK_HELPSET_DUMMY;
    static String REFMAN_HELPSET_NAME;
    static String REFMAN_HELPSET_DUMMY;
    static String USERMAN_HELPSET_NAME;
    static String USERMAN_HELPSET_DUMMY;
    static String QUICKSTART_HELPSET_NAME;
    static String QUICKSTART_HELPSET_DUMMY;
    private static ObservingToolController instance;
    private SplashScreen splash = null;
    private ArrayList<WeakReference<Quitter>> quitters = null;
    protected ObsToolUserPrefs preferencesModel;
    private final ArrayList<PreferencesListener> pcls = new ArrayList();
    private List<PreferencesListener> pcls_cc = Collections.EMPTY_LIST;
    private volatile AdvancedOptions advancedOptions = new AdvancedOptions(false, false, false, false);
    public ModuleHeap heap;

    public static ObservingToolController getMyInstance() {
        return instance;
    }

    public static ObservingToolGui getOTGui() {
        return ObservingToolController.getMyInstance().heap.getGui();
    }

    public ObservingToolController() {
        Locale.setDefault(Locale.ENGLISH);
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "35000");
        instance = this;
        this.heap();
    }

    public static void publishModelForBo(Class<?> clazz) {
        if (!ObservingToolController.isOTInBatchMode()) {
            ObservingToolGui observingToolGui = ObservingToolController.getOTGui();
            EditorManager editorManager = observingToolGui.getEditorManager();
            Model model = editorManager.modelFor(clazz);
            if (model == null) {
                throw new IllegalArgumentException("No model found for " + clazz);
            }
            model.publish();
        }
    }

    public static boolean isOTInBatchMode() {
        return ObservingToolController.getMyInstance() == null;
    }

    private void performAction(Action action) {
        if (!action.isEnabled()) {
            return;
        }
        ObservingToolController observingToolController = this;
        String string = (String)action.getValue("Name");
        action.actionPerformed(new ActionEvent(observingToolController, 1001, string));
    }

    public void mainProduction(String[] stringArray) {
        System.setProperty("apple.eawt.quitStrategy", "CLOSE_ALL_WINDOWS");
        SwingUtilities.invokeLater(() -> this.edtMainProduction(stringArray));
    }

    public void edtMainProduction(String[] stringArray) {
        try {
            Object object;
            super.init();
            Log.logger(ObservingToolController.class).info("Max heapSize (MB) : " + Runtime.getRuntime().maxMemory() / 1024L);
            GuiFactory guiFactory = GuiFactory.getFactory();
            this.splash = guiFactory.giveSplashScreen("ALMA Observing Tool " + InitServices.getUserVersion(), InitServices.getUserVersion());
            this.splash.display(true);
            this.splash.paintImmediately(this.splash.getBounds());
            this.splash.setMessage("Loading Resources...");
            AbstractJob abstractJob = this.jobLoadPreferences();
            abstractJob.go();
            CommandLineInstructions commandLineInstructions = this.evaluateCommandLine(stringArray);
            this.heap.setCommandLine(commandLineInstructions);
            this.heap.setGui(new ObservingToolGui(this));
            HelpSet helpSet = this.readHelpSet(COOKBOOK_HELPSET_NAME, COOKBOOK_HELPSET_DUMMY);
            this.heap.setCookbookHS(helpSet);
            helpSet = this.readHelpSet(REFMAN_HELPSET_NAME, REFMAN_HELPSET_DUMMY);
            this.heap.setReferenceManualHS(helpSet);
            helpSet = this.readHelpSet(USERMAN_HELPSET_NAME, USERMAN_HELPSET_DUMMY);
            this.heap.setUserManualHS(helpSet);
            helpSet = this.readHelpSet(QUICKSTART_HELPSET_NAME, QUICKSTART_HELPSET_DUMMY);
            this.heap.setQuickStartGuideHS(helpSet);
            this.splash.setMessage("Checking Server...");
            abstractJob = this.jobInitialApplyConnectionPreferences();
            abstractJob.go();
            abstractJob = this.jobInitialiseConnections();
            abstractJob.go();
            ReInitialiseConnections reInitialiseConnections = new ReInitialiseConnections();
            this.getUserAuthenticator().addChangeListener(reInitialiseConnections);
            this.splash.setMessage("Initialising Gui...");
            abstractJob = this.jobLoadPerspectives();
            abstractJob.go();
            abstractJob = this.getGui().jobBuildGui();
            abstractJob.go();
            abstractJob = this.jobInitialApplyGuiPreferences();
            abstractJob.go();
            ObsProject obsProject = ProjectFactory.emptyProject();
            this.heap.getGui().setPrimaryProject(obsProject, null, false);
            this.heap.getGui().getEditors().modelFor(ObsProject.class).setDocument(obsProject);
            if (obsProject.getStatus() == ObsProjectData.STATUS_NEWPHASE1) {
                object = ObservingToolController.getOTGui().activeProjectCompartment().getProjectTreePanels().getPhase1Tree();
                ProjectTreeNode projectTreeNode = ((ProjectTree)object).findNodeBelow(((ProjectTree)object).getTop(), ObsProposal.class);
                ((ProjectTree)object).select(new TreePath(projectTreeNode.getPath()));
            }
            object = this.getGui().getActiveProject();
            this.getGui().activeProjectCompartment().resetInitialObsProject((ObsProject)object);
            if (this.logger.config()) {
                this.logger.config("Loaded resources:\n" + MiscUtils.reportForFindResource());
            }
            this.splash.setMessage("Startup Complete.");
            this.splash.dispose();
            this.splash = null;
            abstractJob = this.jobCheckJavaVendor();
            abstractJob.go();
            abstractJob = this.jobUserStartupDialog();
            abstractJob.go();
            abstractJob = this.getGui().jobStart();
            abstractJob.go();
            abstractJob = this.jobCheckOTVersion();
            abstractJob.go();
            this.scheduleProjectFileBackups();
            if (InitServices.getPropertyHandler().getProperty("alma.obsprep.loadlastproject") != null) {
                MiscUtils.importLastProject();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            this.shutdown();
        }
    }

    private AbstractJob jobInitialiseConnections() {
        return new AbstractJob("initialise server connections", false){

            @Override
            public void job() throws MalformedURLException {
                String string = ObservingToolController.this.heap.getUserAuthenticator().getServerUrl();
                ProjectRepositoryHttp projectRepositoryHttp = ObservingToolController.this.heap.getProjectRepository();
                projectRepositoryHttp.setUrl(string);
                NetworkServiceHandler networkServiceHandler = ObservingToolController.this.heap.getNetworkServiceHandler();
                RoleDirectoryService roleDirectoryService = ObservingToolController.this.heap().getRoleDirectory();
                networkServiceHandler.addService(roleDirectoryService);
                if (roleDirectoryService.setServerUrl(string)) {
                    networkServiceHandler.goOnline(roleDirectoryService);
                }
                UserLookupRemote userLookupRemote = new UserLookupRemote();
                userLookupRemote.setUrl(string);
                ObservingToolController.this.heap.setUserLookup(userLookupRemote);
                VersionCheckerService versionCheckerService = (VersionCheckerService)ObservingToolController.this.heap.getVersionChecker();
                networkServiceHandler.addService(versionCheckerService);
                if (versionCheckerService.setUrl(string)) {
                    networkServiceHandler.goOnline(versionCheckerService);
                }
            }
        };
    }

    private void scheduleProjectFileBackups() {
        Timer timer = new Timer(600000, new ProjectBackupTimerAction());
        timer.setRepeats(true);
        timer.start();
    }

    private AbstractJob jobCheckOTVersion() {
        return new AbstractJob("check OT version", false){
            DialogId id;
            {
                this.id = new DialogId("OT Version Check");
            }

            @Override
            public void job() {
                VersionCheckResult versionCheckResult;
                VersionChecker versionChecker = ObservingToolController.this.heap.getVersionChecker();
                try {
                    versionCheckResult = versionChecker.check(InitServices.getFullAlmaVersion());
                }
                catch (IOException iOException) {
                    return;
                }
                UpdateStatus updateStatus = versionCheckResult.getStatus();
                if (updateStatus.isActionable()) {
                    String string = updateStatus.getNotice() + "\n" + updateStatus.getAction();
                    if (versionCheckResult.getUpdateUrl() != null) {
                        string = string + " available at " + versionCheckResult.getUpdateUrl();
                    }
                    if (UpdateStatus.CRITICAL.equals((Object)updateStatus)) {
                        GUIUtilities.error(null, string);
                    } else {
                        GUIUtilities.infoWithDoNotShowAgain(this.id, string);
                    }
                }
            }
        };
    }

    private AbstractJob jobCheckJavaVendor() {
        return new AbstractJob("check Java version", false){
            final DialogId id;
            {
                this.id = new DialogId("OT Java Check");
            }

            @Override
            public void job() {
                Properties properties = System.getProperties();
                String string = properties.getProperty("java.vm.name");
                String string2 = properties.getProperty("java.runtime.name");
                Log.logger(ObservingToolController.class).info("Java VM name : " + string);
                Log.logger(ObservingToolController.class).info("Java VM runtime : " + string2);
                if (!StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"OpenJDK")) {
                    String string3 = String.format("Java runtime is \"%s\": it's recommended for compatibility reasons to use the OpenJDK Java runtime environment", string2);
                    GUIUtilities.warning(this.id, string3);
                    Log.logger(ObservingToolController.class).warning(string3);
                }
            }
        };
    }

    protected CommandLineInstructions evaluateCommandLine(String[] stringArray) {
        int n;
        CommandLineInstructions commandLineInstructions = new CommandLineInstructions();
        try {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].trim().equals("-x")) {
                    commandLineInstructions.doSystemExitOnShutdown = false;
                    continue;
                }
                if (stringArray[n].trim().equals("-9")) {
                    commandLineInstructions.doRuntimeHaltOnShutdown = true;
                    continue;
                }
                this.logger.warning("command line argument unknown: '" + stringArray[n].trim() + "', ignoring.");
            }
        }
        catch (Exception exception) {
            this.logger.warning("command line invalid (problem with arg #" + n + "): " + Arrays.asList(stringArray));
        }
        return commandLineInstructions;
    }

    protected AbstractJob jobLoadPreferences() {
        return new AbstractJob("load preferences", true){

            @Override
            public void job() throws Exception {
                ObsToolUserPrefs obsToolUserPrefs = this.readPreferences();
                ObservingToolController.this.preferencesModel = obsToolUserPrefs = this.migratePreferences(obsToolUserPrefs);
            }

            protected ObsToolUserPrefs readPreferences() {
                File file = InitServices.ALMAOT_FOLDER;
                boolean bl = file.mkdirs();
                if (!file.exists() || !file.isDirectory()) {
                    ObservingToolController.this.logger.warning("preferences folder doesn't exist and can't be created: " + file.getPath());
                }
                if (bl && ObservingToolController.this.logger.config()) {
                    ObservingToolController.this.logger.config("preferences folder has been created: " + file.getPath());
                }
                if (!file.canRead() || !file.canWrite()) {
                    ObservingToolController.this.logger.warning("preferences folder can't be read or written: " + file.getPath());
                }
                ObsToolUserPrefs obsToolUserPrefs = null;
                if (!PREFERENCES_LOCATION.exists()) {
                    obsToolUserPrefs = new ObsToolUserPrefs();
                } else {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(PREFERENCES_LOCATION));
                        obsToolUserPrefs = ObsToolUserPrefs.unmarshalObsToolUserPrefs((Reader)bufferedReader);
                        modificationTimeOfPreferencesWhenImportedOrSaved = PREFERENCES_LOCATION.lastModified();
                    }
                    catch (Throwable throwable) {
                        ObservingToolController.this.logger.warning("Could not read user preferences; using default [due to " + ObservingToolController.this.createErrorMessage(throwable) + "]");
                        obsToolUserPrefs = new ObsToolUserPrefs();
                    }
                }
                obsToolUserPrefs.setDefaultEditorType(DefaultEditorTypeType.SPATIAL);
                return obsToolUserPrefs;
            }

            protected ObsToolUserPrefs migratePreferences(ObsToolUserPrefs obsToolUserPrefs) {
                if (obsToolUserPrefs.getFrameBounds() != null) {
                    obsToolUserPrefs.setFrameX(obsToolUserPrefs.getFrameBounds().getX());
                    obsToolUserPrefs.setFrameY(obsToolUserPrefs.getFrameBounds().getY());
                    obsToolUserPrefs.setFrameWidth(obsToolUserPrefs.getFrameBounds().getWidth());
                    obsToolUserPrefs.setFrameHeight(obsToolUserPrefs.getFrameBounds().getHeight());
                    obsToolUserPrefs.setFrameBounds(null);
                }
                if (obsToolUserPrefs.getPreferencesLocation() != null) {
                    obsToolUserPrefs.setPreferencesLocation(null);
                }
                if (obsToolUserPrefs.getLookAndFeel().equalsIgnoreCase("Skin")) {
                    obsToolUserPrefs.setLookAndFeel("Metal");
                }
                if (obsToolUserPrefs.getLookAndFeel().equalsIgnoreCase("Aqua")) {
                    obsToolUserPrefs.setLookAndFeel("Metal");
                }
                for (DialogSettings dialogSettings : obsToolUserPrefs.getDialogSettings()) {
                    if (dialogSettings.getSuppress()) continue;
                    obsToolUserPrefs.removeDialogSettings(dialogSettings);
                }
                if (obsToolUserPrefs.hasUserAuthenticationEnabled()) {
                    obsToolUserPrefs.deleteUserAuthenticationEnabled();
                }
                if (obsToolUserPrefs.getAcsManagerHost() != null) {
                    obsToolUserPrefs.setAcsManagerHost(null);
                }
                if (obsToolUserPrefs.getWebSubmissionHost() != null) {
                    obsToolUserPrefs.setWebSubmissionHost(null);
                }
                return obsToolUserPrefs;
            }
        };
    }

    protected String createErrorMessage(Throwable throwable) {
        Object object = null;
        if (throwable instanceof SAXException) {
            object = "SAXException";
            Exception exception = ((SAXException)throwable).getException();
            if (exception != null) {
                object = (String)object + " [" + this.createErrorMessage(exception) + "]";
            }
        } else if (throwable instanceof CastorException) {
            object = "CastorException";
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                object = (String)object + " [" + this.createErrorMessage(throwable2) + "]";
            }
        } else {
            object = throwable.getMessage();
            Throwable throwable3 = throwable.getCause();
            if (throwable3 != null) {
                object = (String)object + " [" + this.createErrorMessage(throwable3) + "]";
            }
        }
        return object;
    }

    public AbstractJob jobCollectAndSavePreferences() {
        return new AbstractJob("save preferences", false){

            @Override
            public void job() throws Exception {
                ObsToolUserPrefs obsToolUserPrefs = ObservingToolController.this.getPreferences();
                ObservingToolGui observingToolGui = ObservingToolController.this.getGui();
                observingToolGui.writePreferences(obsToolUserPrefs);
                UserAuthenticator userAuthenticator = ObservingToolController.this.getUserAuthenticator();
                userAuthenticator.writePreferences(obsToolUserPrefs);
                try {
                    boolean bl;
                    long l = PREFERENCES_LOCATION.lastModified();
                    if (l > modificationTimeOfPreferencesWhenImportedOrSaved && !(bl = GUIUtilities.confirm(null, "Preferences have been changed by another OT instance, do you want to overwrite them?"))) {
                        return;
                    }
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(PREFERENCES_LOCATION));
                    obsToolUserPrefs.marshal((Writer)bufferedWriter);
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    modificationTimeOfPreferencesWhenImportedOrSaved = PREFERENCES_LOCATION.lastModified();
                }
                catch (Exception exception) {
                    ObservingToolController.this.logger.log(Level.WARNING, "couldn't save preferences " + exception, (Throwable)exception);
                }
            }
        };
    }

    protected AbstractJob jobInitialApplyConnectionPreferences() {
        return new AbstractJob("apply connection preferences", true){

            @Override
            public void job() throws Exception {
                ObsToolUserPrefs obsToolUserPrefs = ObservingToolController.this.getPreferences();
                UserAuthenticator userAuthenticator = ObservingToolController.this.getUserAuthenticator();
                userAuthenticator.readPreferences(obsToolUserPrefs);
            }
        };
    }

    protected AbstractJob jobInitialApplyGuiPreferences() {
        return new AbstractJob("apply gui preferences", true){

            @Override
            public void job() throws Exception {
                ObsToolUserPrefs obsToolUserPrefs = ObservingToolController.this.getPreferences();
                ObservingToolGui observingToolGui = ObservingToolController.this.getGui();
                observingToolGui.readPreferences(obsToolUserPrefs);
                ObservingToolController.this.firePreferencesChanged();
            }
        };
    }

    protected AbstractJob jobUserStartupDialog() {
        return new AbstractJob("user startup dialog", true){

            @Override
            public void job() throws Exception {
                boolean bl = ObservingToolController.this.advancedOptions().isShowStaffActions();
                UserStartupDialog userStartupDialog = new UserStartupDialog((Frame)GuiFactory.getFactory().getParentWindow(), bl);
                UserStartupDialog.UserStartupChoice userStartupChoice = userStartupDialog.showOnTheFlyDialog();
                userStartupDialog.dispose();
                OTActions.ProjectTiedActions projectTiedActions = ObservingToolController.getOTGui().activeProjectCompartment().getProjectTiedActions();
                if (userStartupChoice == UserStartupDialog.UserStartupChoice.OPEN_PROJECT) {
                    ObservingToolController.this.performAction(projectTiedActions.open);
                } else if (userStartupChoice == UserStartupDialog.UserStartupChoice.RETRIEVE_PROJECT) {
                    ObservingToolController.this.performAction(projectTiedActions.retrieve);
                } else if (userStartupChoice == UserStartupDialog.UserStartupChoice.NEW_DDT_PROPOSAL) {
                    ObservingToolController.this.performAction(projectTiedActions.newDDTProposal);
                } else if (userStartupChoice == UserStartupDialog.UserStartupChoice.PHASEII_PROJECT) {
                    ObservingToolController.this.performAction(projectTiedActions.newProject);
                } else if (userStartupChoice == UserStartupDialog.UserStartupChoice.COMMISSION_PROJECT) {
                    ObservingToolController.this.performAction(projectTiedActions.newCommissioningProject);
                } else if (userStartupChoice == UserStartupDialog.UserStartupChoice.VLBI_PROJECT) {
                    ObservingToolController.this.performAction(projectTiedActions.newVLBIProject);
                } else if (userStartupChoice == UserStartupDialog.UserStartupChoice.SUPPLEMENTAL_CALL_PROJECT) {
                    ObservingToolController.this.performAction(projectTiedActions.newSupplementalCallProject);
                }
            }
        };
    }

    protected AbstractJob jobInitialiseSpectralLineCatalogue() {
        return new AbstractJob("Initialise spectral line catalogue", true){

            @Override
            public void job() {
                SpectralLineCatalogue.getInstance();
            }
        };
    }

    public AbstractJob jobLoadPerspectives() {
        return new AbstractJob("load perspectives", false){

            @Override
            public void job() {
                PerspectiveRepository perspectiveRepository = new PerspectiveRepository();
                ObservingToolController.this.heap.setPerspectiveRepository(perspectiveRepository);
                File file = InitServices.ALMAOT_FOLDER;
                perspectiveRepository.loadFromDirectory(file.getPath());
                if (ObservingToolController.this.logger.config()) {
                    ObservingToolController.this.logger.config("Perspectives loaded from " + file.getPath());
                }
            }
        };
    }

    private AbstractJob jobSavePerspectives() {
        return new AbstractJob("save perspectives", false){

            @Override
            public void job() throws Exception {
                File file = InitServices.ALMAOT_FOLDER;
                ObservingToolController.this.heap.getPerspectiveRepository().saveToDirectory(file.getPath());
                if (ObservingToolController.this.logger.config()) {
                    ObservingToolController.this.logger.config("Perspectives saved to " + file.getPath());
                }
            }
        };
    }

    public void shutdown() {
        this.logger.info("Shutting down...");
        this.splash = null;
        AbstractJob abstractJob = this.getGui().jobSaveCurrentPerspective();
        abstractJob.go();
        abstractJob = this.jobSavePerspectives();
        abstractJob.go();
        abstractJob = this.jobCollectAndSavePreferences();
        abstractJob.go();
        Thread thread = new Thread(ObsprepThreadGroup.getInstance(), () -> {
            AbstractJob abstractJob = this.getGui().jobStop();
            abstractJob.go();
            FieldID.clearRegistry();
            this.informQuitters();
            EventManager.finish();
            if (this.heap.getCommandLine().doSystemExitOnShutdown) {
                this.logger.info("Shutdown Complete.");
                System.exit(0);
            } else {
                instance = null;
                this.logger.info("Deallocation Complete.");
            }
        }, "OTC.Shutdown");
        if (this.heap.getCommandLine().doSystemExitOnShutdown && this.heap.getCommandLine().doRuntimeHaltOnShutdown) {
            this.logger.info("ObservingTool VM will be forcibly halted in about 5 seconds");
            Thread thread2 = new Thread(ObsprepThreadGroup.getInstance(), null, "OTC.Halter"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ObservingToolController.this.logger.info("ObservingTool VM still up, now halting it forcibly.");
                    Runtime.getRuntime().halt(0);
                }
            };
            thread2.setDaemon(true);
            thread2.start();
        }
        thread.setPriority(10);
        thread.start();
    }

    public void showPreferencesDialog(String string) {
        this.heap.getGui().dlgPreferences.show(string);
    }

    public void showAboutBox() {
        this.heap.getGui().showAboutBox();
    }

    public void showReleaseNotes() {
        this.heap.getGui().showReleaseNotes();
    }

    public ObservingToolGui getGui() {
        return this.heap.getGui();
    }

    protected PerspectiveRepository getPerspectiveRepository() {
        return this.heap.getPerspectiveRepository();
    }

    public UserAuthenticator getUserAuthenticator() {
        return this.heap.getUserAuthenticator();
    }

    public UserLookup getUserLookup() {
        return this.heap.getUserLookup();
    }

    public RoleDirectoryService getRoleDirectory() {
        return this.heap.getRoleDirectory();
    }

    protected HelpSet getCookbookHS() {
        return this.heap.getCookbookHS();
    }

    public HelpSet getReferenceManualHS() {
        return this.heap.getReferenceManualHS();
    }

    public HelpSet getUserManualHS() {
        return this.heap.getUserManualHS();
    }

    protected HelpSet getQuickStartGuideHS() {
        return this.heap.getQuickStartGuideHS();
    }

    public void showHelpCookbook() {
        this.heap.getGui().showHelpCookbook();
    }

    protected void showHelpCookbook(String string) {
        this.heap.getGui().showHelpCookbook(string);
    }

    public void showHelpReferenceManual() {
        this.heap.getGui().showHelpReferenceManual();
    }

    protected void showHelpReferenceManual(String string) {
        this.heap.getGui().showHelpReferenceManual(string);
    }

    public void showHelpUserManual() {
        this.heap.getGui().showHelpUserManual();
    }

    protected void showHelpUserManual(String string) {
        this.heap.getGui().showHelpUserManual(string);
    }

    public void showHelpQuickStartGuide() {
        this.heap.getGui().showHelpQuickStartGuide();
    }

    protected void showHelpQuickStartGuide(String string) {
        this.heap.getGui().showHelpQuickStartGuide(string);
    }

    protected void makeFrameTitle() {
        this.heap.getGui().makeFrameTitle();
    }

    protected HelpSet readHelpSet(String string, String string2) {
        HelpSet helpSet = null;
        ClassLoader classLoader = null;
        URL uRL = MiscUtils.findResource(null, string);
        if (uRL == null) {
            if (this.logger.config()) {
                this.logger.config("Real help set not found, falling back to dummy help set");
            }
            uRL = MiscUtils.findResource(null, string2);
        }
        try {
            helpSet = new HelpSet(classLoader, uRL);
        }
        catch (HelpSetException helpSetException) {
            if (this.logger.config()) {
                this.logger.config("help set at " + uRL + " is invalid: " + helpSetException);
            }
            return null;
        }
        return helpSet;
    }

    public void registerAsQuitter(Quitter quitter) {
        if (this.quitters == null) {
            this.quitters = new ArrayList();
        }
        this.quitters.add(new WeakReference<Quitter>(quitter));
    }

    protected void informQuitters() {
        if (this.quitters != null) {
            for (WeakReference<Quitter> weakReference : this.quitters) {
                if (weakReference == null) continue;
                Quitter quitter = (Quitter)weakReference.get();
                quitter.tidyBeforeQuit();
            }
        }
    }

    public ObsToolUserPrefs getPreferences() {
        return this.preferencesModel;
    }

    public void firePreferencesChanged() {
        List<PreferencesListener> list = this.pcls_cc;
        for (PreferencesListener preferencesListener : list) {
            preferencesListener.handlePreferencesChanged(this.preferencesModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferencesListener(PreferencesListener preferencesListener) {
        ArrayList<PreferencesListener> arrayList = this.pcls;
        synchronized (arrayList) {
            this.pcls.add(preferencesListener);
            this.pcls_cc = (List)this.pcls.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreferencesListener(PreferencesListener preferencesListener) {
        ArrayList<PreferencesListener> arrayList = this.pcls;
        synchronized (arrayList) {
            this.pcls.remove(preferencesListener);
            this.pcls_cc = (List)this.pcls.clone();
        }
    }

    public AdvancedOptions advancedOptions() {
        return this.advancedOptions;
    }

    void advancedOptionsReassess() {
        try {
            this.advancedOptions = this.advancedOptionsAssess();
        }
        catch (IOException iOException) {
            this.logger.log(Level.SEVERE, "Error finding user privileges from role web service", (Throwable)iOException);
        }
    }

    public AdvancedOptions advancedOptionsAssess() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = this.getPreferences().getAdvancedUser();
        if (bl5) {
            RoleDirectoryService roleDirectoryService = this.getRoleDirectory();
            bl = roleDirectoryService.canExecute(OTOperation.ENABLE_ADVANCED_OPTIONS);
            bl2 = roleDirectoryService.canExecute(OTOperation.NEW_COMMISSIONING_PROJECT);
            bl3 = roleDirectoryService.canExecute(OTOperation.CREATE_OBSERVATORY_GOAL);
            boolean bl6 = this.getPreferences().getDebugMenuVisible();
            bl4 = bl6 && bl;
        }
        return new AdvancedOptions(bl, bl2, bl3, bl4);
    }

    @Override
    public ModuleHeap heap() {
        if (((AbstractObservingToolController)this).heap == null) {
            this.heap = new ModuleHeap();
            ((AbstractObservingToolController)this).heap = this.heap;
        }
        return (ModuleHeap)((AbstractObservingToolController)this).heap;
    }

    public ObsProject getPrimaryProject() {
        return ObservingToolController.getOTGui().getPrimaryProject();
    }

    static {
        PREFERENCES_LOCATION = new File(InitServices.ALMAOT_FOLDER, "preferences.xml");
        RESOURCES_LOCATION = new File("alma/obsprep/ot/gui/resources");
        COOKBOOK_HELPSET_NAME = "ALMA-OT-Cookbook.hs";
        COOKBOOK_HELPSET_DUMMY = "dummyhelp/ObservingTool.hs";
        REFMAN_HELPSET_NAME = "ALMA-OT-RefManual.hs";
        REFMAN_HELPSET_DUMMY = "dummyhelp/ObservingTool.hs";
        USERMAN_HELPSET_NAME = "ALMA-OT-UserManual.hs";
        USERMAN_HELPSET_DUMMY = "dummyhelp/ObservingTool.hs";
        QUICKSTART_HELPSET_NAME = "ALMA-OT-QuickStartGuide.hs";
        QUICKSTART_HELPSET_DUMMY = "dummyhelp/ObservingTool.hs";
    }

    class LogToFeedbackConnect
    extends Handler {
        LoggingSetup.LoggingTerseFormat formatter = new LoggingSetup.LoggingTerseFormat();
        int threshold = Level.WARNING.intValue();

        LogToFeedbackConnect() {
        }

        @Override
        public void publish(LogRecord logRecord) {
            Level level = logRecord.getLevel();
            if (level.intValue() >= this.threshold && ObservingToolController.this.heap.getGui() != null) {
                String string = this.formatter.format(logRecord);
                ObservingToolController.this.heap.getGui().addLoggingMessage(string);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    class CommandLineInstructions {
        boolean doSystemExitOnShutdown = true;
        boolean doRuntimeHaltOnShutdown = false;

        CommandLineInstructions() {
        }
    }

    public class ModuleHeap
    extends AbstractObservingToolController.ModuleHeap {
        private CommandLineInstructions commandLine;
        private ObservingToolGui gui;
        private HelpSet userManualHS;
        private HelpSet quickStartGuideHS;
        private HelpSet referenceManualHS;
        private HelpSet cookbookHS;
        private PerspectiveRepository perspectiveRepository;
        private UserLookup userLookup;
        private final NetworkServiceHandler nsh;

        public ModuleHeap() {
            super(ObservingToolController.this);
            this.referenceManualHS = null;
            this.nsh = new NetworkServiceHandler();
        }

        public CommandLineInstructions getCommandLine() {
            return this.commandLine;
        }

        protected void setCommandLine(CommandLineInstructions commandLineInstructions) {
            this.commandLine = commandLineInstructions;
            this.firePropertyChange("commandLine", this.commandLine);
        }

        public ObservingToolGui getGui() {
            return this.gui;
        }

        protected void setGui(ObservingToolGui observingToolGui) {
            this.gui = observingToolGui;
            this.firePropertyChange("gui", this.gui);
        }

        public HelpSet getUserManualHS() {
            return this.userManualHS;
        }

        protected void setUserManualHS(HelpSet helpSet) {
            this.userManualHS = helpSet;
            this.firePropertyChange("userManualHelpSet", this.userManualHS);
        }

        public HelpSet getQuickStartGuideHS() {
            return this.quickStartGuideHS;
        }

        protected void setQuickStartGuideHS(HelpSet helpSet) {
            this.quickStartGuideHS = helpSet;
            this.firePropertyChange("quickStartGuideHelpSet", this.quickStartGuideHS);
        }

        public HelpSet getReferenceManualHS() {
            if (this.referenceManualHS == null) {
                this.referenceManualHS = ObservingToolController.this.readHelpSet(REFMAN_HELPSET_NAME, REFMAN_HELPSET_DUMMY);
            }
            return this.referenceManualHS;
        }

        protected void setReferenceManualHS(HelpSet helpSet) {
            this.referenceManualHS = helpSet;
            this.firePropertyChange("referenceManualHelpSet", this.referenceManualHS);
        }

        public HelpSet getCookbookHS() {
            return this.cookbookHS;
        }

        protected void setCookbookHS(HelpSet helpSet) {
            this.cookbookHS = helpSet;
            this.firePropertyChange("cookbookHelpSet", this.cookbookHS);
        }

        public PerspectiveRepository getPerspectiveRepository() {
            return this.perspectiveRepository;
        }

        protected void setPerspectiveRepository(PerspectiveRepository perspectiveRepository) {
            this.perspectiveRepository = perspectiveRepository;
            this.firePropertyChange("perspectiveRepository", this.perspectiveRepository);
        }

        public UserLookup getUserLookup() {
            return this.userLookup;
        }

        public void setUserLookup(UserLookup userLookup) {
            this.userLookup = userLookup;
            this.firePropertyChange("userLookup", this.userLookup);
        }

        public NetworkServiceHandler getNetworkServiceHandler() {
            return this.nsh;
        }
    }

    public static class AdvancedOptions {
        private final boolean showStaffActions;
        private final boolean showNewProject;
        private final boolean showCreateGoal;
        private final boolean showDebugMenu;

        public AdvancedOptions(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.showStaffActions = bl;
            this.showNewProject = bl2;
            this.showCreateGoal = bl3;
            this.showDebugMenu = bl4;
        }

        public boolean isShowStaffActions() {
            return this.showStaffActions;
        }

        public boolean isShowNewProject() {
            return this.showNewProject;
        }

        public boolean isShowCreateGoal() {
            return this.showCreateGoal;
        }

        public boolean isShowDebugMenu() {
            return this.showDebugMenu;
        }
    }

    private class ReInitialiseConnections
    implements UserAuthenticator.UserAuthenticationSettingsChangeListener {
        private ReInitialiseConnections() {
        }

        @Override
        public void userAuthenticationSettingsChanged(final UserAuthenticator userAuthenticator) {
            SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
                private JDialog progress;

                @Override
                protected Void doInBackground() throws Exception {
                    String string = userAuthenticator.getServerUrl();
                    ProjectRepositoryHttp projectRepositoryHttp = ObservingToolController.this.heap.getProjectRepository();
                    projectRepositoryHttp.setUrl(string);
                    NetworkServiceHandler networkServiceHandler = ObservingToolController.this.heap.getNetworkServiceHandler();
                    try {
                        Object object;
                        RoleDirectoryService roleDirectoryService = networkServiceHandler.getService(RoleDirectoryService.class);
                        if (roleDirectoryService.setServerUrl(string)) {
                            this.publish(new Void[0]);
                            networkServiceHandler.goOnline(roleDirectoryService);
                        }
                        try {
                            object = userAuthenticator.getUsername();
                            String string2 = userAuthenticator.getPassword();
                            roleDirectoryService.setCredentials((String)object, string2);
                            roleDirectoryService.goOnline();
                            roleDirectoryService.login();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        try {
                            object = (UserLookupRemote)ObservingToolController.this.getUserLookup();
                            ((UserLookupRemote)object).setUrl(string);
                        }
                        catch (Exception exception) {
                            ObservingToolController.this.logger.config("Failed to configure UserLookup with new submission host setting: " + exception);
                        }
                        object = networkServiceHandler.getService(VersionCheckerService.class);
                        if (((VersionCheckerService)object).setUrl(string)) {
                            this.publish(new Void[0]);
                            networkServiceHandler.goOnline((NetworkService)object);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        GUIUtilities.error(null, string + "is not a valid URL.\nPlease check the Server URL in the connection preferences.");
                    }
                    return null;
                }

                @Override
                protected void process(List<Void> list) {
                    if (this.progress == null) {
                        this.progress = new JDialog(ObservingToolController.this.getGui().frame, "Checking Server...", false);
                        this.progress.add(new JLabel("\n\n  Server settings changed, connecting to new server ...  \n\n"));
                        this.progress.pack();
                        this.progress.setLocationByPlatform(true);
                        this.progress.setVisible(true);
                        ObservingToolController.this.logger.config("Server settings changed, connecting to new server...");
                    }
                }

                @Override
                protected void done() {
                    if (this.progress != null) {
                        this.progress.dispose();
                    }
                }
            };
            swingWorker.execute();
        }
    }
}

