/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.resources;

import alma.obsprep.ot.gui.resources.ColorPalette;
import alma.obsprep.util.OrderedMap;
import alma.obsprep.util.OrderedSet;
import java.awt.Color;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Colors
implements ColorPalette {
    public static final String FOREGROUND = "Foreground";
    public static final String CLIPBOARD = "Clipboard";
    public static final String ERROR = "Error";
    public static final String WARNING = "Warning";
    public static final String PHASE1 = "Phase1";
    public static final String PHASE2 = "Phase2";
    public static final String DDT = "DDT";
    public static final String COMMISSION = "Commission";
    public static final String VLBI = "VLBI";
    public static final String ACASUPPLEMENTALCALL = "ACASUPPLEMENTAL";
    public static final String REST_FREQUENCY = "Rest Frequency";
    public static final String CENTRE_FREQUENCY = "Centre Frequency";
    public static final String CATALOG_LINES = "Catalog Lines";
    public static final String SIDEBANDS = "Sidebands";
    public static final String SIDEBANDS_UNCONFIG = "Sidebands(Unconfigured)";
    public static final String ZOOMBOX = "Zoom Box";
    public static final String BASEBAND = "Baseband";
    public static final String SPECTRAL_WINDOW = "Spectral Window";
    public static final String AVERAGING_REGION = "Averaging Region";
    public static final String SUPPRESSED = "Suppressed Windows";
    public static final String TRANSMISSION = "Transmission Spectrum";
    public static final String FOV = "FOV";
    public static final String FOVMAINFLUX = "FOV 1/3 HPBW";
    private static Colors defaultColors = new Colors(false);
    private SortedMap<String, Color> colors = new TreeMap<String, Color>();

    public static Color transparentColor(Color color, int n) {
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
        return color2;
    }

    private void setSupplementalCall(Color color) {
        this.colors.put(ACASUPPLEMENTALCALL, color);
    }

    public Color getSupplementalCallColor() {
        Color color = this.getColor(ACASUPPLEMENTALCALL);
        if (color == null) {
            color = this.getDefaultSupplementalCallColor();
        }
        return color;
    }

    private Color getDefaultSupplementalCallColor() {
        return defaultColors.getDefaultSupplementalCallColor();
    }

    private void setVLBIColor(Color color) {
        this.colors.put(VLBI, color);
    }

    public static Color transparentColor(Color color) {
        return Colors.transparentColor(color, 127);
    }

    public static Color getDefaultClipboard() {
        return defaultColors.getClipboardColor();
    }

    public static Color getDefaultError() {
        return defaultColors.getErrorColor();
    }

    public static Color getDefaultWarning() {
        return defaultColors.getWarningColor();
    }

    public static Color getDefaultPhase1() {
        return defaultColors.getPhase1Color();
    }

    public static Color getDefaultDDT() {
        return defaultColors.getDDTColor();
    }

    public static Color getDefaultVLBI() {
        return defaultColors.getVLBIColor();
    }

    public Color getVLBIColor() {
        Color color = this.getColor(VLBI);
        if (color == null) {
            color = Colors.getDefaultVLBI();
        }
        return color;
    }

    public static Color getDefaultFOV() {
        return defaultColors.getFOVColor();
    }

    public static Color getDefaultFOVMainFlux() {
        return defaultColors.getFOVMainFluxColor();
    }

    public static Color getDefaultPhase2() {
        return defaultColors.getPhase2Color();
    }

    public static Color getDefaultCommission() {
        return defaultColors.getCommissionColor();
    }

    public static Color getDefaultRestFrequency() {
        return defaultColors.getRestFrequencyColor();
    }

    public static Color getDefaultCentreFrequency() {
        return defaultColors.getCentreFrequencyColor();
    }

    public static Color getDefaultCatalogLines() {
        return defaultColors.getCatalogLinesColor();
    }

    public static Color getDefaultSidebands() {
        return defaultColors.getSidebandsColor();
    }

    public static Color getDefaultUnconfiguredSidebands() {
        return defaultColors.getUnconfiguredSidebandsColor();
    }

    public static Color getDefaultZoomBox() {
        return defaultColors.getZoomBoxColor();
    }

    public static Color getDefaultForeground() {
        return defaultColors.getForegroundColor();
    }

    public static Color getDefaultBaseband() {
        return defaultColors.getBasebandColor();
    }

    public static Color getDefaultSpectralWindow() {
        return defaultColors.getSpectralWindowColor();
    }

    public static Color getDefaultAveragingRegion() {
        return defaultColors.getAveragingRegionColor();
    }

    public static Color getDefaultSuppressed() {
        return defaultColors.getSuppressedColor();
    }

    public static Color getDefaultTransmission() {
        return defaultColors.getTransmissionColor();
    }

    public static Map<String, OrderedSet<String>> colourGroups() {
        OrderedMap<String, OrderedSet<String>> orderedMap = new OrderedMap<String, OrderedSet<String>>();
        OrderedSet<String> orderedSet = new OrderedSet<String>();
        orderedSet.add(FOREGROUND);
        orderedSet.add(CLIPBOARD);
        orderedSet.add(ERROR);
        orderedSet.add(WARNING);
        orderedSet.add(PHASE1);
        orderedSet.add(PHASE2);
        orderedSet.add(DDT);
        orderedSet.add(VLBI);
        orderedSet.add(FOV);
        orderedSet.add(FOVMAINFLUX);
        orderedMap.put("General", orderedSet);
        orderedSet = new OrderedSet();
        orderedSet.add(BASEBAND);
        orderedSet.add(SPECTRAL_WINDOW);
        orderedSet.add(AVERAGING_REGION);
        orderedSet.add(SUPPRESSED);
        orderedSet.add(REST_FREQUENCY);
        orderedSet.add(CENTRE_FREQUENCY);
        orderedSet.add(CATALOG_LINES);
        orderedSet.add(SIDEBANDS);
        orderedSet.add(SIDEBANDS_UNCONFIG);
        orderedSet.add(TRANSMISSION);
        orderedMap.put("Spectral Display", orderedSet);
        return orderedMap;
    }

    private Colors(boolean bl) {
        if (bl) {
            Iterator<String> iterator = defaultColors.colorSet();
            while (iterator.hasNext()) {
                String string = iterator.next();
                this.setColor(string, defaultColors.getColor(string));
            }
        }
    }

    public Colors() {
        this(true);
    }

    public Iterator<String> colorSet() {
        return this.colors.keySet().iterator();
    }

    public Color setColor(String string, Color color) {
        return this.colors.put(string, color);
    }

    public Color getColor(String string) {
        return (Color)this.colors.get(string);
    }

    public void setForegroundColor(Color color) {
        this.colors.put(FOREGROUND, color);
    }

    @Override
    public Color getForegroundColor() {
        Color color = this.getColor(FOREGROUND);
        if (color == null) {
            color = Colors.getDefaultForeground();
        }
        return color;
    }

    public void setClipboardColor(Color color) {
        this.colors.put(CLIPBOARD, color);
    }

    @Override
    public Color getClipboardColor() {
        Color color = this.getColor(CLIPBOARD);
        if (color == null) {
            color = Colors.getDefaultClipboard();
        }
        return color;
    }

    public void setErrorColor(Color color) {
        this.colors.put(ERROR, color);
    }

    @Override
    public Color getErrorColor() {
        Color color = this.getColor(ERROR);
        if (color == null) {
            color = Colors.getDefaultError();
        }
        return color;
    }

    public void setWarningColor(Color color) {
        this.colors.put(WARNING, color);
    }

    @Override
    public Color getWarningColor() {
        Color color = this.getColor(WARNING);
        if (color == null) {
            color = Colors.getDefaultWarning();
        }
        return color;
    }

    public void setPhase1Color(Color color) {
        this.colors.put(PHASE1, color);
    }

    public void setDDTColor(Color color) {
        this.colors.put(DDT, color);
    }

    public Color getDDTColor() {
        Color color = this.getColor(DDT);
        if (color == null) {
            color = Colors.getDefaultDDT();
        }
        return color;
    }

    public void setFOVColor(Color color) {
        this.colors.put(FOV, color);
    }

    public Color getFOVColor() {
        Color color = this.getColor(FOV);
        if (color == null) {
            color = Colors.getDefaultFOV();
        }
        return color;
    }

    public void setFOVMainFluxColor(Color color) {
        this.colors.put(FOVMAINFLUX, color);
    }

    public Color getFOVMainFluxColor() {
        Color color = this.getColor(FOVMAINFLUX);
        if (color == null) {
            color = Colors.getDefaultFOVMainFlux();
        }
        return color;
    }

    @Override
    public Color getPhase1Color() {
        Color color = this.getColor(PHASE1);
        if (color == null) {
            color = Colors.getDefaultPhase1();
        }
        return color;
    }

    public void setPhase2Color(Color color) {
        this.colors.put(PHASE2, color);
    }

    @Override
    public Color getPhase2Color() {
        Color color = this.getColor(PHASE2);
        if (color == null) {
            color = Colors.getDefaultPhase2();
        }
        return color;
    }

    public void setCommissionColor(Color color) {
        this.colors.put(COMMISSION, color);
    }

    public Color getCommissionColor() {
        Color color = this.getColor(COMMISSION);
        if (color == null) {
            color = Colors.getDefaultCommission();
        }
        return color;
    }

    public void setRestFrequencyColor(Color color) {
        this.colors.put(REST_FREQUENCY, color);
    }

    @Override
    public Color getRestFrequencyColor() {
        Color color = this.getColor(REST_FREQUENCY);
        if (color == null) {
            color = Colors.getDefaultRestFrequency();
        }
        return color;
    }

    public void setCentreFrequencyColor(Color color) {
        this.colors.put(CENTRE_FREQUENCY, color);
    }

    @Override
    public Color getCentreFrequencyColor() {
        Color color = this.getColor(CENTRE_FREQUENCY);
        if (color == null) {
            color = Colors.getDefaultCentreFrequency();
        }
        return color;
    }

    public void setCatalogLinesColor(Color color) {
        this.colors.put(CATALOG_LINES, color);
    }

    @Override
    public Color getCatalogLinesColor() {
        Color color = this.getColor(CATALOG_LINES);
        if (color == null) {
            color = Colors.getDefaultCatalogLines();
        }
        return color;
    }

    public void setSidebandsColor(Color color) {
        this.colors.put(SIDEBANDS, color);
    }

    @Override
    public Color getSidebandsColor() {
        Color color = this.getColor(SIDEBANDS);
        if (color == null) {
            color = Colors.getDefaultSidebands();
        }
        return color;
    }

    public void setUnconfiguredSidebandsColor(Color color) {
        this.colors.put(SIDEBANDS_UNCONFIG, color);
    }

    @Override
    public Color getUnconfiguredSidebandsColor() {
        Color color = this.getColor(SIDEBANDS_UNCONFIG);
        if (color == null) {
            color = Colors.getDefaultUnconfiguredSidebands();
        }
        return color;
    }

    public void setZoomBoxColor(Color color) {
        this.colors.put(ZOOMBOX, color);
    }

    @Override
    public Color getZoomBoxColor() {
        Color color = this.getColor(ZOOMBOX);
        if (color == null) {
            color = Colors.getDefaultZoomBox();
        }
        return color;
    }

    public void setBasebandColor(Color color) {
        this.colors.put(BASEBAND, color);
    }

    @Override
    public Color getBasebandColor() {
        Color color = this.getColor(BASEBAND);
        if (color == null) {
            color = Colors.getDefaultBaseband();
        }
        return color;
    }

    public void setSpectralWindowColor(Color color) {
        this.colors.put(SPECTRAL_WINDOW, color);
    }

    @Override
    public Color getSpectralWindowColor() {
        Color color = this.getColor(SPECTRAL_WINDOW);
        if (color == null) {
            color = Colors.getDefaultSpectralWindow();
        }
        return color;
    }

    public void setAveragingRegionColor(Color color) {
        this.colors.put(AVERAGING_REGION, color);
    }

    @Override
    public Color getAveragingRegionColor() {
        Color color = this.getColor(AVERAGING_REGION);
        if (color == null) {
            color = Colors.getDefaultAveragingRegion();
        }
        return color;
    }

    public void setSuppressedColor(Color color) {
        this.colors.put(SUPPRESSED, color);
    }

    @Override
    public Color getSuppressedColor() {
        Color color = this.getColor(SUPPRESSED);
        if (color == null) {
            color = Colors.getDefaultSuppressed();
        }
        return color;
    }

    public void setTransmissionColor(Color color) {
        this.colors.put(TRANSMISSION, color);
    }

    @Override
    public Color getTransmissionColor() {
        Color color = this.getColor(TRANSMISSION);
        if (color == null) {
            color = Colors.getDefaultTransmission();
        }
        return color;
    }

    static {
        defaultColors.setForegroundColor(Color.BLACK);
        defaultColors.setClipboardColor(Color.MAGENTA);
        defaultColors.setErrorColor(Color.RED);
        defaultColors.setWarningColor(Color.ORANGE);
        defaultColors.setPhase1Color(new Color(138, 226, 52));
        defaultColors.setDDTColor(new Color(249, 112, 108));
        defaultColors.setVLBIColor(new Color(118, 181, 155));
        defaultColors.setSupplementalCall(new Color(130, 210, 254));
        defaultColors.setPhase2Color(new Color(150, 185, 225));
        defaultColors.setCommissionColor(new Color(173, 127, 168));
        defaultColors.setFOVColor(Color.GREEN);
        defaultColors.setFOVMainFluxColor(Color.RED);
        defaultColors.setRestFrequencyColor(new Color(102, 153, 255));
        defaultColors.setCentreFrequencyColor(Color.RED);
        defaultColors.setCatalogLinesColor(Color.GREEN);
        defaultColors.setSidebandsColor(Color.ORANGE);
        defaultColors.setUnconfiguredSidebandsColor(new Color(200, 200, 175));
        defaultColors.setZoomBoxColor(new Color(0, 64, 128, 95));
        defaultColors.setBasebandColor(Color.GREEN.darker());
        defaultColors.setSpectralWindowColor(Color.BLUE.darker());
        defaultColors.setAveragingRegionColor(Color.LIGHT_GRAY);
        defaultColors.setSuppressedColor(Color.GRAY);
        defaultColors.setTransmissionColor(Color.GRAY);
    }
}

