/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.preferences;

import alma.obsprep.obstooluserprefs.DialogSettings;
import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.preferences.AbstractPanel;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import alma.obsprep.util.GUIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class DialogsPanel
extends AbstractPanel
implements PreferencesReadWrite {
    JPanel pnlStripe1 = new JPanel();
    JTable tblDialogs;
    TableModel tableModel;
    private Vector<TableRow> rows = new Vector();

    public DialogsPanel(ObservingToolGui observingToolGui) {
        this.initialize();
    }

    void initialize() {
        this.setName("DialogPrefs");
        this.pnlStripe1.setLayout(new BorderLayout());
        this.tableModel = new TableModel();
        this.tblDialogs = new Table(this.tableModel);
        this.tblDialogs.setName("DialogPrefs.tblDialogs");
        this.tblDialogs.setToolTipText("Uncheck boxes to turn off dialogs");
        this.tblDialogs.setShowVerticalLines(false);
        this.tblDialogs.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tableColumnModel = this.tblDialogs.getColumnModel();
        tableColumnModel.getColumn(0).setMaxWidth(25);
        JScrollPane jScrollPane = new JScrollPane(this.tblDialogs, 20, 31);
        this.pnlStripe1.add((Component)jScrollPane, "Center");
        this.addStripe("Wanted Dialogs", this.pnlStripe1, false);
    }

    @Override
    public void readPreferences(ObsToolUserPrefs obsToolUserPrefs) {
        Vector<TableRow> vector = new Vector<TableRow>();
        for (DialogId dialogId : GUIUtilities.dialogIds()) {
            DialogSettings dialogSettings = GUIUtilities.dialogSettings(dialogId);
            vector.add(new TableRow(dialogSettings.getDialogId(), dialogSettings.getDescription(), dialogSettings.getSuppress(), dialogSettings.getAutoanswer()));
        }
        this.rows = vector;
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public void writePreferences(ObsToolUserPrefs obsToolUserPrefs) {
        if (this.rows.isEmpty()) {
            this.readPreferences(obsToolUserPrefs);
        }
        obsToolUserPrefs.clearDialogSettings();
        for (TableRow tableRow : this.rows) {
            if (!tableRow.suppress) continue;
            DialogSettings dialogSettings = new DialogSettings();
            dialogSettings.setDialogId(tableRow.name);
            dialogSettings.setDescription(tableRow.description);
            dialogSettings.setSuppress(tableRow.suppress);
            dialogSettings.setAutoanswer(tableRow.answer);
            obsToolUserPrefs.addDialogSettings(dialogSettings);
        }
    }

    private class TableModel
    extends AbstractTableModel {
        private TableModel() {
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "  ";
                }
                case 1: {
                    return "Dialog";
                }
            }
            return "???";
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DialogsPanel.this.rows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TableRow tableRow = DialogsPanel.this.rows.get(n);
            switch (n2) {
                case 0: {
                    return tableRow.suppress ? Boolean.FALSE : Boolean.TRUE;
                }
                case 1: {
                    return tableRow.description;
                }
            }
            return "???";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            TableRow tableRow = DialogsPanel.this.rows.get(n);
            switch (n2) {
                case 0: {
                    tableRow.suppress = (Boolean)object == false;
                }
            }
        }
    }

    private class TableRow {
        String name;
        String description;
        boolean suppress;
        int answer;

        TableRow(String string, String string2, boolean bl, int n) {
            this.name = string;
            this.description = string2;
            this.suppress = bl;
            this.answer = n;
        }
    }
}

