/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.preferences;

import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.ot.actions.OusComponentProtect;
import alma.obsprep.ot.gui.preferences.AbstractPanel;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.PreferencesDialog;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class AdvancedPanel
extends AbstractPanel
implements PreferencesReadWrite {
    private ObservingToolController controller = null;
    private PreferencesDialog prefsDialogue = null;
    JPanel pnlAdvancedUserVisible = new JPanel();
    JPanel pnlDebugMenuVisible = new JPanel();
    JPanel pnlWriteProtection = new JPanel();
    JPanel pnlUseBLCorrForAca = new JPanel();
    JPanel stripeDebugMenuVisible = null;
    JPanel stripeUseBLCorrForAca = null;
    JCheckBox chkAdvancedUserVisible = new JCheckBox();
    JCheckBox chkDebugMenuVisible = new JCheckBox();
    JCheckBox chkOusWriteProtection = new JCheckBox();
    JCheckBox chkUseBLCorrForAca = new JCheckBox();

    public AdvancedPanel(ObservingToolController observingToolController, ObservingToolGui observingToolGui, PreferencesDialog preferencesDialog) {
        this.initialize(observingToolGui);
        this.setName("AdvancedPrefs");
        this.controller = observingToolController;
        this.prefsDialogue = preferencesDialog;
    }

    void initialize(ObservingToolGui observingToolGui) {
        this.chkAdvancedUserVisible.setName("AdvancedPrefs.chkAdvancedUserVisible");
        this.chkDebugMenuVisible.setName("AdvancedPrefs.chkDebugMenuVisible");
        this.chkOusWriteProtection.setName("AdvancedPrefs.chkOusWriteProtection");
        this.chkUseBLCorrForAca.setName("AdvancedPrefs.chkUseBLCorrForAca");
        this.pnlAdvancedUserVisible.setLayout(new FlowLayout(0));
        this.chkAdvancedUserVisible.setText("<html>Enable privileged operations<br>(This requires network access)</html>");
        this.pnlAdvancedUserVisible.add(this.chkAdvancedUserVisible);
        this.pnlDebugMenuVisible.setLayout(new FlowLayout(0));
        this.chkDebugMenuVisible.setText("Yes, make visible");
        this.chkDebugMenuVisible.setMnemonic(89);
        this.pnlDebugMenuVisible.add(this.chkDebugMenuVisible);
        this.pnlUseBLCorrForAca.setLayout(new FlowLayout(0));
        this.chkUseBLCorrForAca.setText("<html>Use BL Correlator for ACA SBs<br>(If checked, by default ACA and TP SBs are generated with BL Correlator setups</html>");
        this.chkUseBLCorrForAca.setMnemonic(66);
        this.pnlUseBLCorrForAca.add(this.chkUseBLCorrForAca);
        this.pnlWriteProtection.setLayout(new FlowLayout(0));
        this.chkOusWriteProtection.setText("<html>Enable OUS Write Protection<br>(If checked, by default ObsUnitSets and their SBs are readonly, uncheck to edit them)</html>");
        this.chkOusWriteProtection.setMnemonic(80);
        this.pnlWriteProtection.add(this.chkOusWriteProtection);
        this.addStripe("Advanced user features", this.pnlAdvancedUserVisible, false);
        this.stripeUseBLCorrForAca = this.addStripe("Use BL Correlator for ACA SBs", this.pnlUseBLCorrForAca, false);
        this.addStripe("OUS Write Protection", this.pnlWriteProtection, false);
        this.stripeDebugMenuVisible = this.addStripe("Debug menu visible", this.pnlDebugMenuVisible, false);
        this.chkAdvancedUserVisible.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ObsToolUserPrefs obsToolUserPrefs = AdvancedPanel.this.controller.getPreferences();
                obsToolUserPrefs.setAdvancedUser(AdvancedPanel.this.chkAdvancedUserVisible.isSelected());
                AdvancedPanel.this.prefsDialogue.advancedOptionQuickApply();
            }
        });
    }

    @Override
    public void readPreferences(ObsToolUserPrefs obsToolUserPrefs) {
        this.chkAdvancedUserVisible.setSelected(obsToolUserPrefs.getAdvancedUser());
        this.chkDebugMenuVisible.setSelected(obsToolUserPrefs.getDebugMenuVisible());
        this.chkOusWriteProtection.setSelected(obsToolUserPrefs.getOusWriteProtection());
        this.chkUseBLCorrForAca.setSelected(obsToolUserPrefs.getUseBlCorrForAca());
        this.readAdvancedOptions(this.controller.advancedOptions());
    }

    public void readAdvancedOptions(ObservingToolController.AdvancedOptions advancedOptions) {
        boolean bl = advancedOptions.isShowStaffActions();
        this.stripeDebugMenuVisible.setVisible(bl);
        this.stripeUseBLCorrForAca.setVisible(bl);
    }

    @Override
    public void writePreferences(ObsToolUserPrefs obsToolUserPrefs) {
        obsToolUserPrefs.setAdvancedUser(this.chkAdvancedUserVisible.isSelected());
        obsToolUserPrefs.setDebugMenuVisible(this.chkDebugMenuVisible.isSelected());
        obsToolUserPrefs.setOusWriteProtection(this.chkOusWriteProtection.isSelected());
        obsToolUserPrefs.setUseBlCorrForAca(this.chkUseBLCorrForAca.isSelected());
        OusComponentProtect.setOusComponentProtectPreference(this.chkOusWriteProtection.isSelected());
        System.setProperty("UseBLCorrForAca", Boolean.valueOf(obsToolUserPrefs.getUseBlCorrForAca()).toString());
    }
}

