/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.bott;

import alma.obsprep.ot.gui.bott.TreeTableModel;
import alma.obsprep.ot.gui.bott.TreeTableModelAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;

    public JTreeTable(TreeTableModel treeTableModel) {
        this.getTableHeader().setReorderingAllowed(false);
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(20);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
            this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    @Override
    public void sizeColumnsToFit(int n) {
        super.sizeColumnsToFit(n);
        if (this.getEditingColumn() != -1 && this.getColumnClass(this.editingColumn) == TreeTableModel.class) {
            Rectangle rectangle = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        }
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && this.getColumnClass(n2) == TreeTableModel.class) {
            this.repaint(this.getCellRect(n, n2, false));
        }
        return bl;
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        for (int i = n; i <= n2; ++i) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = JTreeTable.this.tree.getPathForRow(i)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    static class TreeTableTextField
    extends JTextField {
        public int offset;

        TreeTableTextField() {
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            int n5 = Math.max(n, this.offset);
            super.setBounds(n5, n2, n3 - (n5 - n), n4);
        }
    }

    public class TreeTableCellEditor
    extends DefaultCellEditor {
        public TreeTableCellEditor() {
            super(new TreeTableTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            JTree jTree = JTreeTable.this.getTree();
            boolean bl2 = jTree.isRootVisible();
            int n3 = bl2 ? n : n - 1;
            Rectangle rectangle = jTree.getRowBounds(n3);
            int n4 = rectangle.x;
            TreeCellRenderer treeCellRenderer = jTree.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                Object object2 = jTree.getPathForRow(n3).getLastPathComponent();
                Icon icon = jTree.getModel().isLeaf(object2) ? ((DefaultTreeCellRenderer)treeCellRenderer).getLeafIcon() : (JTreeTable.this.tree.isExpanded(n3) ? ((DefaultTreeCellRenderer)treeCellRenderer).getOpenIcon() : ((DefaultTreeCellRenderer)treeCellRenderer).getClosedIcon());
                if (icon != null) {
                    n4 += ((DefaultTreeCellRenderer)treeCellRenderer).getIconTextGap() + icon.getIconWidth();
                }
            }
            ((TreeTableTextField)this.getComponent()).offset = n4;
            return component;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                if (mouseEvent.getModifiers() == 0 || mouseEvent.getModifiers() == 16) {
                    for (int i = JTreeTable.this.getColumnCount() - 1; i >= 0; --i) {
                        if (JTreeTable.this.getColumnClass(i) != TreeTableModel.class) continue;
                        MouseEvent mouseEvent2 = new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)i, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                        JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                        break;
                    }
                }
                return mouseEvent.getClickCount() >= 3;
            }
            return eventObject == null;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        protected Border highlightBorder;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setBorderSelectionColor(null);
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, graphics, 0, this.visibleRow * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            Color color2;
            if (bl) {
                color2 = jTable.getSelectionBackground();
                color = jTable.getSelectionForeground();
            } else {
                color2 = jTable.getBackground();
                color = jTable.getForeground();
            }
            this.highlightBorder = null;
            this.visibleRow = n;
            this.setBackground(color2);
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                if (bl) {
                    defaultTreeCellRenderer.setTextSelectionColor(color);
                    defaultTreeCellRenderer.setBackgroundSelectionColor(color2);
                } else {
                    defaultTreeCellRenderer.setTextNonSelectionColor(color);
                    defaultTreeCellRenderer.setBackgroundNonSelectionColor(color2);
                }
            }
            return this;
        }
    }
}

