/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.subform;

import alma.obsprep.bo.enumerations.Antenna;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import java.io.Serializable;

public class MosaicParameters
implements Serializable {
    public static String TYPE_RECTANGLE = "Rectangle Grid";
    public static String TYPE_TRIANGLE = "Triangle Grid";
    public static String[] knownTypeList = new String[]{TYPE_RECTANGLE, TYPE_TRIANGLE};
    private String type = TYPE_TRIANGLE;
    private Antenna antenna = Antenna.ANTENNA_12M;
    private final Frequency frequency = Frequency.createFrequency();
    private double overlap = 50.0;
    private double spacing = 0.0;

    public Antenna getAntenna() {
        return this.antenna;
    }

    public void setAntenna(Antenna antenna) {
        this.antenna = antenna;
    }

    public Angle getBeamsize() {
        return this.antenna.getBeamSize(this.getFrequency());
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public double getSpacing() {
        return this.spacing;
    }

    public void setSpacing(double d) {
        this.spacing = d;
    }

    public void updateSpacing() {
        Angle angle = this.getAntenna().getBeamSize(this.getFrequency());
        double d = angle.getContentInUnits(Angle.UNIT_ARCSEC) * (1.0 - this.getOverlap() / 100.0);
        this.setSpacing(d);
    }

    public double updateOverlap() {
        Angle angle = this.getAntenna().getBeamSize(this.getFrequency());
        double d = (1.0 - this.getSpacing() / angle.getContentInUnits(Angle.UNIT_ARCSEC)) * 100.0;
        this.setOverlap(d);
        return d;
    }

    public double getOverlap() {
        return this.overlap;
    }

    public void setOverlap(double d) {
        this.overlap = d;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Antenna = " + this.antenna);
        stringBuffer.append(", Type = " + this.type);
        stringBuffer.append(", frequency = " + this.frequency);
        stringBuffer.append(", overlap = " + this.overlap);
        stringBuffer.append(", spacing = " + this.spacing);
        return stringBuffer.toString();
    }
}

