/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.annotations.RectanglePatternI;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.guiutil.jsky.image.graphics.AlmaRoiRectangle;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.FieldMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.Mapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.OverlayPointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.PatternFigure;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapper;
import alma.obsprep.ot.editors.spatialvisual.mapper.ShowPointingsException;
import alma.obsprep.services.generator.refactored.targetcreator.TargetParametersFieldSourceWorker;
import alma.valuetypes.Angle;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import java.awt.geom.Point2D;
import java.util.Optional;
import jsky.coords.CoordinateConverter;
import jsky.image.gui.MainImageDisplay;
import lombok.NonNull;

public class RoiMapperModel
extends FieldMapperModel {
    private OverlayPointingMapperModel overlayPointingMapperModel;

    public RoiMapperModel(BaseSpatialVisualModel baseSpatialVisualModel) {
        super(baseSpatialVisualModel);
        this.overlayPointingMapperModel = new OverlayPointingMapperModel(baseSpatialVisualModel, this);
    }

    public RoiMapper getRoiMapper() {
        return (RoiMapper)this.mapper;
    }

    public double getFITSImageRotation() {
        return this.getRoiMapper().getImageAngle();
    }

    public boolean getImageFlipped() {
        return this.getRoiMapper().getImageFlipped();
    }

    public boolean isPointingsShown() {
        return true;
    }

    @Override
    public void publish() {
        FieldPatternI fieldPatternI = this.getFieldPattern();
        if (fieldPatternI == null || !fieldPatternI.isRectanglePattern()) {
            return;
        }
        if (this.isPointingsShown()) {
            try {
                this.deleteRectangleRoi((RectanglePatternI)this.model.getRectanglePatternModel().getDocument());
                this.overlayPointingMapperModel.initialize();
                this.overlayPointingMapperModel.configurePointingPattern();
                this.overlayPointingMapperModel.publish();
            }
            catch (ShowPointingsException showPointingsException) {
                // empty catch block
            }
        }
        this.getRoiMapper().update();
    }

    @Override
    public void updateBO(@NonNull PatternFigure patternFigure) {
        Object object;
        RoiMapper.RotationCase rotationCase;
        MainImageDisplay.CoordSystemType coordSystemType;
        RectanglePatternI rectanglePatternI;
        PatternFigure patternFigure2;
        if (patternFigure == null) {
            throw new NullPointerException("figure is marked non-null but is null");
        }
        if (!this.getFieldPattern().isRectanglePattern()) {
            return;
        }
        try {
            patternFigure2 = patternFigure;
        }
        catch (ClassCastException classCastException) {
            Log.logger(RoiMapperModel.class).warning("Unable to cast figure to PatternFigure");
            return;
        }
        CoordinateConverter coordinateConverter = this.getRoiMapper().getCoordinateConverter();
        double d = patternFigure2.getBounds().getCenterX();
        double d2 = patternFigure2.getBounds().getCenterY();
        Point2D.Double double_ = new Point2D.Double(d, d2);
        switch (1) {
            case 3: {
                coordinateConverter.userToWorldCoords(double_, false);
                break;
            }
            case 1: {
                coordinateConverter.screenToWorldCoords(double_, false);
            }
        }
        try {
            rectanglePatternI = (RectanglePatternI)patternFigure2.getBusinessObject();
        }
        catch (ClassCastException classCastException) {
            Log.logger(RoiMapperModel.class).warning("The ROI mapper model can only handle patterns of type rectangle");
            return;
        }
        if (rectanglePatternI == null) {
            return;
        }
        SkyCoordinates skyCoordinates = rectanglePatternI.getFieldCenterCoordinates();
        try {
            coordSystemType = this.mapper.getImageCoordinateSystem();
        }
        catch (Mapper.NoImageWCSException noImageWCSException) {
            Log.logger(RoiMapperModel.class).warning("No WCS information associated with image");
            return;
        }
        assert (coordSystemType != null);
        this.setRectangleAbsCoordinatesFromVisualiserFigure(double_, skyCoordinates, coordSystemType);
        double d3 = 0.0;
        Optional<Object> optional = Optional.empty();
        if (SkyCoordinates.isEquatorial(skyCoordinates.getSystem()) && coordSystemType.equals((Object)MainImageDisplay.CoordSystemType.GALACTIC)) {
            optional = Optional.of(TargetParametersFieldSourceWorker.SystemRotationConversion.GalacticToICRS);
            rotationCase = RoiMapper.RotationCase.GalacticImageAndICRSSource;
        } else if (SkyCoordinates.isGalactic(skyCoordinates.getSystem()) && coordSystemType.equals((Object)MainImageDisplay.CoordSystemType.EQUATORIAL)) {
            optional = Optional.of(TargetParametersFieldSourceWorker.SystemRotationConversion.ICRSToGalactic);
            rotationCase = RoiMapper.RotationCase.ICRSImageAndGalacticSource;
        } else if (SkyCoordinates.isGalactic(skyCoordinates.getSystem()) && coordSystemType.equals((Object)MainImageDisplay.CoordSystemType.GALACTIC)) {
            rotationCase = RoiMapper.RotationCase.GalacticImageAndGalacticSource;
        } else if (SkyCoordinates.isEquatorial(skyCoordinates.getSystem()) && coordSystemType.equals((Object)MainImageDisplay.CoordSystemType.EQUATORIAL)) {
            rotationCase = RoiMapper.RotationCase.ICRSImageAndICRSSource;
        } else {
            throw new RuntimeException("Unknown image-source coordinate system detected");
        }
        double d4 = ((AlmaRoiRectangle)patternFigure2).getGeometry().getNormalizedRotateAngle();
        if (optional.isPresent()) {
            object = SkyCoordinates.createAbsoluteCoordinates();
            switch (coordSystemType) {
                case UNKNOWN: 
                case EQUATORIAL: {
                    object.setAbsoluteCoordinatesInJ2000Deg(double_);
                    break;
                }
                case GALACTIC: {
                    object.setAbsoluteCoordinatesInGalacticDeg(double_);
                    object.convertToICRS();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown coordinate system has been specified: " + coordSystemType);
                }
            }
            d3 = TargetParametersFieldSourceWorker.transformPABetweenCoordinateSystems(Math.toDegrees(d4) * -1.0, object.getLongitude().getContentInUnits(Longitude.UNIT_DEG), object.getLatitude().getContentInUnits(Latitude.UNIT_DEG), (TargetParametersFieldSourceWorker.SystemRotationConversion)((Object)optional.get()));
            d3 = Math.toDegrees(this.getROIRotationAngle(Math.toRadians(d3), this.getImageRotation().getContentInUnits(Angle.UNIT_RAD), this.getImageFlipped(), rotationCase)) * -1.0;
            Log.logger(OverlayPointingMapperModel.class).fine("ROI mapper model coordinateSystemCompensatedRotationDegs: " + d3);
        } else {
            double d5 = this.getROIRotationAngle(d4, this.getImageRotation().getContentInUnits(Angle.UNIT_RAD), this.getImageFlipped(), rotationCase);
            d3 = Math.toDegrees(d5);
        }
        object = Angle.createAngle((double)d3, (String)Angle.UNIT_DEG);
        object.convertToUnit(rectanglePatternI.getRotationAngle().getUnit());
        rectanglePatternI.setRotationAngle((Angle)((Object)object));
        Point2D.Double double_2 = ((AlmaRoiRectangle)patternFigure2).getWidthInPoint2D();
        Point2D.Double double_3 = ((AlmaRoiRectangle)patternFigure2).getHeightInPoint2D();
        coordinateConverter.screenToWorldCoords(double_2, true);
        coordinateConverter.screenToWorldCoords(double_3, true);
        double d6 = double_2.getX();
        double d7 = double_2.getY();
        double d8 = Math.sqrt(d6 * d6 + d7 * d7);
        d6 = double_3.getX();
        d7 = double_3.getY();
        double d9 = Math.sqrt(d6 * d6 + d7 * d7);
        ValueUnitPair<Angle> valueUnitPair = rectanglePatternI.getLatitudeLength();
        String string = valueUnitPair.getUnit();
        valueUnitPair.setContent(d9 * 60.0);
        valueUnitPair.setUnit(Angle.UNIT_ARCMIN);
        valueUnitPair.convertToUnit(string);
        ValueUnitPair<Angle> valueUnitPair2 = rectanglePatternI.getLongitudeLength();
        String string2 = valueUnitPair2.getUnit();
        valueUnitPair2.setContent(d8 * 60.0);
        valueUnitPair2.setUnit(Angle.UNIT_ARCMIN);
        valueUnitPair2.convertToUnit(string2);
        this.updateFormEditor();
    }

    public void setRectangleAbsCoordinatesFromVisualiserFigure(Point2D.Double double_, SkyCoordinates skyCoordinates, MainImageDisplay.CoordSystemType coordSystemType) {
        if (skyCoordinates.isAbsoluteCoordinates()) {
            String string = skyCoordinates.getSystem();
            switch (coordSystemType) {
                case UNKNOWN: 
                case EQUATORIAL: {
                    skyCoordinates.setAbsoluteCoordinatesInJ2000Deg(double_);
                    break;
                }
                case GALACTIC: {
                    skyCoordinates.setAbsoluteCoordinatesInGalacticDeg(double_);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown coordinate system has been specified " + coordSystemType);
                }
            }
            skyCoordinates.convertToSystem(string);
        } else {
            SkyCoordinates skyCoordinates2 = SkyCoordinates.createAbsoluteCoordinates();
            switch (coordSystemType) {
                case UNKNOWN: 
                case EQUATORIAL: {
                    skyCoordinates2.setAbsoluteCoordinatesInJ2000Deg(double_);
                    break;
                }
                case GALACTIC: {
                    skyCoordinates2.setAbsoluteCoordinatesInGalacticDeg(double_);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown coordinate system has been specified " + coordSystemType);
                }
            }
            SkyCoordinates skyCoordinates3 = skyCoordinates2.getOffsetCoordinates(this.getFieldPattern().getOrigin());
            skyCoordinates.getLongitude().setContent(skyCoordinates3.getLongitude().getContentInUnits(skyCoordinates.getLongitude().getUnit()));
            skyCoordinates.getLatitude().setContent(skyCoordinates3.getLatitude().getContentInUnits(skyCoordinates.getLatitude().getUnit()));
        }
    }

    protected RectanglePatternI addRectangleRoi() {
        if (this.singleMode) {
            this.initialize();
        }
        return this.getSpatialVisualModel().getVisualModelHelper().addRectangleRoi();
    }

    public void deleteRectangleRoi(RectanglePatternI rectanglePatternI) {
        if (this.singleMode) {
            this.initialize();
        } else {
            this.getSpatialVisualModel().getVisualModelHelper().deleteRectangleRoi(rectanglePatternI);
        }
    }

    public SpatialPartOfSpatialDocument getSpatialPart() {
        return this.getSpatialPartModel().getSpatialPart();
    }

    public FieldPatternI getFieldPattern() {
        return this.getSpatialVisualModel().getVisualModelHelper().getFieldPattern();
    }

    public boolean isDrawing() {
        return this.getMapper().isDrawing();
    }

    public void setRoiMode(int n) {
        this.getRoiMapper().setRoiMode(n);
    }

    @Override
    public void setImageCoordinateSystem(MainImageDisplay.CoordSystemType coordSystemType) {
        this.overlayPointingMapperModel.setImageCoordinateSystem(coordSystemType);
        super.setImageCoordinateSystem(coordSystemType);
    }

    @Override
    public void setImageRotation(Angle angle) {
        this.overlayPointingMapperModel.setImageRotation(angle);
        super.setImageRotation(angle);
    }

    @Override
    public void setImageFlipped(boolean bl) {
        this.overlayPointingMapperModel.setImageFlipped(bl);
        super.setImageFlipped(bl);
    }

    public double getROIRotationAngle(double d, double d2, boolean bl, RoiMapper.RotationCase rotationCase) {
        switch (rotationCase) {
            case GalacticImageAndICRSSource: 
            case ICRSImageAndGalacticSource: {
                if (bl) {
                    d += d2;
                    d *= -1.0;
                    break;
                }
                d -= d2;
                break;
            }
            case ICRSImageAndICRSSource: 
            case GalacticImageAndGalacticSource: {
                if (bl) {
                    d += d2;
                    d *= -1.0;
                    break;
                }
                d -= d2 * -1.0;
            }
        }
        return d;
    }

    public OverlayPointingMapperModel getOverlayPointingMapperModel() {
        return this.overlayPointingMapperModel;
    }
}

