/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual.mapper;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.ot.editors.spatialvisual.mapper.PatternFigure;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.PreferencesListener;
import alma.valuetypes.SkyCoordinates;
import diva.canvas.Figure;
import diva.canvas.interactor.Interactor;
import diva.util.java2d.Polyline2D;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import jsky.image.graphics.ImageFigure;
import jsky.image.graphics.ImageFigureGroup;

public class FovFigure
extends ImageFigureGroup
implements PatternFigure,
PreferencesListener {
    protected static final int DEFAULT_TICK_LEN = 5;
    protected static final int DEFAULT_DIAMETER = 10;
    final Colors palette = new Colors();
    private SkyCoordinates coordinates;
    private ImageFigure l1Figure;
    private ImageFigure l2Figure;
    private ImageFigure mainFluxFigure;
    private ImageFigure fovFigure;
    private boolean overlayTransparent;

    protected void finalize() throws Throwable {
    }

    public FovFigure(double d, double d2, double d3, double d4, int n, boolean bl) {
        super(null);
        Object object;
        Interactor interactor = null;
        float f = 2.0f;
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        ObsToolUserPrefs obsToolUserPrefs = observingToolController.getPreferences();
        observingToolController.addPreferencesListener(this);
        this.palette.setColor("FOV", new Color((int)Long.parseLong(obsToolUserPrefs.getColorFOV(), 16)));
        this.palette.setColor("FOV 1/3 HPBW", new Color((int)Long.parseLong(obsToolUserPrefs.getColorFOVMainFluxHPBW(), 16)));
        Color color = null;
        Color color2 = this.palette.getFOVColor();
        Color color3 = this.palette.getFOVMainFluxColor();
        this.overlayTransparent = false;
        if (d3 == 0.0 || d4 == 0.0) {
            Color color4;
            d3 = 10.0;
            d4 = 10.0;
            color = color4 = new Color(0.0f, 0.0f, 0.0f, 0.0f);
            color2 = color4;
            color3 = color4;
            f = 0.0f;
            this.overlayTransparent = true;
        }
        double d5 = d - d3;
        double d6 = d2 - d4;
        Ellipse2D.Double double_ = new Ellipse2D.Double(d5, d6, d3 * 2.0, d4 * 2.0);
        this.fovFigure = new ImageFigure((Shape)double_, (Paint)color, (Paint)color2, f, interactor);
        this.add((Figure)this.fovFigure);
        if (bl) {
            d5 = d - d3 / 100.0 * 33.0;
            d6 = d2 - d4 / 100.0 * 33.0;
            object = new Ellipse2D.Double(d5, d6, d3 * 2.0 / 100.0 * 33.0, d4 * 2.0 / 100.0 * 33.0);
            this.mainFluxFigure = new ImageFigure((Shape)object, (Paint)color, (Paint)color3, f, interactor);
            this.mainFluxFigure.setDashArray(new float[]{3.0f, 5.0f});
            this.add((Figure)this.mainFluxFigure);
        }
        object = new Polyline2D.Double(d - (double)n, d2, d + (double)n, d2);
        Polyline2D.Double double_2 = new Polyline2D.Double(d, d2 - (double)n, d, d2 + (double)n);
        this.l1Figure = new ImageFigure((Shape)object, null, (Paint)this.palette.getFOVColor(), 2.0f, interactor);
        this.add((Figure)this.l1Figure);
        this.l2Figure = new ImageFigure((Shape)double_2, null, (Paint)this.palette.getFOVColor(), 2.0f, interactor);
        this.add((Figure)this.l2Figure);
    }

    @Override
    public BusinessObject getBusinessObject() {
        return this.coordinates;
    }

    @Override
    public void setBusinessObject(BusinessObject businessObject) {
        try {
            this.coordinates = (SkyCoordinates)businessObject;
        }
        catch (ClassCastException classCastException) {
            this.coordinates = null;
        }
    }

    @Override
    public void handlePreferencesChanged(ObsToolUserPrefs obsToolUserPrefs) {
        this.palette.setColor("FOV", new Color((int)Long.parseLong(obsToolUserPrefs.getColorFOV(), 16)));
        this.palette.setColor("FOV 1/3 HPBW", new Color((int)Long.parseLong(obsToolUserPrefs.getColorFOVMainFluxHPBW(), 16)));
        if (!this.overlayTransparent) {
            Color color = this.palette.getFOVColor();
            if (this.l1Figure != null) {
                this.l1Figure.setStrokePaint((Paint)color);
            }
            if (this.l2Figure != null) {
                this.l2Figure.setStrokePaint((Paint)color);
            }
            if (this.fovFigure != null) {
                this.fovFigure.setStrokePaint((Paint)color);
            }
            if (this.mainFluxFigure != null) {
                this.mainFluxFigure.setStrokePaint((Paint)this.palette.getFOVMainFluxColor());
            }
        }
    }

    @Override
    public void cleanupForRemoval() {
        ObservingToolController observingToolController = ObservingToolController.getMyInstance();
        observingToolController.removePreferencesListener(this);
    }
}

