/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.obsprep.bo.annotations.FieldPatternI;
import alma.obsprep.bo.annotations.RectanglePatternI;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.RectanglePattern;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.spatialvisual.SchedBlockSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.VisualModelHelper;
import alma.obsprep.ot.editors.spatialvisual.mapper.CenterMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.RoiMapperModel;
import alma.obsprep.ot.models.schedblock.FieldPatternChangeListener;
import alma.obsprep.ot.models.schedblock.FieldSourceModel;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.ot.models.schedblock.RectanglePatternModel;
import alma.obsprep.ot.models.valuetypes.CoordsModel;
import alma.obsprep.ot.models.valuetypes.OffsetModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;

public class VisualModelHelperForSB
extends VisualModelHelper {
    protected FieldSourceModel fieldSourceModel;

    public VisualModelHelperForSB(SchedBlockSpatialVisualModel schedBlockSpatialVisualModel) {
        super(schedBlockSpatialVisualModel);
        this.fieldSourceModel = schedBlockSpatialVisualModel.getFormModel();
        this.getCenterMapperModel().setSingleMode(true);
        this.getPointingMapperModel().setSingleMode(false);
        this.getRoiMapperModel().setSingleMode(true);
        this.fieldSourceModel.getFieldPatternModel().addFieldPatternChangeListener(this);
    }

    @Override
    public SkyCoordinates getTargetCenter() {
        return this.fieldSourceModel.getSourceCoordinates();
    }

    @Override
    public SkyCoordinates[] getTargetCenters() {
        SkyCoordinates[] skyCoordinatesArray = new SkyCoordinates[]{this.getTargetCenter()};
        return skyCoordinatesArray;
    }

    @Override
    public FieldPatternI getFieldPattern() {
        FieldSource fieldSource = this.getFieldSource();
        return fieldSource == null ? null : fieldSource.getFieldPattern();
    }

    @Override
    public FieldPattern.FieldPatternType getFieldPatternType() {
        FieldPattern fieldPattern = this.getFieldSource().getFieldPattern();
        return fieldPattern == null ? null : fieldPattern.getFieldPatternType();
    }

    @Override
    public SkyCoordinates[] getPointings() {
        String string;
        FieldPattern fieldPattern;
        FieldSource fieldSource = this.getFieldSource();
        if (fieldSource != null && (fieldPattern = fieldSource.getFieldPattern()) != null && (string = fieldSource.getFieldPatternType()).equals(FieldPattern.TYPE_POINT)) {
            PointingPattern pointingPattern = (PointingPattern)((Object)fieldPattern);
            return pointingPattern.getPhaseCenterCoordinates();
        }
        return new SkyCoordinates[0];
    }

    @Override
    public SkyCoordinates addPointing() {
        FieldPattern fieldPattern;
        FieldSource fieldSource = this.getFieldSource();
        if (fieldSource != null && (fieldPattern = fieldSource.getFieldPattern()) != null && fieldPattern.isPointingPattern()) {
            PointingPattern pointingPattern = (PointingPattern)((Object)fieldPattern);
            SkyCoordinates skyCoordinates = this.getPointingPatternModel().addPointing(-1, pointingPattern.isOffsetPointingPattern());
            return skyCoordinates;
        }
        return null;
    }

    @Override
    public void deletePointing(SkyCoordinates skyCoordinates) {
        String string;
        FieldPattern fieldPattern;
        FieldSource fieldSource = this.getFieldSource();
        if (fieldSource != null && (fieldPattern = fieldSource.getFieldPattern()) != null && (string = fieldSource.getFieldPatternType()).equals(FieldPattern.TYPE_POINT)) {
            PointingPattern pointingPattern = (PointingPattern)((Object)fieldPattern);
            this.getPointingPatternModel().deletePointing(pointingPattern.indexOf(skyCoordinates));
        }
    }

    @Override
    public SkyCoordinates addTargetCenter() {
        return this.getTargetCenter();
    }

    public RectanglePattern[] getRectangleRois() {
        FieldPattern fieldPattern = this.getFieldSource().getFieldPattern();
        if (fieldPattern.isRectanglePattern()) {
            RectanglePattern[] rectanglePatternArray = new RectanglePattern[]{(RectanglePattern)((Object)fieldPattern)};
            return rectanglePatternArray;
        }
        return null;
    }

    @Override
    public RectanglePattern addRectangleRoi() {
        FieldPattern fieldPattern = this.getFieldSource().getFieldPattern();
        if (fieldPattern.isRectanglePattern()) {
            return (RectanglePattern)((Object)fieldPattern);
        }
        RectanglePattern rectanglePattern = RectanglePattern.createRectanglePattern();
        this.getFieldSource().setFieldPattern((FieldPattern)((Object)rectanglePattern));
        return rectanglePattern;
    }

    @Override
    public void deleteRectangleRoi(RectanglePatternI rectanglePatternI) {
        FieldPattern fieldPattern = this.getFieldSource().getFieldPattern();
        if (fieldPattern.isRectanglePattern()) {
            this.getFieldSource().setFieldPattern(null);
        }
    }

    @Override
    public void updateFormEditor(MapperModel mapperModel) {
        if (mapperModel instanceof CenterMapperModel) {
            SkyCoordsModel skyCoordsModel = this.getSourceCoordinatesModel();
            SkyCoordinates skyCoordinates = this.getFieldSource().getTargetCenter();
            Longitude longitude = skyCoordinates.getLongitude();
            Latitude latitude = skyCoordinates.getLatitude();
            skyCoordsModel.publish(SkyCoordsModel.FID_LON, new Double(longitude.getContent()));
            skyCoordsModel.publish(SkyCoordsModel.FID_ULON, longitude.getUnit());
            skyCoordsModel.publish(SkyCoordsModel.FID_LAT, new Double(latitude.getContent()));
            skyCoordsModel.publish(SkyCoordsModel.FID_ULAT, latitude.getUnit());
        } else if (mapperModel instanceof RoiMapperModel) {
            CoordsModel coordsModel = this.getRectanglePatternModel().getPatternCenterCoordsModel();
            SkyCoordinates skyCoordinates = ((RectanglePattern)((Object)this.getFieldSource().getFieldPattern())).getPatternCenterCoordinates();
            Longitude longitude = skyCoordinates.getLongitude();
            Latitude latitude = skyCoordinates.getLatitude();
            if (skyCoordinates.isAbsoluteCoordinates()) {
                SkyCoordsModel skyCoordsModel = coordsModel.getSkyCoordsModel();
                skyCoordsModel.publish(SkyCoordsModel.FID_LON, new Double(longitude.getContent()));
                skyCoordsModel.publish(SkyCoordsModel.FID_ULON, longitude.getUnit());
                skyCoordsModel.publish(SkyCoordsModel.FID_LAT, new Double(latitude.getContent()));
                skyCoordsModel.publish(SkyCoordsModel.FID_ULAT, latitude.getUnit());
            } else {
                OffsetModel offsetModel = coordsModel.getOffsetCoordsModel();
                ((Model)offsetModel).publish();
            }
            this.getRectanglePatternModel().getLongitudeLengthModel().publish();
            this.getRectanglePatternModel().getLatitudeLengthModel().publish();
            this.getRectanglePatternModel().getOrientationModel().publish();
        } else if (mapperModel instanceof PointingMapperModel) {
            this.getPointingPatternModel().getPointingPatternTableModel().fireTableDataChanged();
        }
    }

    public FieldSource getFieldSource() {
        return this.fieldSourceModel.getFieldSource();
    }

    public PointingPatternModel getPointingPatternModel() {
        return this.fieldSourceModel.getPointingPatternModel();
    }

    @Override
    public void changeFieldPattern(FieldPattern.FieldPatternType fieldPatternType) {
        this.fieldSourceModel.getFieldPatternModel().changeFieldType(fieldPatternType);
    }

    public RectanglePatternModel getRectanglePatternModel() {
        return this.fieldSourceModel.getRectanglePatternModel();
    }

    public SkyCoordsModel getSourceCoordinatesModel() {
        return this.fieldSourceModel.getSourceCoordinatesModel();
    }

    @Override
    public void addFieldPatternChangeListener(FieldPatternChangeListener fieldPatternChangeListener) {
        this.fieldSourceModel.getFieldPatternModel().addFieldPatternChangeListener(fieldPatternChangeListener);
    }

    @Override
    public boolean removeFieldPatternChangeListener(FieldPatternChangeListener fieldPatternChangeListener) {
        return this.fieldSourceModel.getFieldPatternModel().removeFieldPatternChangeListener(fieldPatternChangeListener);
    }
}

