/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.obsprep.guiutil.jsky.navigator.AlmaNavigatorImageDisplayPanel;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualAction;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualActionCenter;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualActionCut;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualActionFov;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualActionImageLevels;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualActionImageOpen;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualActionRectangle;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualActionRegion;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualActionSaveAs;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualActionShowGrid;
import alma.obsprep.ot.editors.spatialvisual.actions.SpatialVisualActionShowPointings;
import alma.obsprep.ot.editors.spatialvisual.mapper.MapperEvent;
import alma.obsprep.ot.editors.spatialvisual.mapper.PointingMapper;
import alma.obsprep.ot.gui.toplevel.EditorDisablerController;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class AlmaImageDisplayToolBar
extends JPanel {
    private final AlmaNavigatorImageDisplayPanel imagePanel;
    private final Map<String, AbstractButton> toolBarButtons = new HashMap<String, AbstractButton>();
    private final BaseSpatialVisualModel baseSpatialVisualModel;

    public AlmaImageDisplayToolBar(BaseSpatialVisualModel baseSpatialVisualModel, AlmaNavigatorImageDisplayPanel almaNavigatorImageDisplayPanel) {
        this.imagePanel = almaNavigatorImageDisplayPanel;
        this.baseSpatialVisualModel = baseSpatialVisualModel;
        this.setLayout(new BoxLayout(this, 0));
        this.build();
        PointingMapper pointingMapper = almaNavigatorImageDisplayPanel.getMapperManager().getRoiMapper().getOverlayPointingMapper();
        pointingMapper.addMapperChangeListener(mapperEvent -> {
            if (mapperEvent.getEventType() == MapperEvent.MapperEventType.REMOVED) {
                this.setButtonSelected("Show Pointings", false);
            }
        });
    }

    private void build() {
        SpatialVisualAction spatialVisualAction = new SpatialVisualActionImageOpen(this.imagePanel);
        String string = "Open a FITS file";
        AbstractButton abstractButton = this.addButton(spatialVisualAction, string);
        abstractButton.setName("SpatialVisualEditor.openFitsFileBtn");
        spatialVisualAction = new SpatialVisualActionSaveAs(this.imagePanel);
        string = "Save the image as ...";
        abstractButton = this.addButton(spatialVisualAction, string);
        abstractButton.setName("SpatialVisualEditor.saveImageAsBtn");
        spatialVisualAction = new SpatialVisualActionCut(this.imagePanel);
        string = "Cut selected FOVs";
        abstractButton = this.addButton(spatialVisualAction, string);
        abstractButton.setName("SpatialVisualEditor.cutFOVsBtn");
        spatialVisualAction = new SpatialVisualActionRegion(this.imagePanel);
        string = "Select FOVs in an rectangle region";
        abstractButton = this.addButton(spatialVisualAction, string);
        abstractButton.setName("SpatialVisualEditor.selectFOVsBtn");
        spatialVisualAction = new SpatialVisualActionCenter(this.imagePanel);
        string = "Set the target center (Source Coordinates) ";
        abstractButton = this.addButton(spatialVisualAction, string);
        abstractButton.setName("SpatialVisualEditor.setTargetCenterBtn");
        spatialVisualAction = new SpatialVisualActionFov(this.imagePanel);
        string = "Add a FOV";
        abstractButton = this.addButton(spatialVisualAction, string);
        abstractButton.setName("SpatialVisualEditor.addFOVBtn");
        spatialVisualAction = new SpatialVisualActionRectangle(this.imagePanel);
        string = "Draw a rectangular map";
        abstractButton = this.addButton(spatialVisualAction, string);
        abstractButton.setName("SpatialVisualEditor.drawRectangularMapBtn");
        spatialVisualAction = new SpatialVisualActionShowPointings(this.imagePanel, this.baseSpatialVisualModel);
        string = "Show pointing positions.";
        abstractButton = this.addButton(spatialVisualAction, string);
        spatialVisualAction.putValue("Action.button", abstractButton);
        abstractButton.setName("SpatialVisualEditor.showPointingsBtn");
        spatialVisualAction = new SpatialVisualActionImageLevels(this.imagePanel);
        string = "Image Cut Levels";
        abstractButton = this.addButton(spatialVisualAction, string);
        abstractButton.setName("SpatialVisualEditor.imageCutLevelsBtn");
        spatialVisualAction = new SpatialVisualActionShowGrid(this.imagePanel);
        string = "Show/Hide Grid";
        abstractButton = this.addButton(spatialVisualAction, string);
        abstractButton.setName("SpatialVisualEditor.showGridBtn");
        AbstractButton abstractButton2 = this.toolBarButtons.get("Show Grid");
        abstractButton2.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
    }

    private AbstractButton addButton(SpatialVisualAction spatialVisualAction, String string) {
        Icon icon = (Icon)spatialVisualAction.getValue("SmallIcon");
        AbstractButton abstractButton = spatialVisualAction.toggles() ? new JToggleButton(icon) : new JButton(icon);
        abstractButton.setFocusPainted(false);
        abstractButton.setPreferredSize(new Dimension(26, 26));
        abstractButton.setMargin(new Insets(2, 2, 2, 2));
        abstractButton.setToolTipText(string);
        abstractButton.addActionListener(spatialVisualAction);
        if (spatialVisualAction.allowedEvenWhenProtected) {
            abstractButton.putClientProperty("readonly-handler", EditorDisablerController.keepEnabledStateOnReadonly);
        }
        this.add(abstractButton);
        this.add(Box.createRigidArea(new Dimension(1, 0)));
        this.toolBarButtons.put((String)spatialVisualAction.getValue("Name"), abstractButton);
        return abstractButton;
    }

    public void setButtonSelected(String string, boolean bl) {
        try {
            JToggleButton jToggleButton = (JToggleButton)this.toolBarButtons.get(string);
            if (jToggleButton != null) {
                jToggleButton.setSelected(bl);
            }
        }
        catch (ClassCastException classCastException) {
            return;
        }
    }

    public void setButtonEnable(String string, boolean bl) {
        AbstractButton abstractButton = this.toolBarButtons.get(string);
        if (abstractButton != null) {
            abstractButton.setEnabled(bl);
        }
    }

    public void setButtonVisible(String string, boolean bl) {
        AbstractButton abstractButton = this.toolBarButtons.get(string);
        if (abstractButton != null) {
            abstractButton.setVisible(bl);
        }
    }
}

