/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.obsproject.VisitConstraint;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintEditor;
import alma.obsprep.ot.editors.sciencegoals.VisitConstraintTableModel;
import alma.obsprep.ot.gui.factory.Table;
import alma.valuetypes.Time;
import java.awt.Component;
import java.time.format.DateTimeFormatter;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class VisitConstraintsTable
extends Table {
    private static final long serialVersionUID = 3900865882362616898L;
    public static final int TABLE_WIDTH = 500;

    public VisitConstraintsTable(VisitConstraintTableModel visitConstraintTableModel) {
        super(visitConstraintTableModel);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setToolTipText("TODO add tooltip");
        this.setupTableCellEditors();
        this.setupTableCellRenderers();
    }

    private void setupTableCellEditors() {
        VisitConstraintTableModel visitConstraintTableModel = (VisitConstraintTableModel)this.getModel();
        TableColumn tableColumn = this.getColumn("<html><center>Visit Constraints</center></html>");
        VisitConstraintEditor visitConstraintEditor = new VisitConstraintEditor(visitConstraintTableModel.getModel());
        tableColumn.setCellEditor(visitConstraintEditor);
    }

    private void setupTableCellRenderers() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 3474423374972813684L;
            String sdfStr = "yyyy-MM-dd HH:mm";
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(this.sdfStr);

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                this.setToolTipText("<html><p>Click on a row and select <b>'Edit'</b> to change details</p></html>");
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                VisitConstraint visitConstraint = (VisitConstraint)((Object)object);
                String string = "<html>Visit " + visitConstraint.getVisitId() + " : ";
                Time time = visitConstraint.getAllowedMargin();
                if (visitConstraint.hasIsFixedStart() && visitConstraint.getIsFixedStart() && "" != visitConstraint.getStartTime()) {
                    string = string + "Specific date of ";
                    string = string + visitConstraint.getStartTimeInDate().format(this.dtf);
                } else if (visitConstraint.hasPreviousVisitId() && visitConstraint.getPreviousVisitId() > 0) {
                    Time time2 = visitConstraint.getRequiredDelay();
                    string = string + "To be scheduled ";
                    if (time2.getContent() > 0.0) {
                        string = string + time2.getContent();
                        string = string + "  ";
                        string = string + time2.getUnit();
                        string = string + "   ";
                    }
                    string = string + "after visit ";
                    string = string + visitConstraint.getPreviousVisitId();
                } else {
                    string = string + "Arbitrary start ";
                }
                if (visitConstraint.getAllowedMargin().getContent() > 0.0) {
                    string = string + " with a margin of &plusmn; ";
                    string = string + time.getContent();
                    string = string + " ";
                    string = string + time.getUnit();
                }
                string = string + "</html>";
                this.setText(string);
                return this;
            }
        };
        TableColumn tableColumn = this.getColumn("<html><center>Visit Constraints</center></html>");
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }
}

