/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SinglePoint;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.sciencegoals.TimingConstraintTableModel;
import alma.obsprep.ot.editors.sciencegoals.TimingConstraintsTable;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.models.sciencegoals.TimingConstraintsListModel;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.LogLoggerProviderImpl;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Time;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

public class TimingConstraintsListEditor
extends EditorWithGridBagLayout
implements ListSelectionListener {
    private static final long serialVersionUID = 6076446159232048976L;
    public static final FieldID TEMPORAL_PARAM_TABLE_FID = new FieldID("TemporalParameterTable");
    public static final FieldID addTPFID = new FieldID("addTempParmFID");
    public static final FieldID editTPFID = new FieldID("editTempParmFID");
    public static final FieldID delTPFID = new FieldID("delTempParmFID");
    public static final FieldID delAllTPFID = new FieldID("delAllTempParmFID");
    public static final FieldID importTPFID = new FieldID("importTempParmFID");
    public static final FieldID tpCountLabelFID = new FieldID("tpCountLabelFID");
    public static final FieldID hintsLabel = new FieldID("hintsLabel");
    public static final FieldID timingParamStartDate = new FieldID("startDate");
    public static final FieldID selectIfExclusive = new FieldID("selectIfExclusive");
    public static final FieldID updateNote = new FieldID("updateNote");
    private JButton tpAddButton = null;
    private JButton tpEditButton = null;
    private JButton tpDelButton = null;
    private JButton tpDelAllButton = null;
    private JButton tpImportButton = null;
    private TimingConstraintsTable tpTable = null;
    private final String COUNT_LABEL_STRING = "Number of time windows specified : ";
    public static final int TABLE_WIDTH = 850;
    public static final int TABLE_HEIGHT = 150;
    public static final int ROW_HEIGHT = 30;

    public TimingConstraintsListEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    protected TimingConstraintsListEditor() {
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addLabel(jPanel, gridBagLayout, gridBagConstraints, tpCountLabelFID, "", "Number of time windows specified : ");
        this.addTable(jPanel, gridBagLayout, gridBagConstraints, string);
        this.addNonCollapsingGroup(jPanel, string);
        jPanel.setBorder(null);
    }

    protected void addTable(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        TimingConstraintsListModel timingConstraintsListModel = (TimingConstraintsListModel)this.getModel();
        this.tpAddButton = this.makeButton(addTPFID, "Add", "Add Time Range");
        this.tpEditButton = this.makeButton(editTPFID, "Edit", "Edit Time Range");
        this.tpDelButton = this.makeButton(delTPFID, "Delete", "Delete Time Range");
        this.tpDelAllButton = this.makeButton(delAllTPFID, "Delete All", "Delete all the timing constraints");
        this.tpImportButton = this.makeButton(importTPFID, "Import", "Import specified times from a file");
        this.tpImportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimingConstraintsListEditor.this.importTemporalConstraintsFromFile();
            }
        });
        int n = 160;
        int n2 = this.tpAddButton.getPreferredSize().height;
        this.tpAddButton.setPreferredSize(new Dimension(n, n2));
        this.tpEditButton.setPreferredSize(new Dimension(n, n2));
        this.tpDelButton.setPreferredSize(new Dimension(n, n2));
        this.tpDelAllButton.setPreferredSize(new Dimension(n, n2));
        this.tpImportButton.setPreferredSize(new Dimension(n, n2));
        this.tpTable = new TimingConstraintsTable(timingConstraintsListModel.getTimingConstraintsTableModel());
        this.tpTable.getTableHeader().setReorderingAllowed(false);
        this.tpTable.setSelectionMode(0);
        this.tpTable.setColumnSelectionAllowed(false);
        this.tpTable.getSelectionModel().addListSelectionListener(this);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.tpTable);
        scrollWhenFocusedPane.setPreferredSize(new Dimension(850, 150));
        this.tpTable.setToolTipText("List of Time Constraints");
        this.tpTable.setName("TimingConstraintListEditor.tpTable");
        this.initColumnSizes();
        this.tpTable.setRowHeight(30);
        this.initEvents(this.tpTable, TEMPORAL_PARAM_TABLE_FID);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.tpAddButton);
        jPanel2.add(this.tpEditButton);
        jPanel2.add(this.tpDelButton);
        jPanel2.add(this.tpDelAllButton);
        jPanel2.add(this.tpImportButton);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
    }

    @Override
    protected void build() {
        super.build("");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        TimingConstraintsListModel timingConstraintsListModel = (TimingConstraintsListModel)this.getModel();
        if (fieldID.equals(addTPFID)) {
            int n = this.tpTable.getSelectedRow();
            timingConstraintsListModel.addTemporalParameters(n + 1);
        } else if (fieldID.equals(editTPFID)) {
            int n = this.tpTable.getSelectedRow();
            int n2 = this.tpTable.getSelectedColumn();
            this.tpTable.editCellAt(n, n2);
        } else if (fieldID.equals(delTPFID)) {
            this.closeEditorIfOpen();
            int n = this.tpTable.getSelectedRow();
            timingConstraintsListModel.deleteTemporalParameters(n);
            if (n == 0) {
                if (timingConstraintsListModel.getTemporalParametersCount() != 0) {
                    this.tpTable.setRowSelectionInterval(n, n);
                }
            } else if (n == timingConstraintsListModel.getTemporalParametersCount()) {
                this.tpTable.setRowSelectionInterval(n - 1, n - 1);
            } else if (n != -1) {
                this.tpTable.setRowSelectionInterval(n, n);
            }
        } else if (fieldID.equals(delAllTPFID)) {
            this.closeEditorIfOpen();
            timingConstraintsListModel.clearTemporalParameters();
        } else if (fieldID.equals(timingParamStartDate)) {
            int n = this.tpTable.getSelectedRow();
            int n3 = this.tpTable.getSelectedColumn();
            this.tpTable.setValueAt((String)object, n, n3);
        } else if (!fieldID.equals(tpCountLabelFID)) {
            if (fieldID.equals(TEMPORAL_PARAM_TABLE_FID)) {
                this.setButtons(timingConstraintsListModel, true);
                this.fireTableDataChanged();
                return;
            }
            if (fieldID.equals(updateNote)) {
                String string = object.toString();
                timingConstraintsListModel.updateAssociatedeNote(string);
                return;
            }
            super.update(fieldID, object);
        }
        this.updateTargetCountLabel();
        this.setButtons(timingConstraintsListModel, false);
    }

    private void closeEditorIfOpen() {
        TableCellEditor tableCellEditor = this.tpTable.getCellEditor();
        if (tableCellEditor != null) {
            int n = this.tpTable.getSelectedRow();
            tableCellEditor.stopCellEditing();
            try {
                if (this.tpTable.getRowSelectionAllowed() && this.tpTable.getRowCount() > n) {
                    this.tpTable.setRowSelectionInterval(n, n);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void cancelEditorIfOpen() {
        TableCellEditor tableCellEditor = this.tpTable.getCellEditor();
        if (tableCellEditor != null) {
            int n = this.tpTable.getSelectedRow();
            tableCellEditor.cancelCellEditing();
            if (this.tpTable.getRowSelectionAllowed() && this.tpTable.getRowCount() > n) {
                this.tpTable.setRowSelectionInterval(n, n);
            }
        }
    }

    private void fireTableDataChanged() {
        TimingConstraintTableModel timingConstraintTableModel = (TimingConstraintTableModel)this.tpTable.getModel();
        timingConstraintTableModel.fireTableDataChanged();
    }

    private int getTemporalParameterCount() {
        TimingConstraintsListModel timingConstraintsListModel = (TimingConstraintsListModel)this.getModel();
        return null == timingConstraintsListModel ? 0 : timingConstraintsListModel.getTemporalParametersCount();
    }

    public void updateTargetCountLabel() {
        JLabel jLabel = (JLabel)this.retrieve(tpCountLabelFID);
        jLabel.setText("Number of time windows specified : " + this.getTemporalParameterCount());
    }

    private void setButtons(TimingConstraintsListModel timingConstraintsListModel, boolean bl) {
        boolean bl2;
        if (this.tpAddButton == null || this.tpDelButton == null) {
            return;
        }
        int n = this.getTemporalParameterCount();
        boolean bl3 = this.tpTable != null && this.tpTable.getEditorComponent() != null && this.tpTable.getEditorComponent().isShowing();
        boolean bl4 = this.tpTable != null && this.tpTable.getRowCount() > 0;
        boolean bl5 = bl2 = this.tpTable != null && this.tpTable.getSelectedRow() != -1;
        if (bl3 && !bl) {
            this.setEnabled(this.tpAddButton, false);
            this.setEnabled(this.tpEditButton, false);
            this.setEnabled(this.tpDelButton, false);
            this.setEnabled(this.tpDelAllButton, false);
            this.setEnabled(this.tpImportButton, false);
        } else {
            this.setEnabled(this.tpAddButton, true);
            this.setEnabled(this.tpEditButton, n > 0 && bl2);
            this.setEnabled(this.tpDelButton, n > 0 && bl2);
            this.setEnabled(this.tpDelAllButton, bl4);
            this.setEnabled(this.tpImportButton, true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons((TimingConstraintsListModel)this.getModel(), true);
    }

    private void initColumnSizes() {
        Object[] objectArray = ((TimingConstraintsListModel)this.getModel()).getTimingConstraintsTableModel().getReferenceValues();
        ColumnResizer.initColumnSizes(this.tpTable, objectArray);
    }

    public static void main(String[] stringArray) {
        Log.setRuntimeImplementation((Log.LoggerProvider)new LogLoggerProviderImpl());
        UnitMapConfigurator.configureUnitMaps();
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        int n = (int)almaPolicies.getMinAdvisedTimeMargin().getContentInUnits(Time.UNIT_D);
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        targetParameters.addField((Field)((Object)SinglePoint.createSinglePoint()));
        targetParameters.addField((Field)((Object)SinglePoint.createSinglePoint()));
        TemporalParameters temporalParameters = TemporalParameters.createTemporalParameters();
        ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC).withNano(0).plusDays(1L);
        ZonedDateTime zonedDateTime2 = zonedDateTime.plusDays(n);
        temporalParameters.setStartTimeInDate(zonedDateTime);
        temporalParameters.setEndTimeInDate(zonedDateTime2);
        temporalParameters.setAllowedMargin(Time.createTime((double)(n / 2), (String)Time.UNIT_D));
        performanceParameters.addTemporalParameters(0, temporalParameters);
        TimingConstraintsListModel timingConstraintsListModel = new TimingConstraintsListModel(null);
        TimingConstraintsListEditor timingConstraintsListEditor = new TimingConstraintsListEditor(timingConstraintsListModel);
        timingConstraintsListModel.setDocument(performanceParameters);
        TestUtilities.runTestApp(timingConstraintsListEditor);
    }

    private void importTemporalConstraintsFromFile() {
        JFileChooser jFileChooser = GuiFactory.getFactory().giveFileChooser("ImportTimingConstraints");
        this.cancelEditorIfOpen();
        jFileChooser.setDialogTitle("Import Timing Constraints");
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            TimingConstraintsListModel timingConstraintsListModel = (TimingConstraintsListModel)this.getModel();
            assert (file != null);
            assert (timingConstraintsListModel != null);
            if (file.exists()) {
                timingConstraintsListModel.importTimingConstraintsFromFile(file, false);
            } else {
                GUIUtilities.error(null, "File" + file + " does not exist.");
            }
        }
    }
}

