/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.TimeSummary;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import java.util.ArrayList;
import java.util.List;

public class AcaEstimatedTimeInfoBuilder {
    private final PerformanceParameters pp;
    private final ScienceGoal sg;

    public AcaEstimatedTimeInfoBuilder(PerformanceParameters performanceParameters) {
        this.pp = performanceParameters;
        this.sg = performanceParameters.getScienceGoal();
        if (this.sg == null) {
            throw new IllegalArgumentException("Can not find the parent ScienceGoal from this PerformanceParameters");
        }
    }

    public String info() {
        Object object;
        Object object2;
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        SpectralSetupParameters spectralSetupParameters = this.sg.getSpectralSetupParameters();
        TargetParameters targetParameters = this.sg.getSoleTargetParameters();
        ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(this.sg);
        Array array = Array.ARRAY_7M;
        UserSensitivity userSensitivity = this.pp.getDesiredACASensitivity();
        Sensitivity sensitivity = Sensitivity.createSensitivity();
        if (userSensitivity.inModelUnit()) {
            sensitivity.setContentAndUnit(userSensitivity);
        } else {
            sensitivity.setContentAndUnit(userSensitivity.getContentInDefaultUnits(), userSensitivity.defaultUnit());
        }
        sensitivity.convertToUnit(sensitivity.getFriendlyUnit());
        if (sensitivity.isZero(1.0E-9)) {
            arrayList.add("Requested Sensitivity");
            arrayList2.add(sensitivity + "(Invalid)");
            return this.build(arrayList, arrayList2);
        }
        Frequency frequency = this.sg.getRepresentativeFrequencyInSky();
        if (spectralSetupParameters.getScienceSpectralWindowCount() == 0) {
            arrayList.add("");
            arrayList2.add("No Spectral Window/Element is set.");
            return this.build(arrayList, arrayList2);
        }
        if (this.pp.getDesiredSensitivity().inTemperatureUnit() && this.pp.getDesiredAngularResolution().isZero()) {
            arrayList.add("");
            arrayList2.add("Desired angular reoslution must be positive to specify desired sensitivity in one of the temperature unit.");
            return this.build(arrayList, arrayList2);
        }
        if (PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_USER.equals(this.pp.getDesiredSensitivityFrequencyMeasure()) && this.pp.getDesiredSensitivityReferenceFrequencyWidth().getContent() <= 0.0) {
            arrayList.add("");
            arrayList2.add("Positive \"Frequency Width\" value must be set in choosing \"User\" type as \"Bandwidth used for Sensitivity\".");
            return this.build(arrayList, arrayList2);
        }
        Frequency frequency2 = this.pp.getSensitivityFrequencyWidth();
        Time time = null;
        Time time2 = null;
        Time time3 = null;
        Time time4 = null;
        Time time5 = null;
        Integer n = 1;
        int n2 = 0;
        try {
            time = observingTimeCalculator.singlePointOnSourceTime(array, targetParameters, true).convertToFriendlyUnit();
            time2 = observingTimeCalculator.getTotalOnSourceTime(array, true).convertToFriendlyUnit();
            time3 = observingTimeCalculator.getTotalRequestedTime(array).convertToFriendlyUnit();
            time4 = observingTimeCalculator.getOnSourceOverheadsTime(false, Array.ARRAY_12M).convertToFriendlyUnit();
            time5 = observingTimeCalculator.getOverheadTimeForCalObs().convertToFriendlyUnit();
            n = observingTimeCalculator.getNumberOfAntennaConfigurations(RequestedArray.TWELVE_M);
            n2 = observingTimeCalculator.getWaterVapourContentUsed();
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException exception) {
            string = exception.getMessage();
        }
        if (string != null) {
            string = string.substring(string.indexOf(":") + 1);
            string = string.trim();
        }
        Integer n3 = 0;
        Object object3 = this.sg.gettrueTargetParameters();
        int n4 = ((TargetParameters[])object3).length;
        for (int i = 0; i < n4; ++i) {
            object2 = object3[i];
            n3 = n3 + ((TargetParameters)object2).getNumberOfPointings();
        }
        arrayList.add("Requested Sensitivity");
        arrayList2.add(TextUtils.format(sensitivity, 4));
        arrayList.add("Representative Frequency (Sky, first source)");
        arrayList2.add(TextUtils.format(frequency, 2));
        arrayList.add("Bandwidth used for Sensitivity");
        String string2 = TextUtils.format(frequency2, 3);
        if (this.pp.isUserSpecificFrequencyWidth() && frequency2 instanceof UserFrequency && !((UserFrequency)(object3 = (UserFrequency)((Object)frequency2))).inModelUnit()) {
            string2 = String.format("%.3f %s", ((UserFrequency)object3).getUserContent(), object3.getUserUnit());
        }
        arrayList2.add(string2);
        arrayList.add("Water Vapour Content assumed:");
        arrayList2.add(WaterVaporColumns.getWVIndexLabel(n2));
        arrayList.add("Required Time on Source per Pointing");
        arrayList2.add(string != null ? string : TextUtils.format(time, 2));
        arrayList.add("Number of Antenna Configurations");
        arrayList2.add(n.toString());
        arrayList.add("Total Number of Pointings");
        arrayList2.add(n3.toString());
        arrayList.add("Total on Source");
        arrayList2.add(string != null ? string : TextUtils.format(time2, 2));
        arrayList.add("Estimated Overheads");
        arrayList2.add(string != null ? string : TextUtils.format(time4, 2));
        arrayList.add("Total Estimated Time (inc. Calibration and overheads)");
        arrayList2.add(string != null ? string : TextUtils.format(time3, 2));
        arrayList.add("");
        arrayList2.add("");
        if (string != null) {
            return this.build(arrayList, arrayList2);
        }
        arrayList.add("Calibration Breakdown");
        arrayList2.add("");
        object3 = observingTimeCalculator.getCalibrationTimeSummary();
        for (TimeSummary timeSummary : object3.values()) {
            object2 = timeSummary.getTotalTime().convertToFriendlyUnit();
            Long comparable = timeSummary.getNumExec();
            object = timeSummary.getType();
            String string3 = comparable + " x " + object.toString();
            if (timeSummary.isAtmCalIncluded()) {
                string3 = string3 + " (inc. AtmosphericCal)";
            }
            arrayList.add("&nbsp;" + string3);
            String string4 = TextUtils.format(((Time)object2).convertToFriendlyUnit(), 2);
            arrayList2.add(string4);
        }
        arrayList.add("Estimated Additional Cal. Overheads");
        arrayList2.add(string != null ? string : TextUtils.format(time5, 2));
        arrayList.add("");
        arrayList2.add("");
        arrayList.add("Achievable Sensitivity");
        arrayList2.add("");
        try {
            for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                string = null;
                object = observingTimeCalculator.singlePointOnSourceSensitivity(array, time, targetParameters, scienceSpectralWindow);
                object.convertToUnit(object.getFriendlyUnit());
                arrayList.add(scienceSpectralWindow.shortDescription() + " with " + array);
                arrayList2.add(TextUtils.format(object, 4));
            }
        }
        catch (SourceNeverVisibleException | InvalidFrequencyException exception) {
            GUIUtilities.warning(null, exception.getMessage());
        }
        return this.build(arrayList, arrayList2);
    }

    private String build(List<String> list, List<String> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body><center><font size=+2>Estimated time on ACA 7M</font></center><br>");
        stringBuilder.append("<table>");
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append("<tr><td>");
            stringBuilder.append(list.get(i));
            stringBuilder.append("</td><td>");
            stringBuilder.append(list2.get(i));
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("</table>");
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }
}

