/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.ot.editors.schedblock.NoDeselectListSelectionModel;
import alma.obsprep.ot.editors.schedblock.ResolverTableModel;
import alma.obsprep.ot.editors.sciencegoals.ColumnGroup;
import alma.obsprep.ot.editors.sciencegoals.GroupableTableColumnModel;
import alma.obsprep.ot.editors.sciencegoals.GroupableTableHeader;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.util.astro.Resolver;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.jdesktop.layout.GroupLayout;

public class NameResolverResultsDialog
extends GuiFactory.Dialog {
    private Resolver selected = null;
    private final ResolverTableModel tableModel = new ResolverTableModel();
    private JButton cancelButton;
    private JScrollPane scrollPane;
    private JButton selectButton;
    private JTable table;
    private JLabel titleLabel;
    private JLabel warningLabel;

    public NameResolverResultsDialog(Frame frame) {
        super(frame);
        this.setTitle("Name Resolver Results");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            int n = this.table.getSelectionModel().getMinSelectionIndex();
            if (n > -1) {
                Resolver resolver = this.tableModel.get(n);
                if (resolver.getProperMotionRa() == Resolver.NODATA || resolver.getProperMotionDec() == Resolver.NODATA || resolver.getSourceVelocity() == null) {
                    this.warningLabel.setVisible(true);
                } else {
                    this.warningLabel.setVisible(false);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.rescaleToMonitor(0.45);
        }
        super.setVisible(bl);
    }

    public void setResults(Collection<Resolver> collection, String string) {
        String string2;
        this.tableModel.setResults(collection);
        int n = collection.size();
        String string3 = "N/A";
        if (n > 0) {
            string2 = this.tableModel.get(0).getNameServer();
            string3 = this.tableModel.get(0).getResolverService().getResolutionServiceName();
        } else {
            string2 = "An unknown server";
        }
        String string4 = String.format("%s (%s) found %s %s for the object '%s'.", string2, string3, n, n == 1 ? "match" : "matches", string);
        this.titleLabel.setText(string4);
        if (collection != null && collection.size() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.selectButton.requestFocusInWindow();
    }

    public Resolver getSelected() {
        return this.selected;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.warningLabel = new JLabel();
        this.scrollPane = new ScrollWhenFocusedPane();
        this.table = new JTable();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.selectButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.titleLabel.setText("Found %s matches for J1234+056");
        this.warningLabel.setText("Warning! Your selected result is missing proper motion and/or velocity.");
        this.warningLabel.setIcon(Icons.warning);
        this.table.setColumnModel(new GroupableTableColumnModel());
        this.table.setTableHeader(new GroupableTableHeader((GroupableTableColumnModel)this.table.getColumnModel()));
        this.table.setModel(this.tableModel);
        GroupableTableColumnModel groupableTableColumnModel = (GroupableTableColumnModel)this.table.getColumnModel();
        ColumnGroup columnGroup = new ColumnGroup("Position");
        columnGroup.add(groupableTableColumnModel.getColumn(1));
        columnGroup.add(groupableTableColumnModel.getColumn(2));
        ColumnGroup columnGroup2 = new ColumnGroup("Proper Motion");
        columnGroup2.add(groupableTableColumnModel.getColumn(3));
        columnGroup2.add(groupableTableColumnModel.getColumn(4));
        groupableTableColumnModel.addColumnGroup(columnGroup);
        groupableTableColumnModel.addColumnGroup(columnGroup2);
        this.table.setSelectionModel(new NoDeselectListSelectionModel());
        this.table.setSelectionMode(0);
        this.table.setColumnSelectionAllowed(false);
        this.scrollPane.setViewportView(this.table);
        this.selectButton.setText("Select");
        this.selectButton.setToolTipText("Import highlighted match into the OT");
        this.selectButton.addActionListener(actionEvent -> this.selectButtonActionPerformed(actionEvent));
        this.setDefaultButton(this.selectButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel selection and close dialog");
        this.cancelButton.addActionListener(actionEvent -> this.cancelButtonActionPerformed(actionEvent));
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.scrollPane).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.titleLabel).add((Component)this.warningLabel)).add(0, 0, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.selectButton))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.titleLabel).add(18, 18, 18).add((Component)this.warningLabel).addPreferredGap(1).add((Component)this.scrollPane, -1, 208, Short.MAX_VALUE).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.selectButton).add((Component)this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
        this.selected = null;
    }

    private void selectButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
        int n = this.table.getSelectedRow();
        this.selected = this.tableModel.get(n);
    }

    public static void main(String[] stringArray) {
        try {
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                if (!"Metal".equals(lookAndFeelInfo.getName())) continue;
                UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.getLogger(NameResolverResultsDialog.class.getName()).log(Level.SEVERE, null, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Logger.getLogger(NameResolverResultsDialog.class.getName()).log(Level.SEVERE, null, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(NameResolverResultsDialog.class.getName()).log(Level.SEVERE, null, illegalAccessException);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            Logger.getLogger(NameResolverResultsDialog.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
        }
        EventQueue.invokeLater(() -> {
            NameResolverResultsDialog nameResolverResultsDialog = new NameResolverResultsDialog(new JFrame());
            nameResolverResultsDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            nameResolverResultsDialog.setVisible(true);
        });
    }
}

