/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.common.sourcecatalog.Measurement;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.AbstractTargetParameters;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.ValueUnitPairCellRenderer;
import alma.obsprep.ot.editors.misc.ValueUnitPairCellEditor;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetSelectorDialog;
import alma.obsprep.ot.editors.obsproject.QuerySourceEditor;
import alma.obsprep.ot.editors.schedblock.FieldPatternEditor;
import alma.obsprep.ot.editors.schedblock.ReferenceEditor;
import alma.obsprep.ot.editors.schedblock.SolarSystemTargetAwareEditor;
import alma.obsprep.ot.editors.schedblock.UsedByTargetPanel;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.schedblock.FieldSourceModel;
import alma.obsprep.ot.models.schedblock.TargetModel;
import alma.obsprep.ot.models.schedblock.UsedByTargetModel;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.help.CSH;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class FieldSourceEditor
extends SolarSystemTargetAwareEditor
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = -572752221654385334L;
    public static final FieldID USE_QUERY_FID = new FieldID("FieldSourceEditor.useQueryFID");
    public static final FieldID FIELDSOURCE_GROUP_FID = new FieldID("FieldSourceEditor.fieldSourceGroupFID");
    public static final FieldID QUERY_EDITOR_GROUP_FID = new FieldID("FieldSourceEditor.queryEditorPanelFID");
    public static final FieldID FIELDSOURCENAME_FID = new FieldID("FieldSourceEditor.fieldSourceNameFID");
    public static final FieldID SOURCENAME_FID = new FieldID("FieldSourceEditor.sourceNameFID");
    public static final FieldID RESOLVE_FID = new FieldID("FieldSourceEditor.resolveFID");
    public static final FieldID NONSIDEREAL_FID = new FieldID("FieldSourceEditor.nonSiderealFID");
    public static final FieldID SOLARSYSTEMOBJECT_FID = new FieldID("FieldSourceEditor.solarSystemObjectFID");
    public static final FieldID SOURCEEPHEMERIS_FID = new FieldID("FieldSourceEditor.sourceEphemerisFID");
    public static final FieldID SOURCEPROPERTIES_FID = new FieldID("FieldSourceEditor.sourcePropertiesFID");
    public static final FieldID VISIBLEMAGNITUDE_FID = new FieldID("FieldSourceEditor.visibleMagnitudeFID");
    public static final FieldID REFERENCE_USED_FID = new FieldID("FieldSourceEditor.referenceUsedFID");
    public static final FieldID REFERENCE_GROUP_FID = new FieldID("FieldSourceEditor.ReferencePositionGroup");
    public static final FieldID FIXED_CALIBRATOR_SELECTED = new FieldID("FieldSourceEditor.fixedCalibratorSelectedFID");
    private JButton spAddButton = null;
    private JButton spDelButton = null;
    private final JButton findCalButton = new JButton("Convert Dynamic Calibrator to Fixed Calibrator...");
    private JTable spTable = null;
    private JButton spPrint = null;
    private final FieldID addSPFID = new FieldID("FieldSourceEditor.addSourceProperty");
    private final FieldID delSPFID = new FieldID("FieldSourceEditor.delSourceProperty");
    private FieldPatternEditor fieldPatternEditor;
    private final Set<Component> componentsToRemainWhenQuerySelected = new HashSet<Component>();

    public FieldSourceEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    protected FieldSourceEditor() {
    }

    @Override
    public FieldSourceModel getModel() {
        return (FieldSourceModel)super.getModel();
    }

    @Override
    protected void addComponents(String string) {
        this.addUsedByTargetInfoComponent();
        JComponent jComponent = this.addQuerySourceComponents("Query Status");
        jComponent = this.addFieldSourceComponents("Field Source");
        CSH.setHelpIDString((Component)jComponent, (String)"TOC-Phase 2 Program Scheduling Blocks-Field Sources-Field Source");
        CSH.setHelpIDString((Component)jComponent, (String)"TOC-Phase 2 Program Scheduling Blocks-Field Sources-Query Status");
        this.addQueryEditorPanel("Query Editor");
        jComponent = this.addReferenceComponents("Reference Position (Offset)");
        CSH.setHelpIDString((Component)jComponent, (String)"TOC-Phase 2 Program Scheduling Blocks-Field Sources-Reference Position (Offset)");
        jComponent = this.addFieldPatternComponent("Field Pattern");
        CSH.setHelpIDString((Component)this.fieldPatternEditor, (String)"TOC-Phase 2 Program Scheduling Blocks-Field Sources-FieldPatternEditor");
    }

    protected void addUsedByTargetInfoComponent() {
        UsedByTargetModel usedByTargetModel = this.getModel().getUsedByTargetModel();
        UsedByTargetPanel usedByTargetPanel = new UsedByTargetPanel(usedByTargetModel);
        ActionListener actionListener = actionEvent -> {
            ObservingToolGui observingToolGui;
            boolean bl = this.getModel().isTargetContext();
            if (bl && (observingToolGui = ObservingToolController.getMyInstance().getGui()) != null) {
                TargetModel targetModel = (TargetModel)observingToolGui.getEditors().modelFor(Target.class);
                targetModel.duplicateFieldSource();
                observingToolGui.refreshCrossHighlight();
            }
        };
        usedByTargetPanel.addOnlyThisButtonListener(actionListener);
        this.addComponent(usedByTargetPanel);
        this.registerSubView(usedByTargetPanel);
    }

    private JPanel addReferenceComponents(String string) {
        FieldSourceModel fieldSourceModel = this.getModel();
        ReferenceEditor referenceEditor = new ReferenceEditor(fieldSourceModel.getReferenceModel());
        JPanel jPanel = new JPanel();
        jPanel.add(referenceEditor);
        JPanel jPanel2 = this.addGroup(jPanel, string);
        this.register(referenceEditor, REFERENCE_GROUP_FID);
        referenceEditor.setVisible(false);
        return jPanel2;
    }

    protected JComponent addQuerySourceComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        componentCollection.remember(this.makeLabel("Select target from ALMA calibrator catalogue at execution time"));
        componentCollection.remember(this.makeCheckBox(USE_QUERY_FID, "Check box to find target at execution time"));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        return this.addNonCollapsingGroup(jPanel, "Query Status");
    }

    protected void addQueryEditorPanel(String string) {
        FieldSourceModel fieldSourceModel = this.getModel();
        CalibratorExpertModel calibratorExpertModel = fieldSourceModel.getCalibratorExpertModel();
        QuerySourceEditor querySourceEditor = new QuerySourceEditor(calibratorExpertModel);
        querySourceEditor.setPreferredSize(new Dimension(800, 400));
        this.register(querySourceEditor, QUERY_EDITOR_GROUP_FID);
        this.addComponent(querySourceEditor);
        this.addComponent(this.findCalButton);
        this.findCalButton.addActionListener(actionEvent -> {
            Object object;
            CalibratorExpertModel calibratorExpertModel = this.getModel().getCalibratorExpertModel();
            IQuerySource iQuerySource = this.getModel().getQuerySource().deepCopy();
            ObservatoryGoalTargetSelectorDialog observatoryGoalTargetSelectorDialog = new ObservatoryGoalTargetSelectorDialog(calibratorExpertModel, false);
            observatoryGoalTargetSelectorDialog.setVisible(true);
            List<Measurement> list = observatoryGoalTargetSelectorDialog.getSelected();
            if (list.size() == 1) {
                object = list.get(0);
                this.getController().widgetUpdated(this, FIXED_CALIBRATOR_SELECTED, object);
            }
            object = new QuerySourceAdapter(iQuerySource);
            calibratorExpertModel.setDocument(object);
        });
    }

    protected JComponent addFieldSourceComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.addFieldSourceComponentsBeforeSourceProperties(jPanel, gridBagLayout, gridBagConstraints, string);
        JComponent jComponent = this.retrieve(SOURCEEPHEMERIS_FID);
        this.setVisible(jComponent, false);
        this.addSourceProperties(jPanel, gridBagLayout, gridBagConstraints, string);
        this.addFieldSourceComponentsAfterSourceProperties(jPanel, gridBagLayout, gridBagConstraints, string);
        this.register(jPanel, FIELDSOURCE_GROUP_FID);
        return this.addNonCollapsingGroup(jPanel, "Field Source");
    }

    protected void addFieldSourceComponentsBeforeSourceProperties(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        JTextField jTextField = this.makeTextField(FIELDSOURCENAME_FID, "Name of this " + string);
        JLabel jLabel = this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, string + " Name", (JComponent)jTextField);
        jTextField.setColumns(50);
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        componentCollection.remember(this.makeLabel("Source Name"));
        Box box = Box.createHorizontalBox();
        box.add(this.makeTextField(SOURCENAME_FID, "The name of the source"));
        box.add(this.makeButton(RESOLVE_FID, "Resolve", "Get source details from SIMBAD or NED"));
        componentCollection.remember((JComponent)box, 2);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        box = Box.createHorizontalBox();
        componentCollection.remember(this.makeLabel("Choose a Solar System Object?"));
        box.add(this.makeCheckBox(NONSIDEREAL_FID, "Is this a solar system (non-sidereal motion) object?"));
        box.add(this.makeLabel("Select Object  "));
        box.add(this.makeComboBox(SOLARSYSTEMOBJECT_FID, FieldSource.getKnownSolarSystemObjectList(), "Name of object"));
        componentCollection.remember(box);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.addOTFileArea(jPanel, gridBagLayout, gridBagConstraints, SOURCEEPHEMERIS_FID, 300, 150, "", "Source ephemeris in HORIZONS format, see manual for details");
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints);
        this.addSolarSystemTargetAwareEditorComponents(jPanel, gridBagLayout, gridBagConstraints);
        this.componentsToRemainWhenQuerySelected.add(jTextField);
        this.componentsToRemainWhenQuerySelected.add(jLabel);
    }

    protected void addSourceProperties(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        FieldSourceModel fieldSourceModel = this.getModel();
        this.spAddButton = this.makeButton(this.addSPFID, "Add", "Add a Source Property");
        this.spDelButton = this.makeButton(this.delSPFID, "Delete", "Delete a Source Property");
        this.spTable = new Table(fieldSourceModel.getSourcePropertiesTableModel()){
            private static final long serialVersionUID = -901738822948690223L;

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = this.getSelectedRow();
                super.tableChanged(tableModelEvent);
                if (n < this.getRowCount() && n >= 0) {
                    this.setRowSelectionInterval(n, n);
                }
            }
        };
        this.spTable.getTableHeader().setReorderingAllowed(false);
        this.spTable.setDefaultEditor(Frequency.class, new ValueUnitPairCellEditor.FrequencyEditor());
        this.spTable.setDefaultEditor(Sensitivity.class, new ValueUnitPairCellEditor.SensitivityEditor());
        this.spTable.setDefaultEditor(Angle.class, new ValueUnitPairCellEditor.AngleEditor());
        this.spTable.setDefaultRenderer(AbstractDoubleWithUnit.class, new ValueUnitPairCellRenderer());
        int n = this.spDelButton.getPreferredSize().height;
        Dimension dimension = new Dimension(this.spTable.getPreferredSize());
        dimension.height = n * 3;
        this.spTable.setPreferredScrollableViewportSize(dimension);
        this.spTable.setSelectionMode(0);
        this.spTable.setColumnSelectionAllowed(false);
        this.spTable.getSelectionModel().addListSelectionListener(this);
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.spTable);
        this.spTable.setToolTipText("The known properties of the source at the indicated frequencies");
        this.initEvents(this.spTable, SOURCEPROPERTIES_FID);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, new JLabel("Source Properties"));
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        this.spPrint = new JButton("Print");
        this.spPrint.addActionListener(this);
        this.spAddButton.setPreferredSize(this.spDelButton.getPreferredSize());
        this.spPrint.setPreferredSize(this.spDelButton.getPreferredSize());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.spAddButton);
        jPanel2.add(this.spDelButton);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, jPanel2);
    }

    protected void addFieldSourceComponentsAfterSourceProperties(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string) {
        EditorWithGridBagLayout.ComponentCollection componentCollection = new EditorWithGridBagLayout.ComponentCollection(this);
        componentCollection.remember(this.makeLabel("Visible Magnitude"));
        componentCollection.remember(this.makeTextFieldWithDoubleVerifier(VISIBLEMAGNITUDE_FID, "This source's visible magnitude", -1.7976931348623157E308, Double.MAX_VALUE));
        componentCollection.spaces(1);
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.addBooleanComponent(jPanel, gridBagLayout, gridBagConstraints, REFERENCE_USED_FID, "Use Reference", "Offset reference position, e.g blank sky");
    }

    @Override
    protected void build() {
        super.build("FieldSource");
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        super.modelChanged(model, fieldID, object);
        if (fieldID.equals(USE_QUERY_FID)) {
            if (object instanceof Boolean) {
                JPanel jPanel;
                Boolean bl = (Boolean)object;
                JPanel jPanel2 = (JPanel)this.retrieve(FIELDSOURCE_GROUP_FID);
                if (jPanel2 != null) {
                    jPanel2.setVisible(bl == false);
                }
                if ((jPanel = (JPanel)this.retrieve(QUERY_EDITOR_GROUP_FID)) != null) {
                    jPanel.setVisible(bl);
                }
                this.findCalButton.setVisible(bl);
            } else {
                throw new AssertionError((Object)"Use query checkbox is publishing non-booleans");
            }
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        FieldSourceModel fieldSourceModel = this.getModel();
        if (fieldID.equals(this.addSPFID)) {
            int n = this.spTable.getSelectedRow();
            fieldSourceModel.addSourceProperty(n + 1);
        } else if (fieldID.equals(this.delSPFID)) {
            int n = this.spTable.getSelectedRow();
            fieldSourceModel.deleteSourceProperty(n);
            if (n == 0) {
                if (fieldSourceModel.getSourcePropertiesCount() != 0) {
                    this.spTable.setRowSelectionInterval(n, n);
                }
            } else if (n == fieldSourceModel.getSourcePropertiesCount()) {
                this.spTable.setRowSelectionInterval(n - 1, n - 1);
            } else if (n != -1) {
                this.spTable.setRowSelectionInterval(n, n);
            }
        } else {
            if (fieldID == RESOLVE_FID) {
                return;
            }
            if (fieldID == REFERENCE_USED_FID) {
                JPanel jPanel = (JPanel)this.retrieve(REFERENCE_GROUP_FID);
                if (jPanel != null) {
                    Boolean bl = new Boolean(object.toString());
                    jPanel.setVisible(bl);
                }
                super.update(fieldID, object);
                return;
            }
            if (fieldID == NONSIDEREAL_FID) {
                Boolean bl = new Boolean(object.toString());
                boolean bl2 = (Boolean)object;
                boolean bl3 = bl2 && (AbstractTargetParameters.SOLARSYSTEMOBJECT_SUN.equals(this.getModel().getFieldSource().getSolarSystemObject()) || AbstractTargetParameters.SOLARSYSTEMOBJECT_EPHEMERIS.equals(this.getModel().getFieldSource().getSolarSystemObject()));
                this.showExtraSolarSystemComponents(bl == false, bl3);
                JComboBox jComboBox = (JComboBox)this.retrieve(SOLARSYSTEMOBJECT_FID);
                this.setEnabled(jComboBox, bl);
                if (bl.booleanValue()) {
                    this.getModel().update(this, SOLARSYSTEMOBJECT_FID, jComboBox.getSelectedItem());
                }
                super.update(fieldID, bl);
                this.updateEphemerisField();
                return;
            }
            if (fieldID == SOLARSYSTEMOBJECT_FID) {
                super.update(fieldID, object);
                this.updateEphemerisField();
                return;
            }
            super.update(fieldID, object);
        }
        this.setSourcePropertyButtons();
    }

    private void updateEphemerisField() {
        JCheckBox jCheckBox = (JCheckBox)this.retrieve(NONSIDEREAL_FID);
        JComboBox jComboBox = (JComboBox)this.retrieve(SOLARSYSTEMOBJECT_FID);
        JComponent jComponent = this.retrieve(SOURCEEPHEMERIS_FID);
        boolean bl = jCheckBox.isSelected();
        boolean bl2 = jComboBox.getSelectedItem() == FieldSource.SOLARSYSTEMOBJECT_EPHEMERIS;
        this.setVisible(jComponent, bl && bl2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        FieldSourceModel fieldSourceModel = this.getModel();
        if (jButton.equals(this.spPrint)) {
            this.logTable(fieldSourceModel.getSourcePropertiesTableModel());
        }
    }

    private void logTable(TableModel tableModel) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        for (n = 0; n < tableModel.getColumnCount(); ++n) {
            stringBuffer.append(tableModel.getColumnName(n));
            stringBuffer.append('\t');
        }
        stringBuffer.append('\n');
        for (n = 0; n < tableModel.getRowCount(); ++n) {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                stringBuffer.append(tableModel.getValueAt(n, i));
                stringBuffer.append("\t\t");
            }
            stringBuffer.append('\n');
        }
        Log.logger((Object)this).info(stringBuffer.toString());
    }

    private void setSourcePropertyButtons() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.spAddButton == null || this.spDelButton == null) {
            return;
        }
        int n = this.getModel().getSourcePropertiesCount();
        this.setEnabled(this.spAddButton, n < AbstractBaseBandConfig.maxChannelAverageRegionCount());
        this.setEnabled(this.spDelButton, n > 0 && this.spTable.getSelectedRow() != -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setSourcePropertyButtons();
    }

    private JPanel addFieldPatternComponent(String string) {
        this.fieldPatternEditor = new FieldPatternEditor(this.getModel().getFieldPatternModel());
        this.registerSubView(this.fieldPatternEditor);
        this.addComponent(this.fieldPatternEditor);
        return this.fieldPatternEditor;
    }

    public FieldPatternEditor getFieldPatternEditor() {
        return this.fieldPatternEditor;
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config/otData");
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("FieldSourceEditor:Test");
        jFrame.setPreferredSize(new Dimension(600, 800));
        jFrame.setDefaultCloseOperation(3);
        FieldSourceModel fieldSourceModel = new FieldSourceModel(null);
        FieldSourceEditor fieldSourceEditor = new FieldSourceEditor(fieldSourceModel);
        FieldSource fieldSource = FieldSource.createFieldSource();
        fieldSource.addReference(Reference.createReference());
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        SchedulingConstraints schedulingConstraints = SchedulingConstraints.createSchedulingConstraints();
        schedulingConstraints.setRepresentativeFrequency(Frequency.createFrequencyGHZ(230.0));
        schedBlock.setSchedulingConstraints(schedulingConstraints);
        schedBlock.addFieldSource(fieldSource);
        ((Model)fieldSourceModel).setDocument(fieldSource);
        JScrollPane jScrollPane = new JScrollPane(fieldSourceEditor);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        return object;
    }
}

