/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.ICalibratorExpertDocument;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.verifiers.DecVerifier;
import alma.obsprep.guiutil.mvc.verifiers.DoubleVerifier;
import alma.obsprep.guiutil.mvc.verifiers.IntegerVerifier;
import alma.obsprep.guiutil.mvc.verifiers.RAVerifier;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FrequencyVerifier;
import alma.obsprep.ot.boEditors.NonNegativeVerifier;
import alma.obsprep.ot.boEditors.TimeVerifier;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class QuerySourceEditor
extends EditorWithGridBagLayout {
    public static final int AMPLITUDE_CALIBRATOR = 0;
    public static final int PHASE_CALIBRATOR = 1;
    public static final int POINTING_CALIBRATOR = 2;
    public static final int POLARIZATION_CALIBRATOR = 3;
    public static final int FOCUS_CALIBRATOR = 4;
    public static final int BANDPASS_CALIBRATOR = 5;
    public static final int NO_CALIBRATOR = 6;
    public static final FieldID catlocFID = new FieldID("Calibrator Expert catlocFID");
    public static final FieldID raFID = new FieldID("Calibrator Expert raFID");
    public static final FieldID decFID = new FieldID("Calibrator Expert decFID");
    public static final FieldID radiusFID = new FieldID("Calibrator Expert radiusFID");
    public static final FieldID freqminFID_value = new FieldID("Calibrator Expert freqminValFID");
    public static final FieldID freqminFID_unit = new FieldID("Calibrator Expert freqminUnitFID");
    public static final FieldID freqmaxFID_value = new FieldID("Calibrator Expert freqmaxValFID");
    public static final FieldID freqmaxFID_unit = new FieldID("Calibrator Expert freqmaxUnitFID");
    public static final FieldID fluxminFID_value = new FieldID("Calibrator Expert fluxminValFID");
    public static final FieldID fluxminFID_unit = new FieldID("Calibrator Expert fluxminUnitFID");
    public static final FieldID fluxmaxFID_value = new FieldID("Calibrator Expert fluxmaxValFID");
    public static final FieldID fluxmaxFID_unit = new FieldID("Calibrator Expert fluxmaxUnitFID");
    public static final FieldID timeminFID_value = new FieldID("Calibrator Expert timeminValFID");
    public static final FieldID timeminFID_unit = new FieldID("Calibrator Expert timeminUnitFID");
    public static final FieldID timemaxFID_value = new FieldID("Calibrator Expert timemaxValFID");
    public static final FieldID timemaxFID_unit = new FieldID("Calibrator Expert timemaxUnitFID");
    public static final FieldID caltypeFID = new FieldID("Calibrator Expert caltypeFID");
    public static final FieldID filterFID = new FieldID("Calibrator Expert filterFID");
    public static final FieldID sortByFID = new FieldID("Calibrator Expert sortByFID");
    public static final FieldID maxSourcesFID = new FieldID("Calibrator Expert maxSourcesFID");
    public static final FieldID sortAscendingFID = new FieldID("Calibrator Expert sortAscendingFID");
    public static final FieldID sourceTypeFID = new FieldID("CalibratorExpert sourceTypeFID");
    private JLabel calibratorTagLabel;
    private JLabel helpLabel;
    private JLabel zeroLabel;
    private JLabel searchLabel;
    private JLabel raLabel;
    private JLabel decLabel;
    private JLabel searchRadiusLabel;
    private JLabel fluxLabel;
    private JLabel minFluxLabel;
    private JLabel maxFluxLabel;
    private JLabel frequencyLabel;
    private JLabel maxFrequencyLabel;
    private JLabel minFrequencyLabel;
    private JLabel timeLabel;
    private JLabel minTimeLabel;
    private JLabel maxTimeLabel;
    private JLabel maxSourcesLabel;
    private JTextField maxSources;
    private JPanel searchParametersPanel;
    private ValueUnitPairEditor minFrequency;
    private ValueUnitPairEditor maxFrequency;
    private ValueUnitPairEditor minFlux;
    private ValueUnitPairEditor maxFlux;
    private ValueUnitPairEditor minTime;
    private ValueUnitPairEditor maxTime;
    private JTextField ra;
    private JTextField dec;
    private JTextField searchRadius;
    private JPanel cataloguePanel;

    public QuerySourceEditor(Model model) {
        this.setModel(model);
        this.buildCatalogueLocationPanel();
        this.buildQueryEditorPanel();
        this.build();
        model.publish();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        super.modelChanged(model, fieldID, object);
        CalibratorExpertModel calibratorExpertModel = this.getCalibratorExpertModel();
        ICalibratorExpertDocument iCalibratorExpertDocument = (ICalibratorExpertDocument)calibratorExpertModel.getDocument();
        if (iCalibratorExpertDocument == null) {
            return;
        }
        if (iCalibratorExpertDocument.getMinFlux().getContent() == 0.0 && iCalibratorExpertDocument.getMaxFlux().getContent() == 0.0) {
            this.fluxLabel.setIcon(Icons.filterDisabled);
        } else {
            this.fluxLabel.setIcon(Icons.filterEnabled);
        }
        if (iCalibratorExpertDocument.getMinFrequency().getContent() == 0.0 && iCalibratorExpertDocument.getMaxFrequency().getContent() == 0.0) {
            this.frequencyLabel.setIcon(Icons.filterDisabled);
        } else {
            this.frequencyLabel.setIcon(Icons.filterEnabled);
        }
        if (iCalibratorExpertDocument.getLatestObservation() == null && iCalibratorExpertDocument.getEarliestObservation() == null) {
            this.timeLabel.setIcon(Icons.filterDisabled);
        } else {
            this.timeLabel.setIcon(Icons.filterEnabled);
        }
        if (iCalibratorExpertDocument.getRadius() == 0.0) {
            this.searchLabel.setIcon(Icons.filterDisabled);
        } else {
            this.searchLabel.setIcon(Icons.filterEnabled);
        }
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (timeminFID_value.equals(fieldID) || timemaxFID_value.equals(fieldID)) {
            if (object instanceof String && !((String)object).isEmpty()) {
                Double d = Double.valueOf((String)object);
                Double d2 = d / 86400.0;
                object = d2;
            }
        } else if (catlocFID.equals(fieldID)) {
            if (CalibratorExpert.SourceCatalog.OFFLINE.getName().equals(object)) {
                this.calibratorTagLabel.setVisible(false);
                this.minTime.setVisible(false);
                this.minTimeLabel.setVisible(false);
                this.maxTime.setVisible(false);
                this.maxTimeLabel.setVisible(false);
                this.timeLabel.setVisible(false);
            } else {
                this.calibratorTagLabel.setVisible(true);
                this.minTime.setVisible(false);
                this.minTimeLabel.setVisible(false);
                this.maxTime.setVisible(false);
                this.maxTimeLabel.setVisible(false);
                this.timeLabel.setVisible(false);
            }
        }
        super.update(fieldID, object);
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (timeminFID_value.equals(fieldID) || timemaxFID_value.equals(fieldID)) {
            Double d = Double.parseDouble((String)object);
            Double d2 = d * 86400.0;
            object = d2.toString();
        }
        return super.widgetUpdated(fieldID, object);
    }

    @Override
    public void addComponents(String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.addNonCollapsingGroup(4, this, gridBagLayout, gridBagConstraints, this.searchParametersPanel, "Source Catalog Search Parameters");
    }

    private void buildCatalogueLocationPanel() {
        this.cataloguePanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(this.cataloguePanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.addOTButtonGroup((JComponent)this.cataloguePanel, gridBagLayout, gridBagConstraints, catlocFID, "Catalogue Location ", "Select location of the catalogue", CalibratorExpert.SourceCatalog.getNames());
    }

    private void buildQueryEditorPanel() {
        CalibratorExpertModel calibratorExpertModel = this.getCalibratorExpertModel();
        this.searchParametersPanel = new JPanel();
        this.zeroLabel = new JLabel();
        this.helpLabel = new JLabel();
        this.searchLabel = new JLabel();
        this.raLabel = new JLabel();
        this.decLabel = new JLabel();
        this.searchRadiusLabel = new JLabel();
        this.frequencyLabel = new JLabel();
        this.minFrequencyLabel = new JLabel();
        this.maxFrequencyLabel = new JLabel();
        this.fluxLabel = new JLabel();
        this.minFluxLabel = new JLabel();
        this.maxFluxLabel = new JLabel();
        this.timeLabel = new JLabel();
        this.minTimeLabel = new JLabel();
        this.maxTimeLabel = new JLabel();
        this.calibratorTagLabel = new JLabel();
        this.fluxLabel.setIconTextGap(12);
        this.frequencyLabel.setIconTextGap(12);
        this.timeLabel.setIconTextGap(12);
        this.searchLabel.setIconTextGap(12);
        this.ra = this.makeTextField(raFID, 14, true, "Centre Right Ascension of Cone Search");
        this.dec = this.makeTextField(decFID, 14, true, "Centre Declination of Cone Search");
        this.searchRadius = this.makeTextField(radiusFID, 14, true, "Search radius of cone search, in degrees");
        this.minFrequency = this.makeValueUnitPairEditor(calibratorExpertModel.getMinFreqModel(), "Minimum Frequency");
        this.maxFrequency = this.makeValueUnitPairEditor(calibratorExpertModel.getMaxFreqModel(), "Maximum Frequency");
        this.minFlux = this.makeValueUnitPairEditor(calibratorExpertModel.getMinFluxModel(), "Minimum Flux");
        this.maxFlux = this.makeValueUnitPairEditor(calibratorExpertModel.getMaxFluxModel(), "Maximum Flux");
        this.minTime = this.makeValueUnitPairEditor(calibratorExpertModel.getMinLastObservedModel(), "Minimum Time Since Last Observation");
        this.maxTime = this.makeValueUnitPairEditor(calibratorExpertModel.getMaxLastObservedModel(), "Maximum Time Since Last Observation");
        this.maxSources = this.makeTextField(maxSourcesFID, 3, true, "Maximum number of sources to return. Must be between 1-100.");
        this.setVerifier(this.ra, "FOCUSLOST_VERIFIER", new RAVerifier(this, this.ra));
        this.setVerifier(this.dec, "FOCUSLOST_VERIFIER", new DecVerifier(this, this.dec));
        this.setVerifier(this.searchRadius, "FOCUSLOST_VERIFIER", new DoubleVerifier((Editor)this, this.searchRadius, 0.0, 360.0));
        this.minFrequency.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(this.minFrequency, 0.0, 100000.0));
        this.maxFrequency.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(this.maxFrequency, 0.0, 100000.0));
        this.minFlux.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(this.minFlux));
        this.maxFlux.setVerifier("FOCUSLOST_VERIFIER", new NonNegativeVerifier(this.maxFlux));
        this.minTime.setVerifier("FOCUSLOST_VERIFIER", new TimeVerifier(this.minTime));
        this.maxTime.setVerifier("FOCUSLOST_VERIFIER", new TimeVerifier(this.maxTime));
        this.setVerifier(this.maxSources, "FOCUSLOST_VERIFIER", new IntegerVerifier(this, this.maxSources, 0, 100));
        this.searchParametersPanel.setLayout(new GridBagLayout());
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.helpLabel.setText("<html><ul><li>Set a non-zero value to enable a filter</li><li>A maximum of 100 results can be returned</li></ul></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.searchParametersPanel.add((Component)this.helpLabel, gridBagConstraints);
        this.searchLabel.setText("Cone Search");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.searchLabel, gridBagConstraints);
        this.raLabel.setText("RA");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.raLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.ra, gridBagConstraints);
        this.decLabel.setText("Dec");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.decLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.dec, gridBagConstraints);
        this.searchRadiusLabel.setText("Radius (\u00b0)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.searchRadiusLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.searchParametersPanel.add((Component)this.searchRadius, gridBagConstraints);
        this.fluxLabel.setText("Flux");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.fluxLabel, gridBagConstraints);
        this.minFluxLabel.setText("Min");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.minFluxLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.minFlux, gridBagConstraints);
        this.maxFluxLabel.setText("Max");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.maxFluxLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.searchParametersPanel.add((Component)this.maxFlux, gridBagConstraints);
        this.frequencyLabel.setText("Frequency");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.frequencyLabel, gridBagConstraints);
        this.minFrequencyLabel.setText("Min");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.minFrequencyLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.minFrequency, gridBagConstraints);
        this.maxFrequencyLabel.setText("Max");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.maxFrequencyLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.searchParametersPanel.add((Component)this.maxFrequency, gridBagConstraints);
        this.timeLabel.setText("Last Observed");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.timeLabel, gridBagConstraints);
        this.minTimeLabel.setText("Min");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.minTimeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.minTime, gridBagConstraints);
        this.maxTimeLabel.setText("Max");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.maxTimeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.searchParametersPanel.add((Component)this.maxTime, gridBagConstraints);
        this.maxSourcesLabel = new JLabel("Max Results");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 40, 0, 0);
        this.searchParametersPanel.add((Component)this.maxSourcesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.searchParametersPanel.add((Component)this.maxSources, gridBagConstraints);
        this.calibratorTagLabel.setName("QuerySourceEditor.calibratorTagLabel");
        this.cataloguePanel.setName("QuerySourceEditor.cataloguePanel");
        this.dec.setName("QuerySourceEditor.dec");
        this.decLabel.setName("QuerySourceEditor.decLabel");
        this.fluxLabel.setName("QuerySourceEditor.fluxLabel");
        this.frequencyLabel.setName("QuerySourceEditor.frequencyLabel");
        this.helpLabel.setName("QuerySourceEditor.helpLabel");
        this.maxFlux.setName("QuerySourceEditor.maxFlux");
        this.maxFluxLabel.setName("QuerySourceEditor.maxFluxLabel");
        this.maxFrequency.setName("QuerySourceEditor.maxFrequency");
        this.maxFrequencyLabel.setName("QuerySourceEditor.maxFrequencyLabel");
        this.maxSources.setName("QuerySourceEditor.maxSources");
        this.maxSourcesLabel.setName("QuerySourceEditor.maxSourcesLabel");
        this.maxTime.setName("QuerySourceEditor.maxTime");
        this.maxTimeLabel.setName("QuerySourceEditor.maxTimeLabel");
        this.minFlux.setName("QuerySourceEditor.minFlux");
        this.minFluxLabel.setName("QuerySourceEditor.minFluxLabel");
        this.minFrequency.setName("QuerySourceEditor.minFrequency");
        this.minFrequencyLabel.setName("QuerySourceEditor.minFrequencyLabel");
        this.minTime.setName("QuerySourceEditor.minTime");
        this.minTimeLabel.setName("QuerySourceEditor.minTimeLabel");
        this.ra.setName("QuerySourceEditor.ra");
        this.raLabel.setName("QuerySourceEditor.raLabel");
        this.searchLabel.setName("QuerySourceEditor.searchLabel");
        this.searchParametersPanel.setName("QuerySourceEditor.searchParametersPanel");
        this.searchRadius.setName("QuerySourceEditor.searchRadius");
        this.searchRadiusLabel.setName("QuerySourceEditor.searchRadiusLabel");
        this.timeLabel.setName("QuerySourceEditor.timeLabel");
        this.zeroLabel.setName("QuerySourceEditor.zeroLabel");
    }

    @Override
    protected void build() {
        super.build("QuerySourceEditor");
    }

    private CalibratorExpertModel getCalibratorExpertModel() {
        return (CalibratorExpertModel)this.getModel();
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        QuerySource querySource = QuerySource.createQuerySource();
        QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
        CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(querySourceAdapter);
        calibratorExpertModel.subscribe(new CalibratorExpertController());
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
            }
            QuerySourceEditor querySourceEditor = new QuerySourceEditor(calibratorExpertModel);
            JFrame jFrame = new JFrame("QuerySourceEditor");
            jFrame.setDefaultCloseOperation(3);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            jFrame.setLayout(gridBagLayout);
            jFrame.getContentPane().add((Component)querySourceEditor, gridBagConstraints);
            jFrame.pack();
            jFrame.setVisible(true);
        });
    }
}

