/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.investigator.PiSummaryEditor;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.help.CSH;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class ObsProjectEditor
extends EditorWithGridBagLayout {
    private static final long serialVersionUID = -7045406746502904798L;
    private final ObservingToolController otc;
    private Model piSummaryModel;
    private PiSummaryEditor piSummaryEditor;
    private JPanel advancedOptions = null;
    private JCheckBox commissioningModeCheckBox;
    private JCheckBox manualModeCheckBox;
    private JPanel projectNotes = null;

    public void setAdvancedOptionsVisible(boolean bl) {
        if (this.advancedOptions != null) {
            this.projectNotes.setVisible(bl);
            this.advancedOptions.setVisible(bl);
        }
    }

    public ObsProjectEditor(Model model, Model model2, ObservingToolController observingToolController) {
        this.setName("ObsProjectEditor");
        this.otc = observingToolController;
        this.setModel(model);
        this.piSummaryModel = model2;
        this.build();
        model.publish();
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (FieldIDs.projectStatusFID.equals(fieldID) && object instanceof String) {
            String string = (String)object;
            if (ObsProject.STATUS_NEWPHASE1.equals(string) || ObsProject.STATUS_PHASE1SUBMITTED.equals(string)) {
                this.setAdvancedCheckBoxesEnabled(false);
            } else {
                this.setAdvancedCheckBoxesEnabled(true);
            }
        }
        super.modelChanged(model, fieldID, object);
        this.piSummaryEditor.modelChanged(model, fieldID, object);
    }

    private void setAdvancedCheckBoxesEnabled(boolean bl) {
        this.commissioningModeCheckBox.setEnabled(bl);
        this.manualModeCheckBox.setEnabled(bl);
    }

    @Override
    protected void addComponents(String string) {
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        this.piSummaryEditor = new PiSummaryEditor(this.piSummaryModel, this.otc);
        this.registerSubView(this.piSummaryEditor);
        JComponent jComponent = this.addNonCollapsingGroup(this.piSummaryEditor, "Principal Investigator");
        CSH.setHelpIDString((Component)jComponent, (String)"TOC-The Phase 1 Proposal: Basic Details-Project Node-Principal Investigator");
        this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.projectNameFID, "Project", "The user-specifed name of this project");
        JTextField jTextField = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.assignedPriorityFID, "Assigned Priority", "The assigned priority for this " + string);
        this.setEnabled(jTextField, false);
        this.setVisible(jTextField, false);
        JTextField jTextField2 = this.addTextComponent(jPanel, gridBagLayout, gridBagConstraints, FieldIDs.codeFID, "Project Code", "A unique code for this project, assigned by the Observatory on first submission");
        this.setEnabled(jTextField2, false);
        JComponent jComponent2 = this.addNonCollapsingGroup(jPanel, "Main Project Information");
        CSH.setHelpIDString((Component)jComponent2, (String)"TOC-The Phase 1 Proposal: Basic Details-Project Node-Main Project Information");
        JPanel jPanel2 = this.createNewGroup();
        GridBagLayout gridBagLayout2 = this.createNewLayout(jPanel2);
        GridBagConstraints gridBagConstraints2 = this.createNewConstraints();
        this.addLabel(jPanel2, gridBagLayout2, gridBagConstraints2, "Staff Project Note");
        this.addOTTextArea(jPanel2, gridBagLayout2, gridBagConstraints2, FieldIDs.staffProjectNoteFID, 400, 200, "", "A brief note or comment about this " + string, true);
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints2);
        this.addLabel(jPanel2, gridBagLayout2, gridBagConstraints2, "Technical Assessor's Phase 2 Comments");
        JTextArea jTextArea = this.addJTextArea(jPanel2, gridBagLayout2, gridBagConstraints2, FieldIDs.taPhase2CommentsFID, 400, 200, "", "Technical Assessor's Phase 2 Comments");
        jTextArea.setEditable(false);
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints2);
        this.addLabel(jPanel2, gridBagLayout2, gridBagConstraints2, "Technical Assessor's Main Comments");
        jTextArea = this.addJTextArea(jPanel2, gridBagLayout2, gridBagConstraints2, FieldIDs.taMainCommentsFID, 400, 200, "", "Technical Assessor's Main Comments");
        jTextArea.setEditable(false);
        this.addVerticalSpace(jPanel2, gridBagLayout2, gridBagConstraints2);
        this.addLabel(jPanel2, gridBagLayout2, gridBagConstraints2, "Consensus Report");
        jTextArea = this.addJTextArea(jPanel2, gridBagLayout2, gridBagConstraints2, FieldIDs.consensusReportFID, 400, 200, "", "Consensus Report");
        jTextArea.setEditable(false);
        this.projectNotes = this.addGroup(jPanel2, "Project Notes (Staff Only)", true);
        CSH.setHelpIDString((Component)this.projectNotes, (String)"TOC-The Phase 1 Proposal: Basic Details-Project Node-Project Notes");
        JPanel jPanel3 = this.createNewGroup();
        GridBagLayout gridBagLayout3 = this.createNewLayout(jPanel3);
        GridBagConstraints gridBagConstraints3 = this.createNewConstraints();
        this.addTextComponent(jPanel3, gridBagLayout3, gridBagConstraints3, FieldIDs.versionFID, "Version", "The version of the project (for tracking by the investigators)");
        this.manualModeCheckBox = this.addBooleanComponent(jPanel3, gridBagLayout3, gridBagConstraints3, FieldIDs.manualModeFID, "Manual Mode", "<html>Are all the SBs in this project to be run as Manual Mode SBs?<br>This is for use by observatory staff only.</html>");
        this.addBooleanComponent(jPanel3, gridBagLayout3, gridBagConstraints3, FieldIDs.simModeFID, "Simulation Mode", "<html>This project is a Simulation Mode project - it will not get executed<br>This is for use by observatory staff only.</html>");
        this.addBooleanComponent(jPanel3, gridBagLayout3, gridBagConstraints3, FieldIDs.isCalibrationFID, "Calibration Mode", "<html>This project is a Calibration Mode project.<br>This is for use by observatory staff only.</html>");
        this.commissioningModeCheckBox = this.addBooleanComponent(jPanel3, gridBagLayout3, gridBagConstraints3, FieldIDs.isCommissioningFID, "Commissioning Mode", "<html>This project is a Commissioning Mode project.<br>This is for use by observatory staff only.</html>");
        String[] stringArray = new String[]{"Submission Time", "Submitter"};
        Table table = this.addTable(jPanel3, gridBagLayout3, gridBagConstraints3, FieldIDs.submissionRecordFID, "Submission Record", "The history of submissions of this project", false, stringArray);
        int n = 25;
        int n2 = 5;
        FontMetrics fontMetrics = table.getFontMetrics(table.getFont());
        Dimension dimension = new Dimension(n * fontMetrics.charWidth('m'), n2 * fontMetrics.getHeight());
        table.setPreferredScrollableViewportSize(dimension);
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(table.getModel());
        tableRowSorter.setSortsOnUpdates(true);
        table.setRowSorter(tableRowSorter);
        this.advancedOptions = this.addGroup(jPanel3, "Advanced Options (Staff Only)", true);
        CSH.setHelpIDString((Component)this.advancedOptions, (String)"TOC-The Phase 1 Proposal: Basic Details-Project Node-Advanced Options");
    }

    @Override
    protected void build() {
        super.build("Project");
    }

    @Override
    protected boolean wantGlobalButtons() {
        return false;
    }
}

