/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class CalibratorTableElement {
    public static final Map<Integer, String> CALIBRATOR_TYPES = new HashMap<Integer, String>();
    private final String intent;
    private final String type;
    private final String sourceName;
    private String ra;
    private String dec;
    private final IQuerySource query;
    private final CalibrationTargetParameters target;

    public CalibratorTableElement(IQuerySource iQuerySource) {
        if (iQuerySource == null) {
            throw new IllegalArgumentException("Cannot instantiate table element from null");
        }
        this.query = iQuerySource;
        this.target = null;
        this.intent = iQuerySource.getIntendedUse();
        this.type = "Dynamic Calibrator";
        this.sourceName = "";
        SkyCoordinates skyCoordinates = iQuerySource.getQueryCenter().getICRSSkyCoordinates();
        double d = iQuerySource.getSearchRadius().getContentInUnits(Angle.UNIT_DEG);
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        try {
            this.ra = skyCoordinates.getLongitude().toHHMMSS() + " \u00b1 " + decimalFormat.format(d) + "\u00b0";
        }
        catch (Exception exception) {
            this.ra = "N/A";
        }
        try {
            this.dec = skyCoordinates.getLatitude().toDDMMSS() + " \u00b1 " + decimalFormat.format(d) + "\u00b0";
        }
        catch (Exception exception) {
            this.dec = "N/A";
        }
    }

    public CalibratorTableElement(CalibrationTargetParameters calibrationTargetParameters) {
        if (calibrationTargetParameters == null) {
            throw new IllegalArgumentException("Cannot instantiate table element from null");
        }
        this.target = calibrationTargetParameters;
        this.query = null;
        this.intent = calibrationTargetParameters.getIntendedUse();
        this.type = "Fixed Target";
        if (calibrationTargetParameters.getNonSiderealMotion()) {
            this.sourceName = calibrationTargetParameters.getSolarSystemObject();
            this.ra = "N/A";
            this.dec = "N/A";
        } else {
            this.sourceName = calibrationTargetParameters.getSourceName();
            SkyCoordinates skyCoordinates = calibrationTargetParameters.getSourceCoordinates().getICRSSkyCoordinates();
            try {
                this.ra = skyCoordinates.getLongitude().toHHMMSS();
            }
            catch (Exception exception) {
                this.ra = "N/A";
            }
            try {
                this.dec = skyCoordinates.getLatitude().toDDMMSS();
            }
            catch (Exception exception) {
                this.dec = "N/A";
            }
        }
    }

    public String getIntent() {
        return this.intent;
    }

    public String getType() {
        return this.type;
    }

    public String getRA() {
        return this.ra;
    }

    public String getDec() {
        return this.dec;
    }

    public String getName() {
        return this.sourceName;
    }

    public IQuerySource getQuerySource() {
        return this.query;
    }

    public CalibrationTargetParameters getCalibrationTargetParameters() {
        return this.target;
    }

    static {
        int n = 0;
        for (String string : QuerySource.getKnownIntendedUseList()) {
            CALIBRATOR_TYPES.put(n++, string);
        }
    }
}

