/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.ot.editors.misc.SummaryTableRowsLoader;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Time;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class TimingConstraintsTableLoader
extends SummaryTableRowsLoader {
    private static final AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
    private static final int DEFAULT_TIME_MARGIN = (int)(almaPolicies.getMinAdvisedTimeMargin().getContentInUnits(Time.UNIT_D) / 2.0);
    protected static final int EXPECTED_COLS = ColumnIndexEnumeration.values().length;

    private static final ZonedDateTime parseDates(String string) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        DateTimeFormatter dateTimeFormatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
        if (string.length() == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
            LocalDateTime localDateTime = LocalDateTime.parse(string, dateTimeFormatter);
            ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneOffset.UTC);
            return zonedDateTime;
        }
        LocalDateTime localDateTime = LocalDateTime.parse(string, dateTimeFormatter2);
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneOffset.UTC);
        return zonedDateTime;
    }

    @Override
    public void parse(String[] stringArray, StringBuffer stringBuffer) {
        if (stringArray.length < EXPECTED_COLS) {
            GUIUtilities.error(null, "<html>Input file format is invalid.<br><br>Please ensure each line in your file contains comma-separated values with column order:<ol><li>Start Date</li><li>End Date</li></ol><br><i>The dates should be in the format YYYY-MM-DDThh:mm:ss eg.</i>2014-10-01T12:22:14, 2014-11-01T14:06:14 </html>");
            throw new IllegalArgumentException();
        }
        ZonedDateTime zonedDateTime = null;
        ZonedDateTime zonedDateTime2 = null;
        TemporalParameters temporalParameters = TemporalParameters.createTemporalParameters();
        try {
            zonedDateTime = TimingConstraintsTableLoader.parseDates(stringArray[ColumnIndexEnumeration.COL_STARTDATE.getColumnIndex()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUIUtilities.error(null, "Unable to determine start date: " + stringArray[ColumnIndexEnumeration.COL_STARTDATE.getColumnIndex()]);
            throw new IllegalArgumentException(illegalArgumentException);
        }
        catch (DateTimeParseException dateTimeParseException) {
            GUIUtilities.error(null, "Unable to parse start date: " + stringArray[ColumnIndexEnumeration.COL_STARTDATE.getColumnIndex()]);
            throw new IllegalArgumentException(dateTimeParseException);
        }
        try {
            zonedDateTime2 = TimingConstraintsTableLoader.parseDates(stringArray[ColumnIndexEnumeration.COL_ENDDATE.getColumnIndex()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUIUtilities.error(null, "Unable to determine end date: " + stringArray[ColumnIndexEnumeration.COL_ENDDATE.getColumnIndex()]);
            throw new IllegalArgumentException(illegalArgumentException);
        }
        catch (DateTimeParseException dateTimeParseException) {
            GUIUtilities.error(null, "Unable to parse end date: " + stringArray[ColumnIndexEnumeration.COL_ENDDATE.getColumnIndex()]);
            throw new IllegalArgumentException(dateTimeParseException);
        }
        temporalParameters.setStartTimeInDate(zonedDateTime);
        temporalParameters.setEndTimeInDate(zonedDateTime2);
        temporalParameters.setAllowedMargin(Time.createTime((double)DEFAULT_TIME_MARGIN, (String)Time.UNIT_D));
        this.add(temporalParameters);
    }

    public static enum ColumnIndexEnumeration {
        COL_STARTDATE(0),
        COL_ENDDATE(1);

        private int columnIndex;

        public int getColumnIndex() {
            return this.columnIndex;
        }

        private ColumnIndexEnumeration(int n2) {
            this.columnIndex = n2;
        }

        public static ColumnIndexEnumeration findColumnIndex(int n) {
            for (ColumnIndexEnumeration columnIndexEnumeration : ColumnIndexEnumeration.values()) {
                if (n != columnIndexEnumeration.getColumnIndex()) continue;
                return columnIndexEnumeration;
            }
            throw new IllegalArgumentException("Unable to find index in the enumeration: " + n);
        }
    }
}

