/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.misc;

import alma.obsprep.bo.obsproject.ExpectedProperties;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.ot.editors.misc.SummaryTableRowsLoader;
import alma.obsprep.util.Convert;
import alma.obsprep.util.Convert4dp;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Flux;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FieldSetupSummaryTableLoader
extends SummaryTableRowsLoader {
    protected static final int COL_SOURCENAME = 0;
    protected static final int COL_LONG = 1;
    protected static final int COL_LAT = 2;
    protected static final int COL_PMRA = 3;
    protected static final int COL_PMDEC = 4;
    protected static final int COL_VELOCITY = 5;
    protected static final int COL_VELREFERENCE = 6;
    protected static final int COL_VELDOPPLERTYPE = 7;
    protected static final int COL_PEAKCONTINUUMFLUX = 8;
    protected static final int COL_PEAKLINEFLUX = 9;
    protected static final int COL_POLARIZATION = 10;
    protected static final int COL_LINEPOLARIZATION = 11;
    protected static final int COL_LINEWIDTH = 12;
    protected static final int COL_CONT_CIRCULAR_POLARIZATION = 13;
    protected static final int COL_LINE_CIRCULAR_POLARIZATION = 14;
    protected static final int EXPECTED_COLS = 15;

    @Override
    public void parse(String[] stringArray, StringBuffer stringBuffer) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        String string = stringArray[0];
        if (stringArray.length < 15) {
            GUIUtilities.error(null, "<html>Input file format for source '" + string + "'  is invalid.<br><br>Please ensure each line in your file contains comma-separated values with column order:<ol><li>Source Name</li><li>RA (sexagesimal)|Galactic Longitude (degrees)</li><li>Dec (sexagesimal)|Galactic Latitude (degrees)</li><li>Proper motion RA (mas/yr)</li><li>Proper motion Dec (mas/yr)</li><li>Velocity (km/s)</li><li>Velocity reference frame</li><li>Velocity Doppler Type</li><li>Peak continuum flux density (mJy)</li><li>Peak line flux density (mJy)</li><li>Expected continuum polarization (%)</li><li>Expected line polarization (%)</li><li>Expected linewidth (km/s)</li><li>Expected continuum circular polarization (%)</li><li>Expected line circular polarization (%)</li></ol><br><i>eg.</i> m31, 00:42:44.311, 41:16:09.408, 0, 0.0, 3330000, lsrk, RADIO, 400, 1000, 50, 80, 30, 4, 3</html>");
            throw new IllegalArgumentException();
        }
        TargetParameters targetParameters = TargetParameters.createTargetParameters();
        targetParameters.setSourceName(string);
        SkyCoordinates skyCoordinates = SkyCoordinates.createSkyCoordinates(SkyCoordinates.TYPE_ABSOLUTE);
        Longitude longitude = Longitude.createLongitude();
        boolean bl = false;
        try {
            double d11 = Double.valueOf(stringArray[1]);
            if (d11 >= 360.0 || d11 < 0.0) {
                d11 = 0.0;
                GUIUtilities.warning(null, "Source " + string + ": Error parsing longitude, set to 0.0");
            }
            longitude.setContentInDeg(d11);
            skyCoordinates.setSystem(SkyCoordinates.SYSTEM_GALACTIC);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!bl) {
            skyCoordinates.setSystem(SkyCoordinates.SYSTEM_ICRS);
            try {
                longitude.setContentInDeg(Convert4dp.HHMMSSToDeg(stringArray[1]));
            }
            catch (InvalidCoordException | NumberFormatException exception) {
                GUIUtilities.warning(null, "Source " + string + ": Error parsing RA, set to 0.0");
                longitude.setContentInDeg(0.0);
            }
        }
        skyCoordinates.setLongitude(longitude);
        Latitude latitude = Latitude.createLatitude();
        if (bl) {
            try {
                double d12 = Double.valueOf(stringArray[2]);
                if (d12 <= -90.0 || d12 >= 90.0) {
                    d12 = 0.0;
                    GUIUtilities.warning(null, "Source " + string + ": Error parsing latitude, set to 0.0");
                }
                latitude.setContentInDeg(d12);
            }
            catch (NumberFormatException numberFormatException) {
                GUIUtilities.warning(null, "Source " + string + ": Error parsing latitude, set to 0.0");
                latitude.setContentInDeg(0.0);
            }
        } else {
            try {
                latitude.setContentInDeg(Convert.DDMMSSToDeg(stringArray[2]));
            }
            catch (InvalidCoordException | NumberFormatException exception) {
                GUIUtilities.warning(null, "Source " + string + ": Error parsing Dec, set to 0.0");
                latitude.setContentInDeg(0.0);
            }
        }
        skyCoordinates.setLatitude(latitude);
        targetParameters.setSourceCoordinates(skyCoordinates);
        try {
            d10 = Double.parseDouble(stringArray[3]);
            if (d10 < -1.295999985E9 || d10 >= 1.295999985E9) {
                GUIUtilities.warning(null, "Source " + string + ": Error PM RA was not between -360 and 360 degrees, set to 0.0");
                d10 = 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            GUIUtilities.warning(null, "Source " + string + ": Error parsing PM RA, set to 0.0");
            d10 = 0.0;
        }
        targetParameters.setPmRA(AngularVelocity.createAngularVelocity((double)d10, (String)AngularVelocity.UNIT_MAS_YR));
        try {
            d9 = Double.parseDouble(stringArray[4]);
            if (d9 < -3.24E8 || d9 > 3.24E8) {
                GUIUtilities.warning(null, "Source " + string + ": Error PM Dec was not between -90 and +90 degrees, set to 0.0");
                d9 = 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            GUIUtilities.warning(null, "Source " + string + ": Error parsing PM Dec, set to 0.0");
            d9 = 0.0;
        }
        targetParameters.setPmDec(AngularVelocity.createAngularVelocity((double)d9, (String)AngularVelocity.UNIT_MAS_YR));
        try {
            d8 = Double.parseDouble(stringArray[5]);
        }
        catch (NumberFormatException numberFormatException) {
            GUIUtilities.warning(null, "Source " + string + ": Error parsing source velocity, set to 0.0");
            d8 = 0.0;
        }
        Velocity velocity = Velocity.createVelocity();
        velocity.setCenterVelocity(Speed.createSpeed((double)d8, (String)Speed.UNIT_KM_S));
        targetParameters.setSourceVelocity(velocity);
        String string2 = stringArray[6];
        String[] stringArray2 = Velocity.getKnownReferenceSystemList();
        List<String> list = Arrays.asList(stringArray2);
        ArrayList<String> arrayList = new ArrayList<String>(list);
        if (!string2.isEmpty() && arrayList.contains(string2)) {
            velocity.setReferenceSystem(string2);
        } else {
            GUIUtilities.warning(null, "Source " + string + ": Error velocity reference frame " + string2 + " not found in allowed types, setting to lsrk.\n Allowed types are " + ((Object)arrayList).toString());
            velocity.setReferenceSystem(Velocity.REFERENCESYSTEM_LSRK);
        }
        try {
            d7 = Double.parseDouble(stringArray[8]);
            if (d7 < 0.0) {
                GUIUtilities.warning(null, "Source " + string + ": Error peak continuum flux density cannot be negative, set to 0.0");
                d7 = 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            GUIUtilities.warning(null, "Source " + string + ": Error parsing peak continuum flux density, set to 0.0");
            d7 = 0.0;
        }
        Flux flux = Flux.createFlux((double)d7, (String)Flux.UNIT_MJY);
        ExpectedProperties expectedProperties = targetParameters.getExpectedProperties();
        expectedProperties.setExpectedPeakFluxDensity(flux);
        try {
            d6 = Double.parseDouble(stringArray[9]);
            if (d6 < 0.0) {
                GUIUtilities.warning(null, "Source " + string + ": Error peak line flux density cannot be negative, set to 0.0");
                d6 = 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            GUIUtilities.warning(null, "Source " + string + ": Error parsing peak line flux density, set to 0.0");
            d6 = 0.0;
        }
        Flux flux2 = Flux.createFlux((double)d6, (String)Flux.UNIT_MJY);
        expectedProperties.setExpectedPeakLineFluxDensity(flux2);
        try {
            d5 = Double.parseDouble(stringArray[12]);
            if (d5 < 0.0) {
                GUIUtilities.warning(null, "Source " + string + ": Error line width cannot be negative, set to 0.0");
                d5 = 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            GUIUtilities.warning(null, "Source " + string + ": Error parsing line width, set to 0.0");
            d5 = 0.0;
        }
        UserFrequency userFrequency = UserFrequency.createUserFrequency(d5, UserFrequency.UNIT_KHZ);
        userFrequency.setUserUnit(UserFrequency.USERUNIT_KM_S);
        userFrequency.setContentAndUnit(d5, UserFrequency.USERUNIT_KM_S);
        expectedProperties.setExpectedLineWidth(userFrequency);
        try {
            d4 = Double.parseDouble(stringArray[10]);
            if (d4 < 0.0 || d4 > 100.0) {
                GUIUtilities.warning(null, "Source " + string + ": Error Continuum Polarization was not between 0 and 100, set to 0.0");
                d4 = 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            GUIUtilities.warning(null, "Source " + string + ": Error parsing continuum polariation percentage, set to 0.0");
            d4 = 0.0;
        }
        expectedProperties.setDesiredPolarizationPercentage(d4);
        try {
            d3 = Double.parseDouble(stringArray[11]);
            if (d3 < 0.0 || d3 > 100.0) {
                GUIUtilities.warning(null, "Source " + string + ": Error Line Polarization was not between 0 and 100, set to 0.0");
                d3 = 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            GUIUtilities.warning(null, "Source " + string + ": Error parsing line polariation percentage, set to 0.0");
            d3 = 0.0;
        }
        expectedProperties.setDesiredLinePolarizationPercentage(d3);
        try {
            targetParameters.getSourceVelocity().setDopplerCalcType(stringArray[7].toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GUIUtilities.warning(null, "Source " + string + ": error parsing Doppler type, defaulting to optical");
            targetParameters.getSourceVelocity().setDopplerCalcType(Velocity.DOPPLERCALCTYPE_OPTICAL);
        }
        try {
            d2 = Double.parseDouble(stringArray[13]);
            if (d2 < 0.0 || d2 > 100.0) {
                GUIUtilities.warning(null, "Source " + string + ": Error continuum circular polarization was not between 0 and 100, set to 0.0");
                d2 = 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            GUIUtilities.warning(null, "Source " + string + ": Error parsing continuum circular polarization, set to 0.0");
            d2 = 0.0;
        }
        expectedProperties.setDesiredCircularPolarizationPercentage(d2);
        try {
            d = Double.parseDouble(stringArray[14]);
            if (d < 0.0 || d > 100.0) {
                GUIUtilities.warning(null, "Source " + string + ": Error line circular polarization was not between 0 and 100, set to 0.0");
                d = 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            GUIUtilities.warning(null, "Source " + string + ": Error parsing line circular polarization, set to 0.0");
            d = 0.0;
        }
        expectedProperties.setDesiredLineCircularPolarizationPercentage(d);
        this.add(targetParameters);
    }
}

