/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.investigator;

import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.widgets.IndeterminateProgressMonitor;
import alma.obsprep.ot.editors.investigator.InvestigatorSearchTableModel;
import alma.obsprep.ot.editors.investigator.tasks.UserLookupTask;
import alma.obsprep.ot.editors.investigator.verifiers.EmailVerifier;
import alma.obsprep.ot.editors.investigator.verifiers.MinLengthVerifier;
import alma.obsprep.ot.editors.investigator.verifiers.TextFieldVerifier;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.services.userlookup.User;
import alma.obsprep.services.userlookup.UserLookupRemote;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InvestigatorSearchDialog
extends GuiFactory.Dialog
implements PropertyChangeListener,
ListSelectionListener {
    public static InvestigatorSearchDialog dialog;
    private static final List<Investigator> investigatorsSelected;
    private UserLookupTask task;
    private InvestigatorSearchTableModel tableModel = new InvestigatorSearchTableModel();
    private final String selectLabel;
    private static final String CANCEL = "Cancel";
    private TextFieldVerifier verifier;
    private IndeterminateProgressMonitor progressMonitor;
    private TYPE type;
    private JComboBox attributeComboBox;
    private JButton cancelButton;
    private JLabel constraintLabel;
    private JPanel constraintsPanel;
    private JTextField queryTextField;
    private JScrollPane resultsScrollPane;
    private JTable resultsTable;
    private JButton searchButton;
    private JButton selectButton;

    private InvestigatorSearchDialog(boolean bl, String string) {
        this.setModal(true);
        this.selectLabel = string;
        this.initComponents();
        this.setName("InvestigatorSearch");
        this.resultsScrollPane.setName("InvestigatorSearch.resultsScrollPane");
        this.resultsTable.setName("InvestigatorSearch.resultsTable");
        this.cancelButton.setName("InvestigatorSearch.cancelButton");
        this.selectButton.setName("InvestigatorSearch.selectButton");
        this.constraintsPanel.setName("InvestigatorSearch.constraintsPanel");
        this.searchButton.setName("InvestigatorSearch.searchButton");
        this.constraintLabel.setName("InvestigatorSearch.constraintLabel");
        this.queryTextField.setName("InvestigatorSearch.queryTextField");
        this.attributeComboBox.setName("InvestigatorSearch.attributeComboBox");
        this.resultsTable.getTableHeader().setReorderingAllowed(false);
        if (bl) {
            this.resultsTable.setSelectionMode(0);
        } else {
            this.resultsTable.setSelectionMode(2);
        }
        this.getRootPane().setDefaultButton(this.searchButton);
        this.verifier = new MinLengthVerifier(this.queryTextField, 3);
        this.type = TYPE.NAME;
        this.queryTextField.addKeyListener(new VerifierListener());
        this.resultsTable.getSelectionModel().addListSelectionListener(this);
        this.setButtons();
        this.setSearchEnabled(true);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.rescaleToMonitor(0.5);
        }
        super.setVisible(bl);
    }

    public static List<Investigator> showDialog(boolean bl) {
        dialog = new InvestigatorSearchDialog(bl, "Select");
        dialog.setVisible(true);
        return investigatorsSelected;
    }

    public static List<Investigator> showDialog(boolean bl, String string) {
        dialog = new InvestigatorSearchDialog(bl, string);
        dialog.setVisible(true);
        return investigatorsSelected;
    }

    public void setUsers(List<User> list) {
        this.tableModel.setUsers(list);
        this.resultsTable.invalidate();
        int n = list.size();
        int n2 = this.queryTextField.getText().split(",").length;
        if (n == n2) {
            this.resultsTable.getSelectionModel().setSelectionInterval(0, n - 1);
        }
        this.setSearchEnabled(true);
    }

    private void setSearchEnabled(boolean bl) {
        this.setButtonEnabled(bl && this.verifier.isValid());
    }

    private void setButtonEnabled(boolean bl) {
        this.searchButton.setEnabled(bl);
        if (!bl) {
            this.searchButton.setToolTipText(this.verifier.getInvalidTooltip());
        } else {
            this.searchButton.setToolTipText("Click to search for matching investigators");
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtons();
    }

    private void setButtons() {
        int[] nArray = this.resultsTable.getSelectedRows();
        if (nArray.length == 0) {
            this.selectButton.setEnabled(false);
        } else {
            this.selectButton.setEnabled(true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("IPM_CANCELLED")) {
            if (this.task != null) {
                this.task.cancel(true);
            }
            this.setSearchEnabled(true);
        }
    }

    public IndeterminateProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    private void initComponents() {
        this.resultsScrollPane = new ScrollWhenFocusedPane();
        this.resultsTable = new JTable();
        this.cancelButton = new JButton();
        this.selectButton = new JButton();
        this.constraintsPanel = new JPanel();
        this.searchButton = new JButton();
        this.constraintLabel = new JLabel();
        this.queryTextField = new JTextField();
        this.attributeComboBox = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.resultsTable.setModel(this.tableModel);
        this.resultsTable.setToolTipText("Attribute to match");
        this.resultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                InvestigatorSearchDialog.this.resultsTableMouseClicked(mouseEvent);
            }
        });
        this.resultsScrollPane.setViewportView(this.resultsTable);
        this.cancelButton.setText(CANCEL);
        this.cancelButton.setActionCommand(CANCEL);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestigatorSearchDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.selectButton.setText(this.selectLabel);
        this.selectButton.setActionCommand(this.selectLabel);
        this.selectButton.setEnabled(false);
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestigatorSearchDialog.this.selectButtonActionPerformed(actionEvent);
            }
        });
        this.constraintsPanel.setBorder(BorderFactory.createTitledBorder("Investigator search constraints"));
        this.searchButton.setText("Find Investigators");
        this.searchButton.setEnabled(false);
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InvestigatorSearchDialog.this.searchButtonActionPerformed(actionEvent);
            }
        });
        this.constraintLabel.setText("contains");
        this.attributeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Name", "Email", "ALMA ID"}));
        this.attributeComboBox.setToolTipText("Attribute to match");
        this.attributeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                InvestigatorSearchDialog.this.attributeComboBoxItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.constraintsPanel);
        this.constraintsPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.attributeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.constraintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.queryTextField, -1, 296, Short.MAX_VALUE)).addComponent(this.searchButton, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.queryTextField, -2, -1, -2).addComponent(this.attributeComboBox, -2, -1, -2).addComponent(this.constraintLabel)).addGap(18, 18, 18).addComponent(this.searchButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.resultsScrollPane, GroupLayout.Alignment.LEADING, -1, 484, Short.MAX_VALUE).addComponent(this.constraintsPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addComponent(this.selectButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.constraintsPanel, -2, -1, -2).addGap(9, 9, 9).addComponent(this.resultsScrollPane, -1, 129, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.selectButton)).addContainerGap()));
        this.pack();
    }

    private void attributeComboBoxItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            String string = (String)itemEvent.getItem();
            if (string.equals("Email")) {
                this.constraintLabel.setText("is");
                this.queryTextField.setToolTipText("Email address to match");
                this.verifier = new EmailVerifier(this.queryTextField);
                this.type = TYPE.EMAIL;
                this.setSearchEnabled(true);
            }
            if (string.equals("Name")) {
                this.constraintLabel.setText("contains");
                this.queryTextField.setToolTipText("Name substring to match");
                this.verifier = new MinLengthVerifier(this.queryTextField, 3);
                this.type = TYPE.NAME;
                this.setSearchEnabled(true);
            }
            if (string.equals("ALMA ID")) {
                this.constraintLabel.setText("is");
                this.queryTextField.setToolTipText("ALMA ID to match");
                this.verifier = new MinLengthVerifier(this.queryTextField, 3);
                this.type = TYPE.UID;
                this.setSearchEnabled(true);
            }
        }
    }

    private void resultsTableMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.selectButton.doClick();
        }
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        this.setButtonEnabled(false);
        this.progressMonitor = new IndeterminateProgressMonitor(this, "Searching User Repository", "", Dialog.ModalityType.DOCUMENT_MODAL);
        this.progressMonitor.addPropertyChangeListener(this);
        String string = this.queryTextField.getText();
        String[] stringArray = string.split(",");
        this.task = new UserLookupTask(this, this.type, stringArray);
        this.task.addPropertyChangeListener(this.progressMonitor);
        this.task.execute();
    }

    private void selectButtonActionPerformed(ActionEvent actionEvent) {
        investigatorsSelected.clear();
        for (int n : this.resultsTable.getSelectedRows()) {
            User user = this.tableModel.getUserAt(n);
            Investigator investigator = Investigator.createInvestigator(user);
            investigator.setVerfiedUser(true);
            investigatorsSelected.add(investigator);
        }
        dialog.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        investigatorsSelected.clear();
        dialog.dispose();
    }

    public static void main(String[] stringArray) throws Exception {
        InitServices.initModelSupportClasses();
        ObservingToolController observingToolController = new ObservingToolController();
        UserLookupRemote userLookupRemote = new UserLookupRemote();
        userLookupRemote.setUrl("http://192.168.56.101:8180");
        observingToolController.heap.setUserLookup(userLookupRemote);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<Investigator> list = InvestigatorSearchDialog.showDialog(true);
                for (Investigator investigator : list) {
                    System.out.println("Selected " + investigator.getFullName());
                }
            }
        });
    }

    static {
        investigatorsSelected = new ArrayList<Investigator>();
    }

    class VerifierListener
    implements KeyListener {
        VerifierListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (InvestigatorSearchDialog.this.verifier.isValid()) {
                InvestigatorSearchDialog.this.setSearchEnabled(true);
            } else {
                InvestigatorSearchDialog.this.setSearchEnabled(false);
            }
        }
    }

    public static enum TYPE {
        EMAIL,
        NAME,
        UID;

    }
}

