/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.PhaseISciencePlanCollection;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.SummaryFeedbackInteractor;
import alma.obsprep.ot.actions.SummaryFeedbackPerformer;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.summaryfeedback.FeedbackSummary;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryObsProject;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryObsProposal;
import alma.obsprep.services.summaryfeedback.FeedbackSummaryScienceGoal;
import alma.obsprep.services.summaryfeedback.FeedbackSummarySgCollection;
import alma.obsprep.services.summaryfeedback.ObsProposalScienceGoalNavigator;
import alma.obsprep.services.summaryfeedback.SummaryFrame;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Status;
import org.apache.commons.lang3.StringUtils;

public class SummaryFeedbackAction
extends OTAction
implements SummaryFeedbackInteractor,
EventReceiver {
    protected BusinessObject m_selectedBO = null;
    protected ProjectTreeNode m_selectedNode = null;
    private AbstractScienceGoal params;

    public SummaryFeedbackAction() {
        SummaryFeedbackPerformer summaryFeedbackPerformer = new SummaryFeedbackPerformer(this);
        this.setPerformer(summaryFeedbackPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
    }

    @Override
    public void show() {
        Object object;
        FeedbackSummary feedbackSummary = null;
        boolean bl = false;
        if (this.m_selectedBO instanceof ScienceGoal) {
            object = (ScienceGoal)this.m_selectedBO;
            try {
                feedbackSummary = new FeedbackSummaryScienceGoal((ScienceGoal)object);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                GUIUtilities.warning(null, "Unable to run clustering algorithm : " + invalidObsProgramParametersException.getMessage());
                return;
            }
            bl = true;
        } else if (this.m_selectedBO instanceof ObsProject) {
            object = (ObsProject)this.m_selectedBO;
            try {
                feedbackSummary = new FeedbackSummaryObsProject((ObsProject)object);
            }
            catch (WizardSBGenerationException wizardSBGenerationException) {
                GUIUtilities.warning(null, "Unable to generate summary : " + StringUtils.substringAfter((String)wizardSBGenerationException.getMessage(), (String)":"));
            }
            bl = true;
        } else if (this.m_selectedBO instanceof ObsProposal) {
            object = (ObsProposal)this.m_selectedBO;
            feedbackSummary = new FeedbackSummaryObsProposal((ObsProposal)((Object)object));
        } else if (this.m_selectedBO instanceof PhaseISciencePlanCollection) {
            object = ((PhaseISciencePlanCollection)this.m_selectedBO).getObsProposal();
            if (object.getAbstractScienceGoalCount() == 0) {
                GUIUtilities.warning(null, "No ScienceGoal");
                return;
            }
            ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator = new ObsProposalScienceGoalNavigator((ObsProposal)((Object)object), true);
            feedbackSummary = new FeedbackSummarySgCollection((ObsProposal)((Object)object), obsProposalScienceGoalNavigator);
            bl = true;
        } else {
            throw new IllegalArgumentException("Unexpected BusinessObject : " + this.m_selectedBO.getClass());
        }
        object = new SummaryFrame(feedbackSummary);
        ((SummaryFrame)object).setShowsNavButtons(bl);
        ((SummaryFrame)object).showPanel();
    }

    private void setNameFor(BusinessObject businessObject) {
        String string;
        if (businessObject instanceof ObsProject && this.isPhaseIProject()) {
            string = "Show Printable Summary of Proposal and Science Goals";
        } else if (businessObject instanceof ScienceGoal && this.isPhaseIScienceGoal()) {
            string = "Show Printable Summary of ScienceGoal";
        } else if (businessObject instanceof ObsProposal && this.isPhaseIProject()) {
            string = "Show Printable Summary of Proposal";
        } else if (businessObject instanceof PhaseISciencePlanCollection) {
            string = "Show Printable Summary of all Science Goals";
        } else {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.setEnabled(true);
        this.putValue("Name", string);
    }

    private boolean isPhaseIProject() {
        if (this.m_selectedBO instanceof ObsProject) {
            ObsProject obsProject = (ObsProject)this.m_selectedBO;
            if (obsProject.getStatus() == Status.STATE_NEWPHASE1 || obsProject.getStatus() == Status.STATE_PHASE1SUBMITTED) {
                return true;
            }
        } else if (this.m_selectedBO instanceof ObsProposal) {
            try {
                ObsProject obsProject = ((ObsProposal)this.m_selectedBO).getObsProject();
                if (obsProject.getStatus() == Status.STATE_NEWPHASE1 || obsProject.getStatus() == Status.STATE_PHASE1SUBMITTED) {
                    return true;
                }
            }
            catch (UnknownEntityException unknownEntityException) {
                unknownEntityException.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private boolean isPhaseIScienceGoal() {
        return this.m_selectedBO.getParent() instanceof ObsProposal;
    }

    @Override
    public void receiveEvent(Event event) {
        this.m_selectedNode = (ProjectTreeNode)event.getSource();
        this.m_selectedBO = (BusinessObject)this.m_selectedNode.getUserObject();
        this.setNameFor(this.m_selectedBO);
    }
}

