/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.SearchProjectTreeInteractor;
import alma.obsprep.ot.actions.SearchProjectTreePerformer;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.util.GUIUtilities;
import javax.swing.tree.TreeNode;
import lombok.NonNull;

public class SearchProjectTree
extends OTAction
implements SearchProjectTreeInteractor,
EventReceiver {
    private ProjectTree projectTree;
    private BusinessObject selectedTreeNodeBO = null;
    private SearchDirection searchDirection;
    private ProjectTreeNode selectedTreeNode;

    public SearchProjectTree(ProjectTree projectTree, @NonNull SearchDirection searchDirection) {
        if (searchDirection == null) {
            throw new NullPointerException("searchDirection is marked non-null but is null");
        }
        this.searchDirection = searchDirection;
        this.projectTree = projectTree;
        SearchProjectTreePerformer searchProjectTreePerformer = new SearchProjectTreePerformer(this);
        this.setPerformer(searchProjectTreePerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(true);
    }

    @Override
    public ProjectTreeNode getSelectedNode() {
        return this.selectedTreeNode;
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public BusinessObject getSelectedBO() {
        return this.selectedTreeNodeBO;
    }

    @Override
    public SearchDirection getSearchDirection() {
        return this.searchDirection;
    }

    @Override
    public void receiveEvent(Event event) {
        ProjectTreeNode projectTreeNode = this.projectTree.getTop();
        TreeNode treeNode = ((ProjectTreeNode)event.getSource()).getRoot();
        if (!treeNode.equals(projectTreeNode)) {
            return;
        }
        this.selectedTreeNode = (ProjectTreeNode)event.getSource();
        this.selectedTreeNodeBO = (BusinessObject)this.selectedTreeNode.getUserObject();
        this.setEnabled(true);
    }

    @Override
    public String getSearchString() {
        return this.projectTree.getSearchString();
    }

    public static enum SearchDirection {
        Down,
        Up;

    }
}

