/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.Interactor;
import alma.obsprep.ot.actions.PostRetrievalActionInterface;
import alma.obsprep.ot.actions.ProjectRepositoryPerformer;
import alma.obsprep.ot.actions.RetrieveInteractor;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.PersistenceException;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.services.generator.refactored.StaleSBDetector;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.MiscUtils;

public class RetrievePerformer
extends ProjectRepositoryPerformer {
    protected boolean isProjectDDT = false;
    protected boolean isSupplementalCallProposal = false;

    public RetrievePerformer(Interactor interactor, ProjectRepository projectRepository) {
        super(interactor, projectRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() {
        RetrieveInteractor retrieveInteractor = (RetrieveInteractor)this.getGui();
        if (!retrieveInteractor.confirmOverwrite()) {
            return;
        }
        String string = retrieveInteractor.getObsProjectId();
        if (string == null) {
            return;
        }
        ProjectRepository.RetrieveVariant retrieveVariant = retrieveInteractor.getRetrieveVariant();
        try {
            MiscUtils.resetJCSCache();
            retrieveInteractor.busy(true);
            ObsProject obsProject = this.projectRepository().retrieve(string, retrieveVariant);
            if (ObsProject.STATUS_APPROVED.equals(obsProject.getStatus()) && obsProject.getObsProgram().getAbstractScienceGoalCount() == 0 && retrieveInteractor.convertPhase1ToPhase2()) {
                this.copyScienceGoalsFromPhase1ToPhase2(obsProject);
            }
            if (ObsProject.STATUS_REJECTED.equals(obsProject.getStatus())) {
                retrieveInteractor.infoAboutRejected();
            }
            this.isProjectDDT = obsProject.getIsDDT();
            try {
                this.isSupplementalCallProposal = obsProject.getObsProposal().isSupplementalCallProposal();
            }
            catch (UnknownEntityException unknownEntityException) {
                this.isSupplementalCallProposal = false;
            }
            try {
                if (!this.postRetrieveProcessing(obsProject)) {
                    return;
                }
            }
            catch (PostRetrievalActionInterface.UnableToPerformPostRetrievalProcessingException unableToPerformPostRetrievalProcessingException) {
                retrieveInteractor.error(unableToPerformPostRetrievalProcessingException);
                return;
            }
            retrieveInteractor.display(obsProject);
            UserEditRestrictionController.getInstance().projectDocumentReset(obsProject, new ImpexFactory.WorkingPersistenceData());
            StaleSBDetector.getInstance().resetSBFreshnessMap(obsProject);
            ActionLog.performed("Open", obsProject, "from archive");
            if (!RoleDirectoryServiceHelper.isUserP2G() && RoleDirectoryServiceHelper.isContactScientist(obsProject)) {
                GUIUtilities.info(null, "Contact Scientists Cannot Edit Proposals", "Opening project in read-only mode - neither editing nor submission of the proposal will be possible");
            }
        }
        catch (PersistenceException persistenceException) {
            retrieveInteractor.error(persistenceException);
        }
        finally {
            retrieveInteractor.busy(false);
        }
    }

    private void copyScienceGoalsFromPhase1ToPhase2(ObsProject obsProject) {
        try {
            ObsProposal obsProposal = obsProject.getObsProposal();
            ObsProgram obsProgram = obsProject.getObsProgram();
            for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
                abstractScienceGoal.setObsUnitSet(null);
                obsProgram.addAbstractScienceGoal(abstractScienceGoal.deepCopy());
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            unknownEntityException.printStackTrace();
        }
    }
}

