/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.Interactor;
import alma.obsprep.ot.actions.PostRetrievalActionInterface;
import alma.obsprep.ot.actions.RetrieveAsNewPerformer;
import alma.obsprep.ot.actions.RetrieveInteractor;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.models.sciencegoals.SfiControlParameterModel;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Angle;
import alma.valuetypes.UserAngle;
import java.io.IOException;
import lombok.NonNull;

public class RetrieveAsNewACASupplementalCallProposalPerformer
extends RetrieveAsNewPerformer {
    public RetrieveAsNewACASupplementalCallProposalPerformer(Interactor interactor, ProjectRepository projectRepository) {
        super(interactor, projectRepository);
    }

    @Override
    public boolean postRetrieveProcessing(@NonNull ObsProject obsProject) throws PostRetrievalActionInterface.UnableToPerformPostRetrievalProcessingException {
        ObsProposal obsProposal;
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        RetrieveInteractor retrieveInteractor = (RetrieveInteractor)this.getGui();
        if (!this.isSupplementalCallProposal && !retrieveInteractor.getUserConfirmation("Converting proposal to an ACA supplemental call proposal. Cancel if this is not what you intended.", "Convert", "Cancel")) {
            return false;
        }
        this.projectRecycler.recycleProjectAsNewProject(obsProject);
        obsProject.setIsDDT(false);
        try {
            obsProposal = obsProject.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            retrieveInteractor.error((Exception)((Object)unknownEntityException));
            return false;
        }
        if (obsProposal.isProjectSunBased() || obsProposal.isVLBIorPhasedArray()) {
            GUIUtilities.error(null, "Unable to recycle a solar or VLBI project as an ACA supplemental call proposal");
            return false;
        }
        obsProposal.setCycle(AlmaPolicies.getInstance().getSupplementalCallCycleNumber());
        this.isProjectDDT = false;
        this.isSupplementalCallProposal = obsProposal.isSupplementalCallProposal();
        RetrieveAsNewACASupplementalCallProposalPerformer.convertAllScienceGoalsToACASupplementalCfPStandard(obsProposal);
        try {
            Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decomposeIncludingFiles(obsProject);
            ImpexFactory.updateRevisionNumbersOfDocuments(boBundle);
        }
        catch (UnknownEntityException | IOException throwable) {
            Log.logger(RetrieveAsNewACASupplementalCallProposalPerformer.class).warning("Unable to reset the revision number of document: " + throwable.getMessage());
        }
        obsProject.resetAfterImport();
        return true;
    }

    public static void convertAllScienceGoalsToACASupplementalCfPStandard(@NonNull ObsProposal obsProposal) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
            performanceParameters.setAngularResolutionMode(AngularResolutionMode.SACA);
            Angle angle = performanceParameters.getACAAngularResolution();
            performanceParameters.setAcceptableAngularResolution(UserAngle.createUserAngle(angle));
            performanceParameters.setDesiredAngularResolution(UserAngle.createUserAngle(angle));
            Log.logger(RetrieveAsNewACASupplementalCallProposalPerformer.class).fine("SG " + scienceGoal.getName() + " " + angle);
            SfiControlParameterModel.updateACASensitivityValues(scienceGoal);
        }
    }
}

