/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.acs.entityutil.EntityException;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.ProjectRepositoryPerformer;
import alma.obsprep.ot.actions.RetrieveAsNew;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.persistence.MendMyStruct;
import alma.obsprep.services.userlookup.User;
import alma.obsprep.services.userlookup.UserLookup;
import alma.obsprep.services.userlookup.UserLookupException;
import alma.obsprep.util.GUIUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public class ProjectRecycler {
    boolean updateExecutivesOfInvestigators(@NonNull ObsProject obsProject) throws UnknownEntityException, UserLookupException {
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        boolean bl = false;
        List<Investigator> list = this.getAllInvestigatorsInProposal(obsProject);
        List<User> list2 = this.lookupInvestigatorsInDatabase(list);
        for (Investigator investigator : list) {
            Optional<User> optional = list2.stream().filter(user -> investigator.getUserId().equals(user.getUid())).findFirst();
            if (optional.isPresent()) {
                String string;
                User user2 = optional.get();
                Investigator investigator2 = Investigator.createInvestigator(user2);
                String string2 = investigator2.getAllowedExec();
                if (investigator.gettrueFirstName() == null || investigator.gettrueFirstName().length() == 0 || investigator.gettrueSurName() == null || investigator.gettrueSurName().length() == 0) {
                    investigator.setFirstName(investigator2.getFirstName());
                    investigator.setSurName(investigator2.getSurName());
                }
                if (!(string = investigator.getAllowedExec()).equals(Investigator.ALLOWEDEXEC_NA_EA) && string2.equals(Investigator.ALLOWEDEXEC_NA_EA)) {
                    Log.logger(ProjectRepositoryPerformer.class).fine("Investigator " + investigator.getUserId() + " is now a Taiwanese investigator");
                    investigator.setAssociatedExec(Investigator.ASSOCIATEDEXEC_EA);
                    investigator.setAllowedExec(Investigator.ALLOWEDEXEC_NA_EA);
                    investigator.setOrganisation(investigator2.getOrganisation());
                    investigator.setOrganisationId(investigator2.getOrganisationId());
                    investigator.setEMail(investigator2.getEMail());
                    investigator.setTelephone(investigator2.getTelephone());
                    bl = true;
                } else {
                    investigator.setAllowedExec(investigator2.getAllowedExec());
                    if (!investigator2.getAllowedExec().equals(Investigator.ALLOWEDEXEC_NA_EA)) {
                        investigator.setAssociatedExec(investigator2.getAssociatedExec());
                    }
                    investigator.setOrganisation(investigator2.getOrganisation());
                    investigator.setOrganisationId(investigator2.getOrganisationId());
                    investigator.setEMail(investigator2.getEMail());
                    investigator.setTelephone(investigator2.getTelephone());
                }
                ObservingToolController.publishModelForBo(ObsProposal.class);
                continue;
            }
            Log.logger((Object)this).warning("Unable to find user " + investigator.getEMail() + " in the user database - unable to check affiliation/executive for that user");
        }
        return bl;
    }

    private List<User> lookupInvestigatorsInDatabase(List<Investigator> list) throws UserLookupException {
        if (ObservingToolController.isOTInBatchMode()) {
            return new ArrayList<User>();
        }
        UserLookup userLookup = ObservingToolController.getMyInstance().getUserLookup();
        if (userLookup == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: userLookup");
        }
        String[] stringArray = (String[])list.stream().map(investigator -> investigator.getUserId()).toArray(String[]::new);
        List<User> list2 = userLookup.matchUid(stringArray);
        return list2;
    }

    private List<Investigator> getAllInvestigatorsInProposal(ObsProject obsProject) throws UnknownEntityException {
        ArrayList<Investigator> arrayList = new ArrayList<Investigator>();
        ObsProposal obsProposal = obsProject.getObsProposal();
        arrayList.addAll(Arrays.asList(obsProposal.getCoInvestigator()));
        arrayList.addAll(Arrays.asList(obsProposal.getCoPrincipalInvestigator()));
        arrayList.add(obsProposal.getPrincipalInvestigator());
        return arrayList;
    }

    void recycleProjectAsNewProject(ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("Illegal argument. The argument cannot be null: obsProject");
        }
        try {
            ObsProposal obsProposal = obsProject.getObsProposal();
            ObsProgram obsProgram = obsProject.getObsProgram();
            boolean bl = obsProgram.getAbstractScienceGoalCount() == obsProposal.getAbstractScienceGoalCount() || obsProposal.getAbstractScienceGoalCount() == 0;
            MendMyStruct.recycleProjectAsNewProject(obsProject, bl);
            if (this.updateExecutivesOfInvestigators(obsProject)) {
                GUIUtilities.info(null, "Please check that the executive assigned to all Taiwanese investigators is correct.");
            }
        }
        catch (EntityException | UnknownEntityException | UserLookupException throwable) {
            Log.logger(RetrieveAsNew.class).warning("Unable to reset required XML elements when reusing an existing project " + throwable.getMessage());
        }
    }
}

