/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.NewProjectInteractor;
import alma.obsprep.ot.actions.NewProjectPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.util.GUIUtilities;

public class NewProject
extends OTAction
implements NewProjectInteractor {
    private static DialogId DIALOG_SAVE_CURRENT_PROJECT = new DialogId("NewProject.SaveCurrentProject", "Save current project before creating new project");
    private ObservingToolGui gui;
    private ProjectMode mode;

    public NewProject(ObservingToolGui observingToolGui) {
        this(observingToolGui, ProjectMode.STANDARD);
    }

    public NewProject(ObservingToolGui observingToolGui, ProjectMode projectMode) {
        this.gui = observingToolGui;
        this.mode = projectMode;
        NewProjectPerformer newProjectPerformer = new NewProjectPerformer(this);
        this.setPerformer(newProjectPerformer);
    }

    @Override
    public ProjectMode getProjectMode() {
        return this.mode;
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public void display(ObsProject obsProject) {
        this.gui.setPrimaryProject(obsProject, null, false);
    }

    @Override
    public boolean confirmOverwrite() {
        if (this.gui.isProjectModified(this.gui.getPrimaryProject())) {
            switch (GUIUtilities.offer(DIALOG_SAVE_CURRENT_PROJECT, "The current project has unsaved changes.\nDo you want to save it now, or discard the changes?", "Save", "Discard", "Cancel")) {
                case 2: {
                    return false;
                }
                case 0: {
                    this.gui.primaryProjectCompartment().getProjectTiedActions().save.actionPerformed(null);
                }
            }
        }
        return true;
    }

    public static enum ProjectMode {
        STANDARD,
        MANUAL,
        SIMULATION,
        CALIBRATION,
        COMMISSIONING,
        VLBI,
        LARGEPROGRAM,
        ACASUPPLEMENTALCALL;

    }
}

