/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.ImportBase;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.util.GUIUtilities;
import java.io.File;
import java.net.URL;

public class ImportProject
extends ImportBase {
    private static DialogId DIALOG_SAVE_CURRENT_PROJECT = new DialogId("Import.SaveCurrentProject");
    private boolean useFinder;

    public ImportProject(ObservingToolGui observingToolGui, boolean bl) {
        super(observingToolGui);
        this.useFinder = bl;
    }

    @Override
    public URL getImportURL() {
        if (this.gui.isProjectModified(this.gui.getPrimaryProject())) {
            GUIUtilities.dialogSettings(DIALOG_SAVE_CURRENT_PROJECT).setAutoanswer(1);
            switch (GUIUtilities.offer(DIALOG_SAVE_CURRENT_PROJECT, "The current project has unsaved changes.\nDo you want to save it now, or discard the changes?", "Save", "Discard", "Cancel")) {
                case 2: {
                    return null;
                }
                case 0: {
                    this.gui.primaryProjectCompartment().getProjectTiedActions().save.actionPerformed(null);
                }
            }
        }
        if (this.useFinder) {
            return this.getImportUrlFromProjectFinder();
        }
        return this.getImportUrlFromFileChooser();
    }

    @Override
    public void display(ObsProject obsProject, File file) {
        this.gui.setPrimaryProject(obsProject, file, false);
        this.gui.flagBrokenSchedBlocks(obsProject);
    }
}

