/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.ot.actions.ImportInteractor;
import alma.obsprep.ot.actions.ImportPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.ObsProjectChooserPdb;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.MultipleFileFilter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public abstract class ImportBase
extends OTAction
implements ImportInteractor {
    protected ObservingToolGui gui;
    protected JFileChooser chooser;
    private ObsProjectChooserPdb.DefaultDialog dialog;

    public ImportBase(ObservingToolGui observingToolGui) {
        this.gui = observingToolGui;
        ImportPerformer importPerformer = new ImportPerformer(this);
        this.setPerformer(importPerformer);
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    protected URL getImportUrlFromFileChooser() {
        Object object;
        int n;
        if (this.chooser == null) {
            this.chooser = GuiFactory.getFactory().giveFileChooser("aot");
            n = 0;
            for (FileFilter fileFilter : this.chooser.getChoosableFileFilters()) {
                if (!"OT import/export files".equals(fileFilter.getDescription())) continue;
                n = 1;
            }
            if (n == 0) {
                object = new String[]{"aot", "txt"};
                this.chooser.setFileFilter(new MultipleFileFilter((String[])object, "OT import/export files"));
            }
        }
        this.chooser.setDialogTitle("Open");
        n = this.chooser.showOpenDialog(null);
        if (n != 0) {
            return null;
        }
        object = this.chooser.getSelectedFile();
        String string = "file:" + ((File)object).getPath();
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            GUIUtilities.error(null, "Error on import", malformedURLException);
        }
        return uRL;
    }

    protected URL getImportUrlFromProjectFinder() {
        Object object;
        if (this.dialog == null) {
            object = this.gui.getFactory();
            this.dialog = new ObsProjectChooserPdb.DefaultDialog((GuiFactory)object);
        }
        object = this.dialog.letUserChooseProject();
        URL uRL = null;
        if (object != null) {
            try {
                uRL = FileUtilities.makeURL((File)object);
            }
            catch (MalformedURLException malformedURLException) {
                GUIUtilities.error(null, "Error on import", malformedURLException);
            }
        }
        return uRL;
    }
}

