/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.FindNodeInteractor;
import alma.obsprep.ot.actions.FindNodePerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.util.GUIUtilities;
import lombok.NonNull;

public class FindNode
extends OTAction
implements FindNodeInteractor,
EventReceiver {
    private BusinessObject selectedBo = null;
    private SearchDirection searchDirection;
    private ProjectTreeNode selectedNode;

    public FindNode(@NonNull SearchDirection searchDirection) {
        if (searchDirection == null) {
            throw new NullPointerException("searchDirection is marked non-null but is null");
        }
        this.searchDirection = searchDirection;
        FindNodePerformer findNodePerformer = new FindNodePerformer(this);
        this.setPerformer(findNodePerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(true);
    }

    @Override
    public void receiveEvent(Event event) {
        this.selectedNode = (ProjectTreeNode)event.getSource();
        this.selectedBo = (BusinessObject)this.selectedNode.getUserObject();
        this.setEnabled(true);
    }

    @Override
    public ProjectTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public BusinessObject getSelectedBO() {
        return this.selectedBo;
    }

    @Override
    public SearchDirection getSearchDirection() {
        return this.searchDirection;
    }

    public static enum SearchDirection {
        PREVIOUS,
        NEXT;

    }
}

