/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.hla.runtime.obsprep.util.XmlConversionException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.Interactor;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.persistence.Apdm_to_BO;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.util.GUIUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;

public class ExportSB {

    public static class Action
    extends OTAction
    implements Interact,
    EventReceiver {
        private static String FAV_DIR_FOR_XML_EXPORT_FILES = "sb.xml";
        private static DialogId DIALOG_OVERWRITE_FILE = new DialogId("ExportSB.OverwriteFile");
        private JFileChooser chooser;
        private SchedBlock selectedSB;

        public Action() {
            this.setPerformer(new Perform(this));
            EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        }

        @Override
        public File getExportTo() {
            String string;
            boolean bl;
            String string2 = ".xml";
            if (this.chooser == null) {
                this.chooser = GuiFactory.getFactory().giveFileChooser(FAV_DIR_FOR_XML_EXPORT_FILES);
            }
            File file = this.chooser.getCurrentDirectory();
            String string3 = this.getProject().getCode();
            String string4 = this.getSchedBlock().getName();
            String string5 = string3 + "_" + string4 + string2;
            File file2 = new File(file, string5);
            this.chooser.setSelectedFile(file2);
            int n = this.chooser.showSaveDialog(GuiFactory.getFactory().getParentWindow());
            if (n != 0) {
                return null;
            }
            File file3 = this.chooser.getSelectedFile();
            String string6 = file3.getName();
            if (!string6.endsWith(string2)) {
                file3 = new File(file3.getParentFile(), string6 + string2);
                string6 = file3.getName();
            }
            if (file3.exists() && !(bl = GUIUtilities.confirm(DIALOG_OVERWRITE_FILE, string = "File " + string6 + " already exists.\nDo you want to replace it?"))) {
                return null;
            }
            return file3;
        }

        @Override
        public void receiveEvent(Event event) {
            ProjectTreeNode projectTreeNode = (ProjectTreeNode)event.getSource();
            BusinessObject businessObject = (BusinessObject)projectTreeNode.getUserObject();
            if (businessObject instanceof SchedBlock) {
                this.selectedSB = (SchedBlock)businessObject;
                this.setEnabled(true);
            } else {
                this.selectedSB = null;
                this.setEnabled(false);
            }
        }

        @Override
        public ObsProject getProject() {
            if (this.selectedSB != null) {
                try {
                    return this.selectedSB.getObsProject();
                }
                catch (UnknownEntityException unknownEntityException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public SchedBlock getSchedBlock() {
            return this.selectedSB;
        }

        @Override
        public void error(String string) {
            GUIUtilities.error(null, string);
        }
    }

    public static interface Interact
    extends Interactor {
        public File getExportTo();

        public ObsProject getProject();

        public SchedBlock getSchedBlock();

        public void error(String var1);
    }

    public static class Perform
    extends Performer {
        public Perform(Interact interact) {
            super(interact);
        }

        @Override
        public void perform() {
            Interact interact = (Interact)this.getGui();
            File file = interact.getExportTo();
            if (file == null) {
                return;
            }
            try {
                SchedBlock schedBlock = interact.getSchedBlock();
                ObsProject obsProject = interact.getProject();
                Apdm_to_BO.BoBundle boBundle = Apdm_to_BO.decompose(obsProject);
                Apdm_to_BO.SoBundle soBundle = Apdm_to_BO.down(boBundle);
                Apdm_to_BO.XmlBundle xmlBundle = Apdm_to_BO.down(soBundle);
                int n = boBundle.boSchedblocks.indexOf(schedBlock);
                String string = xmlBundle.xmlSBs.get(n);
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(string);
                fileWriter.close();
            }
            catch (NullPointerException nullPointerException) {
                interact.error(nullPointerException.toString());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                interact.error(indexOutOfBoundsException.toString());
            }
            catch (XmlConversionException xmlConversionException) {
                interact.error(xmlConversionException.toString());
            }
            catch (UnknownEntityException unknownEntityException) {
                interact.error(unknownEntityException.toString());
            }
            catch (IOException iOException) {
                interact.error(iOException.toString());
            }
        }
    }
}

