/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.ExportInteractor;
import alma.obsprep.ot.actions.ExportPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.GuiFactory;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.ProjectResetListener;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.SingleFileFilter;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class Export
extends OTAction
implements ExportInteractor,
EventReceiver,
ProjectResetListener,
RoleDirectoryService.UserAuthenticatesListener {
    private static DialogId DIALOG_OVERWRITE_FILE = new DialogId("ExportProject.OverwriteFile");
    private ObservingToolGui gui;
    private JFileChooser chooser;
    private final boolean isSaveAs;

    public Export(ObservingToolGui observingToolGui, boolean bl) {
        this.gui = observingToolGui;
        this.isSaveAs = bl;
        ExportPerformer exportPerformer = new ExportPerformer(this);
        this.setPerformer(exportPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(true);
        ImpexFactory.getInstance().addProjectImportListener(this);
        RoleDirectoryService.addUserAuthenticatesListener(this);
    }

    private void createFileChooser() {
        this.chooser = GuiFactory.getFactory().giveFileChooser("aot");
        boolean bl = false;
        for (FileFilter fileFilter : this.chooser.getChoosableFileFilters()) {
            if (!"OT import/export files".equals(fileFilter.getDescription())) continue;
            bl = true;
        }
        if (!bl) {
            this.chooser.setFileFilter(new SingleFileFilter("aot", "OT import/export files"));
        }
    }

    @Override
    public boolean isEnabled() {
        ObsProject obsProject;
        try {
            obsProject = this.gui.getPrimaryProject();
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
        return !RoleDirectoryServiceHelper.isContactScientist(obsProject) || RoleDirectoryServiceHelper.isUserP2G();
    }

    @Override
    public void receiveEvent(Event event) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public File getExportPathname() {
        File file;
        if (!this.isSaveAs && (file = this.gui.primaryProjectCompartment().getFileLocation()) != null) {
            return file;
        }
        return this.getExportPathnameFromFileChooser();
    }

    private File getExportPathnameFromFileChooser() {
        if (this.chooser == null) {
            this.createFileChooser();
        }
        this.chooser.setDialogTitle("Save As...");
        int n = this.chooser.showSaveDialog(null);
        if (n != 0) {
            return null;
        }
        File file = this.chooser.getSelectedFile();
        String string = FileUtilities.getExtension(file);
        string = string == null ? ".aot" : (string.length() == 0 ? "aot" : (string.equals("aot") ? "" : ".aot"));
        String string2 = file.getPath();
        String string3 = string2 + string;
        if (!(file = new File(string3)).exists()) {
            return file;
        }
        String string4 = "???";
        try {
            string4 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string5 = "File " + string4 + " already exists.\nDo you want to replace it?";
        boolean bl = GUIUtilities.confirm(DIALOG_OVERWRITE_FILE, string5);
        if (bl) {
            return file;
        }
        return null;
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public ObsProject getItemToExport() {
        return this.gui.getPrimaryProject();
    }

    @Override
    public void exportDone(ObsProject obsProject, File file) {
        if (this.gui != null) {
            this.gui.primaryProjectCompartment().resetInitialObsProject(obsProject);
            this.gui.primaryProjectCompartment().setFileLocation(file);
            this.gui.setProgressText("Project saved to disk ...");
        }
    }

    @Override
    public void projectDocumentReset(ObsProject obsProject, ImpexFactory.WorkingPersistenceData workingPersistenceData) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void userHasAuthenticated() {
        this.setEnabled(this.isEnabled());
    }
}

