/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.ot.actions.DisplayProjectTimeSummaryInteractor;
import alma.obsprep.ot.actions.DisplayProjectTimeSummaryPerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.editors.sciencegoals.StandardProjectTimeEstimateSummary;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.JavaFXHTMLWindow;
import javax.swing.JDialog;

public class DisplayProjectTimeSummary
extends OTAction
implements DisplayProjectTimeSummaryInteractor {
    private ProjectTree oustree;
    private ObservingToolGui gui;

    public DisplayProjectTimeSummary(ProjectTree projectTree, ObservingToolGui observingToolGui) {
        this.oustree = projectTree;
        this.gui = observingToolGui;
        DisplayProjectTimeSummaryPerformer displayProjectTimeSummaryPerformer = new DisplayProjectTimeSummaryPerformer(this);
        this.setPerformer(displayProjectTimeSummaryPerformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display() {
        try {
            AbstractScienceGoal[] abstractScienceGoalArray = null;
            if (this.oustree == null || this.oustree.getProject() == null || this.oustree.getProject().getObsProposal() == null && this.oustree.getProject().getObsProgram() == null) {
                this.error("No observing proposal or observing project is defined");
                return;
            }
            if (this.oustree.getProject().getObsProgram() != null) {
                abstractScienceGoalArray = this.oustree.getProject().getObsProgram().getAbstractScienceGoal();
                if (abstractScienceGoalArray.length == 0) {
                    abstractScienceGoalArray = this.oustree.getProject().getObsProposal().getAbstractScienceGoal();
                }
            } else {
                abstractScienceGoalArray = this.oustree.getProject().getObsProposal().getAbstractScienceGoal();
            }
            assert (abstractScienceGoalArray != null);
            boolean bl = false;
            for (AbstractScienceGoal object : abstractScienceGoalArray) {
                if (!(object instanceof ScienceGoal)) continue;
                bl = true;
            }
            if (!bl) {
                this.error("There are no science goals defined");
                return;
            }
            StandardProjectTimeEstimateSummary standardProjectTimeEstimateSummary = new StandardProjectTimeEstimateSummary(abstractScienceGoalArray);
            this.busy(true);
            String string = null;
            try {
                string = standardProjectTimeEstimateSummary.info();
            }
            catch (Exception exception) {
                String string2 = "Unable to display project time summary :" + exception.getMessage();
                Log.logger(DisplayProjectTimeSummary.class).warning(string2);
                exception.printStackTrace();
                GUIUtilities.warning(null, string2);
            }
            finally {
                this.busy(false);
            }
            if (string != null) {
                JDialog jDialog = this.buildProjectSummaryWindow(string);
                jDialog.setVisible(true);
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    public JDialog buildProjectSummaryWindow(String string) {
        JavaFXHTMLWindow javaFXHTMLWindow = new JavaFXHTMLWindow();
        return javaFXHTMLWindow.buildHTMLWindow(string, "Project Summary", 1300, 800);
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
        this.busy(false);
    }

    @Override
    public void busy(boolean bl) {
        this.gui.showAsBusy(bl);
    }
}

