/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.HolographyParameters;
import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.RadiometricPointingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.CloneProjectTreeNodeInteractor;
import alma.obsprep.ot.actions.CloneProjectTreeNodePerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.OTActionHelper;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.calibration.SidebandRatioCalObs;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.util.GUIUtilities;
import com.google.common.collect.ImmutableSet;

public class CloneProjectTreeNode
extends OTAction
implements CloneProjectTreeNodeInteractor,
EventReceiver,
RoleDirectoryService.UserAuthenticatesListener {
    final ImmutableSet<Class<?>> cloneableBOs = ImmutableSet.of(FocusCalParameters.class, PhaseCalParameters.class, DelayCalParameters.class, PointingCalParameters.class, BandpassCalParameters.class, ScienceParameters.class, (Object[])new Class[]{ObservatoryGoal.class, SchedBlock.class, SpectralSpec.class, ScienceGoal.class, Target.class, FieldSource.class, HolographyParameters.class, OpticalPointingParameters.class, CheckSourceCalParameters.class, AtmosphericCalParameters.class, RadiometricPointingParameters.class, SidebandRatioCalObs.class, OpticalPointingParameters.class, DGCReferenceCalParameters.class, DGCScienceCalParameters.class});
    private final ProjectTree oustree;
    private final ProjectTree usertree;
    private BusinessObject selectedBO = null;
    private BusinessObject parentBO = null;
    private ProjectTreeNode selectedNode = null;
    private ProjectTreeNode parentNode = null;
    private boolean isUserView;

    public CloneProjectTreeNode(ProjectTree projectTree, ProjectTree projectTree2) {
        this.usertree = projectTree;
        this.oustree = projectTree2;
        CloneProjectTreeNodePerformer cloneProjectTreeNodePerformer = new CloneProjectTreeNodePerformer(this);
        this.setPerformer(cloneProjectTreeNodePerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        RoleDirectoryService.addUserAuthenticatesListener(this);
        this.setEnabled(false);
        this.setHidable(false);
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public void info(String string) {
        GUIUtilities.info(null, string);
    }

    @Override
    public BusinessObject getSelectedBO() {
        return this.selectedBO;
    }

    @Override
    public BusinessObject getParentBO() {
        return this.parentBO;
    }

    @Override
    public ProjectTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    @Override
    public ProjectTreeNode getParentNode() {
        return this.parentNode;
    }

    private void setEnabledFor(ProjectTreeNode projectTreeNode, boolean bl) {
        BusinessObject businessObject;
        ProjectTree projectTree = bl ? this.usertree : this.oustree;
        boolean bl2 = this.cloneableBOs.stream().anyMatch(clazz -> this.selectedBO.getClass().equals(clazz));
        boolean bl3 = false;
        if (this.selectedBO.getClass().equals(ObsUnitSet.class) && (businessObject = this.selectedBO.getParent()) != null && !businessObject.getName().equals("Observing Program")) {
            bl3 = true;
        }
        this.setEnabled((bl3 || bl2) && projectTree.isDndExportable(projectTreeNode, 1) && !OTActionHelper.isActionPIRestricted(projectTreeNode.getUserObjectPath()));
    }

    @Override
    public void receiveEvent(Event event) {
        this.selectedNode = (ProjectTreeNode)event.getSource();
        this.parentNode = (ProjectTreeNode)this.selectedNode.getParent();
        this.selectedBO = (BusinessObject)this.selectedNode.getUserObject();
        this.parentBO = this.parentNode != null ? (BusinessObject)this.parentNode.getUserObject() : null;
        this.isUserView = this.usertree.getTop() == this.selectedNode.getRoot();
        this.setEnabledFor(this.selectedNode, this.isUserView);
    }

    @Override
    public ProjectTree getProjectTree() {
        return this.isUserView ? this.usertree : this.oustree;
    }

    @Override
    public void userHasAuthenticated() {
        if (this.selectedBO == null) {
            return;
        }
        this.setEnabledFor(this.selectedNode, this.isUserView);
    }
}

