/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.schedblock.AbstractInstrumentSpec;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.AttachInteractor;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.gui.toplevel.EditorManager;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AttachPerformer
extends Performer {
    AttachInteractor gui;
    private final String OK;

    public AttachPerformer(AttachInteractor attachInteractor) {
        super(attachInteractor);
        this.OK = null;
        this.gui = attachInteractor;
    }

    @Override
    public void perform() {
        EditorManager editorManager;
        String string;
        List<BusinessObject> list;
        AttachInteractor attachInteractor = (AttachInteractor)this.getGui();
        Target target = (Target)attachInteractor.getSelectedBO();
        SchedBlock schedBlock = target.getSchedBlock();
        BusinessObject businessObject2 = null;
        List<BusinessObject> list2 = this.getAttachableComponents(schedBlock);
        Iterator<Object> iterator = attachInteractor.select(list2, list = this.getAttachedComponents(target));
        if (iterator == null) {
            return;
        }
        ArrayList<BusinessObject> arrayList = new ArrayList<BusinessObject>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        for (BusinessObject businessObject2 : list) {
            if (businessObject2 == null || arrayList.contains(businessObject2)) continue;
            string = this.performDetachFromTarget(businessObject2, target);
            if (string != this.OK) {
                attachInteractor.error(string);
                continue;
            }
            editorManager = ObservingToolController.getMyInstance().getGui().getEditorManager();
            editorManager.modelFor((BusinessObject)target).setDocument(target);
            ActionLog.performed("Detach", businessObject2, "from", target);
        }
        for (BusinessObject businessObject2 : arrayList) {
            if (businessObject2 == null || list.contains(businessObject2)) continue;
            string = this.performAttachToTarget(businessObject2, target);
            if (string != this.OK) {
                attachInteractor.error(string);
                continue;
            }
            editorManager = ObservingToolController.getMyInstance().getGui().getEditorManager();
            editorManager.modelFor((BusinessObject)target).setDocument(target);
            ActionLog.performed("Attach", businessObject2, "to", target);
        }
    }

    private String performAttachToTarget(BusinessObject businessObject, Target target) {
        if (businessObject instanceof FieldSource) {
            target.setFieldSource((FieldSource)businessObject);
            return this.OK;
        }
        if (businessObject instanceof AbstractInstrumentSpec) {
            target.setAbstractInstrumentSpec((AbstractInstrumentSpec)businessObject);
            return this.OK;
        }
        if (businessObject instanceof ObservingParameters) {
            target.addObservingParameters((ObservingParameters)businessObject);
            return this.OK;
        }
        return "Cannot attach an " + businessObject.getNameOrDefault() + " to a target.";
    }

    private String performDetachFromTarget(BusinessObject businessObject, Target target) {
        if (businessObject instanceof FieldSource) {
            if (target.getFieldSource() == businessObject) {
                target.setFieldSource(null);
                return this.OK;
            }
            return "Cannot detach the " + businessObject.getNameOrDefault() + " from the Target : not attached";
        }
        if (businessObject instanceof AbstractInstrumentSpec) {
            if (target.getAbstractInstrumentSpec() == businessObject) {
                target.setAbstractInstrumentSpec(null);
                return this.OK;
            }
            return "Cannot detach the " + businessObject.getNameOrDefault() + " from the Target : not attached";
        }
        if (businessObject instanceof ObservingParameters) {
            ObservingParameters observingParameters = (ObservingParameters)businessObject;
            if (target.hasTheParameters(observingParameters)) {
                target.removeObservingParameters(observingParameters);
                return this.OK;
            }
            return "Cannot detach the " + businessObject.getNameOrDefault() + " from the Target : not attached";
        }
        return "Cannot detach the " + businessObject.getNameOrDefault() + " from the Target";
    }

    public List<BusinessObject> getAttachableComponents(SchedBlock schedBlock) {
        ArrayList<BusinessObject> arrayList = new ArrayList<BusinessObject>();
        FieldSource[] fieldSourceArray = schedBlock.getFieldSource();
        for (int i = 0; i < fieldSourceArray.length; ++i) {
            arrayList.add((BusinessObject)fieldSourceArray[i]);
        }
        AbstractInstrumentSpec[] abstractInstrumentSpecArray = schedBlock.getInstrumentSpec();
        for (int i = 0; i < abstractInstrumentSpecArray.length; ++i) {
            arrayList.add((BusinessObject)abstractInstrumentSpecArray[i]);
        }
        ObservingParameters[] observingParametersArray = schedBlock.getObservingParameters();
        for (int i = 0; i < observingParametersArray.length; ++i) {
            arrayList.add((BusinessObject)observingParametersArray[i]);
        }
        return arrayList;
    }

    public List<BusinessObject> getAttachedComponents(Target target) {
        ArrayList<BusinessObject> arrayList = new ArrayList<BusinessObject>();
        arrayList.add((BusinessObject)target.getFieldSource());
        arrayList.add((BusinessObject)target.getAbstractInstrumentSpec());
        for (ObservingParameters observingParameters : target.getObservingParameters()) {
            arrayList.add((BusinessObject)observingParameters);
        }
        return arrayList;
    }
}

