/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.widgets;

import alma.obsprep.ot.gui.resources.Icons;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OTComboBox
extends JPanel {
    private static final long serialVersionUID = 6438868974008688268L;
    private transient JComboBox combobox;
    private transient JLabel label;
    private static transient Icon invalid = null;

    public OTComboBox(Object[] objectArray) {
        super(new BorderLayout());
        this.combobox = new JComboBox<Object>(objectArray);
        this.setup();
    }

    public OTComboBox(Vector<?> vector) {
        super(new BorderLayout());
        this.combobox = new JComboBox(vector);
        this.setup();
    }

    private void setup() {
        if (invalid == null) {
            invalid = Icons.getIcon("cb-invalid.gif");
        }
        this.label = new JLabel();
        this.label.setIcon(null);
        this.label.setPreferredSize(new Dimension(invalid.getIconWidth(), invalid.getIconHeight()));
        Box box = Box.createHorizontalBox();
        box.add(this.combobox);
        box.add(this.label);
        box.add(Box.createHorizontalGlue());
        this.add(box);
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        if (this.combobox != null) {
            this.combobox.setToolTipText(string);
        }
        if (this.label != null) {
            this.label.setToolTipText(string);
        }
    }

    public void setValid(boolean bl) {
        if (bl) {
            this.label.setIcon(null);
        } else {
            this.label.setIcon(invalid);
        }
    }

    public int getItemCount() {
        return this.combobox.getItemCount();
    }

    public void addActionListener(ActionListener actionListener) {
        this.combobox.addActionListener(actionListener);
    }

    public void setSelectedItem(Object object) {
        this.combobox.setSelectedItem(object);
    }

    public Object getSelectedItem() {
        return this.combobox.getSelectedItem();
    }

    public void removeActionListener(ActionListener actionListener) {
        this.combobox.removeActionListener(actionListener);
    }

    public Object getItemAt(int n) {
        return this.combobox.getItemAt(n);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.combobox.setEnabled(bl);
    }

    public void updateOptions(ArrayList<String> arrayList) {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (String string : arrayList) {
            defaultComboBoxModel.addElement(string);
        }
        this.combobox.setModel(defaultComboBoxModel);
    }

    public List<JComponent> getMinorEditAffectedComponents() {
        return Arrays.asList(this.label, this.combobox);
    }
}

