/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.jsky.catalog.astrocat;

import alma.obsprep.guiutil.jsky.catalog.astrocat.AlmaAstroCatalog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.CatalogFactory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.astrocat.AstroCatalog;
import jsky.util.NameValue;
import jsky.util.Resources;
import jsky.util.SaxParserUtil;
import jsky.util.TclUtil;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class AlmaAstroCatXML
extends SaxParserUtil {
    private static String VERSION = "0.1";
    private static final String NAMESPACE = "";
    private static final String LOCAL_NAME = "";
    private static final String CDATA = "CDATA";
    private static final String PUBLIC_ID = "-//JSky//DTD for Catalog Access//EN";
    private static final String SYSTEM_ID = "AstroCat.dtd";
    private Vector<Catalog> _catalogs;
    private AstroCatalog _catalog;
    private List<FieldDescAdapter> _params;
    private FieldDescAdapter _param;
    private List<NameValue> _options;
    private NameValue _option;
    private List<TablePlotSymbol> _symbols;
    private TablePlotSymbol _symbol;

    public List<Catalog> getCatalogs() {
        return this._catalogs;
    }

    public void _catalogsStart(Attributes attributes) {
        this._catalogs = new Vector();
    }

    public void _catalogsEnd() {
        int n = this._catalogs.size();
        for (int i = n - 1; i >= 0; --i) {
            PlotableCatalog plotableCatalog;
            AstroCatalog astroCatalog;
            String string;
            Catalog catalog = this._catalogs.get(i);
            if (!(catalog instanceof AstroCatalog) || (string = (astroCatalog = (AstroCatalog)catalog).getURLPath()) != null && string.length() != 0) continue;
            Catalog catalog2 = CatalogFactory.getCatalogByName((String)astroCatalog.getName());
            if (catalog2 == null) {
                this._catalogs.remove(i);
                System.out.println("Warning: catalog not found in any config files: '" + astroCatalog.getName() + "', referenced in " + this.getURL());
                continue;
            }
            if (this._catalogs.contains(catalog2)) {
                this._catalogs.remove(i);
                System.out.println("Warning: duplicate catalog: '" + astroCatalog.getName() + "' in " + this.getURL());
                continue;
            }
            this._catalogs.setElementAt(catalog2, i);
            if (!(catalog instanceof PlotableCatalog) || !(catalog2 instanceof PlotableCatalog) || (plotableCatalog = (PlotableCatalog)catalog).getNumSymbols() == 0) continue;
            PlotableCatalog plotableCatalog2 = (PlotableCatalog)catalog2;
            plotableCatalog2.setSymbols(plotableCatalog.getSymbols());
            plotableCatalog2.setSymbolsEdited(true);
        }
    }

    public void _catalogStart(Attributes attributes) {
        if (this._catalogs == null) {
            this._catalogs = new Vector();
        }
        if (attributes != null) {
            this._catalog = new AlmaAstroCatalog();
            this._catalog.setURL(this.getURL());
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string = attributes.getQName(i);
                String string2 = attributes.getValue(i);
                if (string.equals("id")) {
                    this._catalog.setId(string2);
                    continue;
                }
                if (string.equals("name")) {
                    this._catalog.setName(string2);
                    continue;
                }
                if (string.equals("description")) {
                    this._catalog.setDescription(string2);
                    continue;
                }
                if (string.equals("type")) {
                    this._catalog.setType(string2);
                    continue;
                }
                if (string.equals("protocol")) {
                    this._catalog.setProtocol(string2);
                    continue;
                }
                if (string.equals("host")) {
                    this._catalog.setHost(string2);
                    continue;
                }
                if (string.equals("port")) {
                    this._catalog.setPort(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("path")) {
                    this._catalog.setURLPath(string2);
                    continue;
                }
                if (!string.equals("class")) continue;
                this._catalog.setHandlerClass(string2);
            }
        }
    }

    public void _catalogEnd() {
        if (this._catalog != null) {
            if (this._catalog.getName() == null) {
                System.out.println("Warning: no name defined for catalog in " + this.getURL());
            } else if ("directory".equals(this._catalog.getType())) {
                try {
                    this._catalogs.add((Catalog)this._getCatalogDirectory(this._catalog));
                }
                catch (Exception exception) {
                    System.out.println("Warning: error loading catalog directory: " + this._catalog.getName() + ": " + exception);
                }
            } else {
                this._catalogs.add((Catalog)this._catalog);
            }
            this._catalog = null;
        }
    }

    public void _paramsStart(Attributes attributes) {
        this._params = new ArrayList<FieldDescAdapter>();
    }

    public void _paramsEnd() {
        if (this._catalog != null && this._params.size() != 0) {
            FieldDescAdapter[] fieldDescAdapterArray = new FieldDescAdapter[this._params.size()];
            this._params.toArray(fieldDescAdapterArray);
            this._catalog.setParams((FieldDesc[])fieldDescAdapterArray);
        }
        this._params = null;
    }

    public void _paramStart(Attributes attributes) {
        if (attributes != null) {
            this._param = new FieldDescAdapter();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string = attributes.getQName(i);
                String string2 = attributes.getValue(i);
                if (string.equals("id")) {
                    this._param.setId(string2);
                    continue;
                }
                if (string.equals("name")) {
                    this._param.setName(string2);
                    continue;
                }
                if (string.equals("description")) {
                    this._param.setDescription(string2);
                    continue;
                }
                if (string.equals("value")) {
                    this._param.setDefaultValue((Object)string2);
                    continue;
                }
                if (string.equals("type")) {
                    this._param.setType(string2);
                    continue;
                }
                if (string.equals("units")) {
                    this._param.setUnits(string2);
                    continue;
                }
                if (!string.equals("format")) continue;
                this._param.setFormat(string2);
            }
        }
    }

    public void _paramEnd() {
        this._params.add(this._param);
    }

    public void _optionsStart(Attributes attributes) {
        this._options = new ArrayList<NameValue>();
    }

    public void _optionsEnd() {
        if (this._param != null && this._options.size() != 0) {
            NameValue[] nameValueArray = new NameValue[this._options.size()];
            this._options.toArray(nameValueArray);
            this._param.setOptions(nameValueArray);
        }
        this._options = null;
    }

    public void _optionStart(Attributes attributes) {
        if (attributes != null) {
            this._option = new NameValue();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string = attributes.getQName(i);
                String string2 = attributes.getValue(i);
                if (string.equals("name")) {
                    this._option.setName(string2);
                    continue;
                }
                if (!string.equals("value")) continue;
                this._option.setValue((Object)string2);
            }
        }
    }

    public void _optionEnd() {
        this._options.add(this._option);
    }

    public void _symbolsStart(Attributes attributes) {
        this._symbols = new ArrayList<TablePlotSymbol>();
    }

    public void _symbolsEnd() {
        if (this._catalog != null && this._symbols.size() != 0) {
            TablePlotSymbol[] tablePlotSymbolArray = new TablePlotSymbol[this._symbols.size()];
            this._symbols.toArray(tablePlotSymbolArray);
            this._catalog.setSymbols(tablePlotSymbolArray);
        }
        this._symbols = null;
    }

    public void _symbolStart(Attributes attributes) {
        if (attributes != null) {
            this._symbol = new TablePlotSymbol();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                String string = attributes.getQName(i);
                String string2 = attributes.getValue(i);
                if (string.equals("name")) {
                    this._symbol.setName(string2);
                    continue;
                }
                if (string.equals("description")) {
                    this._symbol.setDescription(string2);
                    continue;
                }
                if (string.equals("raCol")) {
                    this._symbol.setRaCol(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("decCol")) {
                    this._symbol.setDecCol(Integer.parseInt(string2));
                    continue;
                }
                if (string.equals("equinox")) {
                    this._symbol.setEquinox(this._getEquinox(string2));
                    continue;
                }
                if (string.equals("columnsUsed")) {
                    this._symbol.setColNames(TclUtil.splitList((String)string2));
                    continue;
                }
                if (string.equals("shape")) {
                    this._symbol.setShapeName(string2);
                    continue;
                }
                if (string.equals("color")) {
                    this._symbol.setFg(string2);
                    continue;
                }
                if (string.equals("condition")) {
                    this._symbol.setCond(string2);
                    continue;
                }
                if (string.equals("ratio")) {
                    this._symbol.setRatio(string2);
                    continue;
                }
                if (string.equals("angle")) {
                    this._symbol.setAngle(string2);
                    continue;
                }
                if (string.equals("label")) {
                    this._symbol.setLabel(string2);
                    continue;
                }
                if (string.equals("size")) {
                    this._symbol.setSize(string2);
                    continue;
                }
                if (!string.equals("units")) continue;
                this._symbol.setUnits(string2);
            }
        }
    }

    public void _symbolEnd() {
        this._symbols.add(this._symbol);
    }

    private double _getEquinox(String string) {
        if (string == null || string.length() == 0 || string.equals("J2000")) {
            return 2000.0;
        }
        if (string.equals("B1950")) {
            return 1950.0;
        }
        return Double.parseDouble(string);
    }

    private CatalogDirectory _getCatalogDirectory(AstroCatalog astroCatalog) {
        String string = astroCatalog.getHandlerClass();
        Class clazz = AstroCatConfig.class;
        try {
            String string2;
            if (string != null) {
                clazz = Class.forName(string);
            }
            if ((string2 = astroCatalog.getURLPath()) == null || string2.length() == 0) {
                Object object = clazz.getMethod("getDirectory", null).invoke((Object)null, (Object[])null);
                CatalogDirectory catalogDirectory = (CatalogDirectory)object;
                catalogDirectory.setName(astroCatalog.getName());
                return catalogDirectory;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            RuntimeException runtimeException = new RuntimeException("Error calling " + string + ".getDirectory(): " + throwable);
            runtimeException.setStackTrace(throwable.getStackTrace());
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Error calling " + string + ".getDirectory(): " + exception);
        }
        throw new RuntimeException("Could not load catalog directory entry: " + astroCatalog.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, List<Catalog> list) throws SAXException, IOException {
        String string = file.getPath();
        FileOutputStream fileOutputStream = null;
        XMLWriter xMLWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            outputFormat.setExpandEmptyElements(false);
            xMLWriter = new XMLWriter((OutputStream)fileOutputStream, outputFormat);
            xMLWriter.startDocument();
            xMLWriter.startDTD("catalogs", PUBLIC_ID, SYSTEM_ID);
            xMLWriter.endDTD();
            AlmaAstroCatXML._saveCatalogs(xMLWriter, list);
            xMLWriter.endDocument();
        }
        finally {
            try {
                xMLWriter.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void _saveCatalogs(XMLWriter xMLWriter, List<Catalog> list) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        AlmaAstroCatXML._addAttr(attributesImpl, "version", VERSION);
        xMLWriter.startElement("", "", "catalogs", (Attributes)attributesImpl);
        ListIterator<Catalog> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Catalog catalog = (Catalog)listIterator.next();
            AlmaAstroCatXML._saveCatalog(xMLWriter, catalog);
        }
        xMLWriter.endElement("", "", "catalogs");
    }

    private static void _saveCatalog(XMLWriter xMLWriter, Catalog catalog) throws SAXException {
        String string;
        if (catalog instanceof AstroCatConfig) {
            return;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        AlmaAstroCatXML._addAttr(attributesImpl, "name", catalog.getName());
        AlmaAstroCatXML._addAttr(attributesImpl, "type", catalog.getType());
        AstroCatalog astroCatalog = null;
        if (catalog instanceof AstroCatalog) {
            astroCatalog = (AstroCatalog)catalog;
            string = astroCatalog.getURLPath();
            if (string != null) {
                AlmaAstroCatXML._addAttr(attributesImpl, "path", string);
            }
        } else if (catalog instanceof CatalogDirectory) {
            AlmaAstroCatXML._addAttr(attributesImpl, "class", catalog.getClass().getName());
        }
        xMLWriter.startElement("", "", "catalog", (Attributes)attributesImpl);
        if (catalog instanceof PlotableCatalog && (string = (PlotableCatalog)catalog).isSymbolsEdited()) {
            AlmaAstroCatXML._saveSymbols(xMLWriter, string.getSymbols());
        }
        xMLWriter.endElement("", "", "catalog");
    }

    private static void _saveSymbols(XMLWriter xMLWriter, TablePlotSymbol[] tablePlotSymbolArray) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        xMLWriter.startElement("", "", "symbols", (Attributes)attributesImpl);
        for (int i = 0; i < tablePlotSymbolArray.length; ++i) {
            AlmaAstroCatXML._saveSymbol(xMLWriter, tablePlotSymbolArray[i]);
        }
        xMLWriter.endElement("", "", "symbols");
    }

    private static void _saveSymbol(XMLWriter xMLWriter, TablePlotSymbol tablePlotSymbol) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        AlmaAstroCatXML._addAttr(attributesImpl, "name", tablePlotSymbol.getName());
        AlmaAstroCatXML._addAttr(attributesImpl, "description", tablePlotSymbol.getDescription());
        AlmaAstroCatXML._addAttr(attributesImpl, "columnsUsed", TclUtil.makeList((String[])tablePlotSymbol.getColNames()));
        AlmaAstroCatXML._addAttr(attributesImpl, "shape", tablePlotSymbol.getShapeName());
        AlmaAstroCatXML._addAttr(attributesImpl, "color", tablePlotSymbol.getColorName(tablePlotSymbol.getFg()));
        AlmaAstroCatXML._addAttr(attributesImpl, "condition", tablePlotSymbol.getCond());
        AlmaAstroCatXML._addAttr(attributesImpl, "ratio", tablePlotSymbol.getRatio());
        AlmaAstroCatXML._addAttr(attributesImpl, "angle", tablePlotSymbol.getAngle());
        AlmaAstroCatXML._addAttr(attributesImpl, "label", tablePlotSymbol.getLabel());
        AlmaAstroCatXML._addAttr(attributesImpl, "size", tablePlotSymbol.getSize());
        AlmaAstroCatXML._addAttr(attributesImpl, "units", tablePlotSymbol.getUnits());
        int n = tablePlotSymbol.getRaCol();
        int n2 = tablePlotSymbol.getDecCol();
        double d = tablePlotSymbol.getEquinox();
        if (n != 1) {
            AlmaAstroCatXML._addAttr(attributesImpl, "raCol", String.valueOf(n));
        }
        if (n2 != 2) {
            AlmaAstroCatXML._addAttr(attributesImpl, "decCol", String.valueOf(n2));
        }
        if (d != 2000.0) {
            AlmaAstroCatXML._addAttr(attributesImpl, "equinox", String.valueOf(d));
        }
        xMLWriter.startElement("", "", "symbol", (Attributes)attributesImpl);
        xMLWriter.endElement("", "", "symbol");
    }

    private static void _addAttr(AttributesImpl attributesImpl, String string, String string2) {
        if (string2 != null) {
            attributesImpl.addAttribute("", "", string, CDATA, string2);
        }
    }

    public static void main(String[] stringArray) {
        try {
            URL uRL = Resources.getResource((String)"conf/AstroCat.xml");
            AlmaAstroCatXML almaAstroCatXML = new AlmaAstroCatXML();
            almaAstroCatXML.parse(uRL);
            System.out.println("Parsed conf/AstroCat.xml and found " + almaAstroCatXML.getCatalogs().size() + " catalogs");
            String string = System.getProperty("file.separator");
            File file = new File("test" + string + "test.xml");
            File file2 = file.getParentFile();
            if (!file2.isDirectory()) {
                file2.mkdirs();
            }
            AlmaAstroCatXML.save(file, almaAstroCatXML.getCatalogs());
            System.out.println("Saved results to " + file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.out.println("Test passed");
    }
}

