/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.RectanglePatternT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.annotations.RectanglePatternI;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.data.RectanglePatternData;
import alma.obsprep.ot.editors.spatialvisual.subform.MosaicParameters;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;

public class RectanglePattern
extends RectanglePatternData
implements RectanglePatternI {
    private final MosaicParameters mosaicParameters = new MosaicParameters();

    public RectanglePattern(RectanglePatternT rectanglePatternT) {
        super(rectanglePatternT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setType(TYPE_RECTANGLE);
        this.getPatternCenterCoordinates().setType(SkyCoordinates.TYPE_RELATIVE);
        this.getPatternCenterCoordinates().getLatitude().setUnit(Angle.UNIT_ARCSEC);
        this.getPatternCenterCoordinates().getLongitude().setUnit(Angle.UNIT_ARCSEC);
        if (this.getScanDirection() == null) {
            this.setScanDirection(SCANDIRECTION_LONGITUDE);
        }
        this.getLatitudeLength().setUnit(Angle.UNIT_ARCSEC);
        this.getLongitudeLength().setUnit(Angle.UNIT_ARCSEC);
        this.getOrthogonalStep().setUnit(Angle.UNIT_ARCSEC);
    }

    @Override
    public Angle getRotationAngle() {
        return (Angle)this.getOrientation().multiply(-1.0);
    }

    @Override
    public void setRotationAngle(Angle angle) {
        this.getOrientation().setContentAndUnit(-angle.getContent(), angle.getUnit());
    }

    @Override
    public MosaicParameters getMosaicParameters() {
        return this.mosaicParameters;
    }

    public void setDefaultMosaicParameters() {
        FieldSource fieldSource = (FieldSource)this.getParent();
        if (fieldSource != null) {
            Frequency frequency = fieldSource.getSpatialVisualParameters().getFrequency();
            this.getMosaicParameters().getFrequency().setContentAndUnit((ValueUnitPair)frequency);
            this.getMosaicParameters().setAntenna(fieldSource.getSpatialVisualParameters().getAntenna());
        }
    }

    @Override
    public SkyCoordinates getFieldCenterCoordinates() {
        return this.getPatternCenterCoordinates();
    }

    @Override
    public boolean isRectanglePattern() {
        return true;
    }

    @Override
    public Angle getSpacing() {
        return this.getOrthogonalStep();
    }

    @Override
    public Frequency getObservingFrequency() {
        MosaicParameters mosaicParameters = this.getMosaicParameters();
        if (this.getMosaicParameters() != null) {
            return mosaicParameters.getFrequency().deepCopy();
        }
        return null;
    }

    public int getNumberOfPointings() {
        return 1;
    }

    public Time getSubscanDuration() {
        FieldSource fieldSource = (FieldSource)this.getParent();
        if (fieldSource == null) {
            return null;
        }
        return fieldSource.getSingleSubscanDuration();
    }

    public AngularVelocity getScanVelocity() {
        Angle angle;
        String string = this.getScanDirection();
        if (string.equals(SCANDIRECTION_LATITUDE)) {
            angle = this.getLatitudeLength();
        } else if (string.equals(SCANDIRECTION_LONGITUDE)) {
            angle = this.getLongitudeLength();
        } else {
            throw new IllegalArgumentException("Unexpected scanDirction : " + string);
        }
        Time time = this.getSubscanDuration();
        AngularVelocity angularVelocity = null;
        if (time != null) {
            double d = angle.getContentInUnits(Angle.UNIT_ARCSEC);
            double d2 = time.getContentInUnits(Time.UNIT_S);
            double d3 = d / d2;
            angularVelocity = AngularVelocity.createAngularVelocity((double)d3, (String)AngularVelocity.UNIT_ARCSEC_S);
        }
        return angularVelocity;
    }

    @Override
    public Array getArray() {
        return Array.ARRAY_TP;
    }

    public void setLongitudeLength(UserAngle userAngle) {
        Angle angle = Angle.createAngle((double)userAngle.getContentInUnits(UserAngle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
        this.setLongitudeLength(angle);
    }

    public void setLatitudeLength(UserAngle userAngle) {
        Angle angle = Angle.createAngle((double)userAngle.getContentInUnits(UserAngle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
        this.setLatitudeLength(angle);
    }

    public void setOrthogonalStep(UserAngle userAngle) {
        Angle angle = Angle.createAngle((double)userAngle.getContentInUnits(UserAngle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
        this.setOrthogonalStep(angle);
    }

    public int getRowCount() {
        double d = this.getLongitudeLength().isLessThan((AbstractDoubleWithUnit)this.getLatitudeLength()) ? this.getLongitudeLength().getContentInUnits(Longitude.UNIT_ARCSEC) : this.getLatitudeLength().getContentInUnits(Latitude.UNIT_ARCSEC);
        double d2 = this.getOrthogonalStep().getContentInUnits(Angle.UNIT_ARCSEC);
        return (int)Math.floor(d / d2) + 2;
    }
}

