/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.entity.xmlbinding.schedblock.PointingPatternT;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.PointingPatternI;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.data.PointingPatternData;
import alma.obsprep.util.astro.CoordsSystemConversionHelper;
import alma.obsprep.util.astro.PointingCoordsConverter;
import alma.valuetypes.SkyCoordinates;
import java.util.Arrays;
import java.util.List;

public class PointingPattern
extends PointingPatternData
implements PointingPatternI {
    private boolean derivedFromRectangle = false;
    private Boolean isOffsetPointingPattern = null;
    private String offsetAngleUnit = null;

    public boolean isDerivedFromRectanglePointingPattern() {
        return this.derivedFromRectangle;
    }

    public PointingPattern(PointingPatternT pointingPatternT) {
        super(pointingPatternT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setType(TYPE_POINT);
    }

    @Override
    public SkyCoordinates getFieldCenterCoordinates() {
        return null;
    }

    @Override
    public boolean isPointingPattern() {
        return true;
    }

    @Override
    public boolean isMosaic() {
        return this.getIsMosaic();
    }

    public int getNumberOfPointings() {
        return this.getPhaseCenterCoordinatesCount();
    }

    @Override
    public int indexOf(SkyCoordinates skyCoordinates) {
        List<SkyCoordinates> list = Arrays.asList(this.getPhaseCenterCoordinates());
        return list.indexOf(skyCoordinates);
    }

    @Override
    public SkyCoordinates getSourceCoordinates() {
        FieldSource fieldSource = (FieldSource)this.getParent();
        if (fieldSource == null) {
            Log.logger((Object)this).severe("Unexpected Error : can not identify the parent FieldSource");
            return null;
        }
        return fieldSource.getSourceCoordinates();
    }

    @Override
    public void originCoordinatesSystemUpdated() {
        this.matchSystemToOrigin();
    }

    @Override
    public void setOffsetPointingPattern(boolean bl) {
        this.isOffsetPointingPattern = bl;
    }

    @Override
    public boolean isOffsetPointingPattern() {
        int n;
        boolean bl = this.isOffsetPointingPattern == null ? ((n = this.getPhaseCenterCoordinatesCount()) == 0 ? true : this.getPhaseCenterCoordinates()[0].isOffsetCoordinates()) : this.isOffsetPointingPattern;
        return bl;
    }

    @Override
    public boolean isAbsolutePointingPattern() {
        return !this.isOffsetPointingPattern();
    }

    @Override
    public String getOffsetAngleUnit() {
        SkyCoordinates skyCoordinates;
        if (this.offsetAngleUnit == null && this.getPhaseCenterCoordinatesCount() > 0 && (skyCoordinates = this.getPhaseCenterCoordinates(0)).isOffsetCoordinates()) {
            this.offsetAngleUnit = skyCoordinates.getLatitude().getUnit();
        }
        return this.offsetAngleUnit != null ? this.offsetAngleUnit : DEFAULT_OFFSETANGLE_UNIT;
    }

    public void matchSystemToOrigin() {
        SkyCoordinates skyCoordinates = this.getOrigin();
        if (skyCoordinates == null) {
            Log.logger((Object)this).warning("Can not determine the origin of offset coordinates");
            return;
        }
        String string = skyCoordinates.getSystem();
        if (!CoordsSystemConversionHelper.isSupportedSystem(string)) {
            for (SkyCoordinates skyCoordinates2 : this.getPhaseCenterCoordinates()) {
                skyCoordinates2.setSystem(string);
            }
            return;
        }
        PointingCoordsConverter pointingCoordsConverter = new PointingCoordsConverter(skyCoordinates);
        if (this.isOffsetPointingPattern()) {
            for (SkyCoordinates skyCoordinates3 : this.getPhaseCenterCoordinates()) {
                pointingCoordsConverter.matchSystemToOrigin(skyCoordinates3);
            }
        } else {
            for (SkyCoordinates skyCoordinates4 : this.getPhaseCenterCoordinates()) {
                skyCoordinates4.convertToSystem(string);
            }
        }
    }

    public void setDerivedFromRectangle(boolean bl) {
        this.derivedFromRectangle = bl;
    }

    public void setIsOffsetPointingPattern(Boolean bl) {
        this.isOffsetPointingPattern = bl;
    }

    @Override
    public void setOffsetAngleUnit(String string) {
        this.offsetAngleUnit = string;
    }
}

