/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.CorrBits;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrFraction;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.SpectralAverage;
import alma.obsprep.bo.obsproject.AdvancedWindowSetup;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.ConfigModeDecoder;
import alma.obsprep.bo.schedblock.ConfigModeDecoderImpl;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class CorrConfigMode
implements Comparable<CorrConfigMode> {
    static SortedSet<CorrConfigMode> modeSet;
    static TreeMap<Integer, CorrConfigMode> modeMap;
    static ConfigModeDecoder decoder;
    public static final int INVALID_CORRCONFIGMODE_NUMBER = -1;
    public static final CorrConfigMode INVALID_CORRCONFIGMODE;
    public static final double HANNING_SMOOTHING_FACTOR = 2.0;
    private final int mode;
    private final Frequency nominalBandwidth;
    private final Frequency acaChProfBandwidth;
    private final int channels;
    private final int acaChProfChannels;
    private final CorrBits bits;
    private final boolean oversampling;
    private final CorrPolarization polarization;
    private final CorrFilter filter;
    private final double blEfficiency;
    private final double acaEfficiency;
    private static final Frequency BW31MHZ;

    private CorrConfigMode(int n, double d, int n2, double d2, int n3, ConfigModeDecoder.eBits eBits2, boolean bl, ConfigModeDecoder.ePolarization ePolarization2, ConfigModeDecoder.eFilterMode eFilterMode2, double d3, double d4) {
        this.mode = n;
        this.nominalBandwidth = Frequency.createFrequencyGHZ(d);
        this.acaChProfBandwidth = Frequency.createFrequencyGHZ(d2);
        this.channels = n2;
        this.acaChProfChannels = n3;
        this.bits = CorrBits.getCorrBits(eBits2);
        this.oversampling = bl;
        this.polarization = CorrPolarization.getCorrPolarization(ePolarization2);
        this.filter = CorrFilter.getCorrFilter(eFilterMode2);
        this.blEfficiency = d3;
        this.acaEfficiency = d4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + this.mode + "] ").append("BW=" + this.nominalBandwidth + "MHz,").append("CH=" + this.channels + ",").append("bits=" + this.bits + ",").append("OS=" + this.oversampling + ",").append("PP=" + this.polarization + ",").append("filter=" + this.filter);
        return stringBuffer.toString();
    }

    public static CorrConfigMode fromString(String string) {
        Integer n;
        CorrConfigMode corrConfigMode = null;
        if (string == null) {
            return null;
        }
        try {
            n = Integer.parseInt(string.substring(1, string.indexOf("]")));
        }
        catch (NumberFormatException numberFormatException) {
            return corrConfigMode;
        }
        corrConfigMode = CorrConfigMode.getCorrConfigMode(n);
        if (corrConfigMode == INVALID_CORRCONFIGMODE) {
            return null;
        }
        return corrConfigMode;
    }

    @Override
    public int compareTo(CorrConfigMode corrConfigMode) {
        Integer n = this.mode;
        return n.compareTo(corrConfigMode.getMode());
    }

    public static CorrConfigMode getCorrConfigMode(int n) {
        if (modeMap.keySet().contains(n)) {
            return modeMap.get(n);
        }
        return INVALID_CORRCONFIGMODE;
    }

    public static Set<CorrConfigMode> getAllModes() {
        return modeSet;
    }

    public boolean isValid() {
        return this != INVALID_CORRCONFIGMODE;
    }

    public Frequency getEffectiveBandwidth() {
        return this.getEffectiveBandwidth(false);
    }

    public Frequency getEffectiveBandwidth(boolean bl) {
        if (bl) {
            return this.acaChProfBandwidth;
        }
        double d = this.nominalBandwidth.getContentInUnits(this.nominalBandwidth.getUnit()) * 0.9375;
        return Frequency.createFrequency((double)d, (String)this.nominalBandwidth.getUnit());
    }

    public int getNominalChannels() {
        return this.channels;
    }

    public int getEffectiveChannels() {
        return this.getEffectiveChannels(false);
    }

    public int getEffectiveChannels(boolean bl) {
        if (bl) {
            return this.acaChProfChannels;
        }
        double d = 1.0;
        if (this.filter == CorrFilter.TFB) {
            d = 0.9375;
        }
        return (int)Math.round((double)this.channels * d);
    }

    public Frequency getResolution() {
        return Frequency.createFrequencyGHZ(this.nominalBandwidth.getContentInGHz() / (double)this.channels);
    }

    @Deprecated
    public Frequency getResolutionSmoothed() {
        return (Frequency)this.getResolution().multiply(2.0);
    }

    public Frequency getEffectiveResolution(AdvancedWindowSetup advancedWindowSetup) {
        Frequency frequency = this.getResolution();
        SpectralAverage spectralAverage = SpectralAverage.getValue(advancedWindowSetup.getSmoothingFactor());
        try {
            frequency = (Frequency)frequency.multiply(spectralAverage.getResolutionScalingFactor(advancedWindowSetup.getSmoothingFunction()));
        }
        catch (SpectralAverage.UnknownWindowingFunctionException unknownWindowingFunctionException) {
            return frequency;
        }
        return frequency;
    }

    public boolean isOversampling() {
        return this.oversampling;
    }

    public double getBLEfficiency() {
        return this.blEfficiency * 0.96;
    }

    public double getACAEfficiency() {
        return this.acaEfficiency * 0.96;
    }

    public CorrFraction getFraction() {
        if (this.filter == CorrFilter.TDM) {
            return CorrFraction.FULL;
        }
        if (this.isSensitivityImproveMode()) {
            return CorrFraction.FULL;
        }
        try {
            int n = (int)decoder.getChannels(this.mode);
            int n2 = this.polarization.getProductsCount();
            int n3 = 8192 / (n * n2);
            switch (n3) {
                case 1: {
                    return CorrFraction.FULL;
                }
                case 2: {
                    return CorrFraction.HALF;
                }
                case 4: {
                    return CorrFraction.QUARTER;
                }
                case 8: {
                    return CorrFraction.EIGHTH;
                }
                case 16: {
                    return CorrFraction.SIXTEENTH;
                }
                case 32: {
                    return CorrFraction.THIRTYSECOND;
                }
            }
            return null;
        }
        catch (ConfigModeDecoder.ConfigModeException configModeException) {
            return null;
        }
    }

    public boolean isSensitivityImproveMode() {
        switch (this.filter) {
            case TDM: {
                return !this.bits.equals((Object)CorrBits.B2x2);
            }
            case TFB: {
                if (this.bits != CorrBits.B2x2) {
                    return true;
                }
                if (this.nominalBandwidth.isEqual((AbstractDoubleWithUnit)BW31MHZ)) {
                    return false;
                }
                return this.oversampling;
            }
        }
        return false;
    }

    public String formatWindowDescription(Frequency frequency, AdvancedWindowSetup advancedWindowSetup) {
        Object object;
        if (advancedWindowSetup == null) {
            return "";
        }
        String string = String.format("%12s", this.formatBandwidth());
        String string2 = String.format("%8s", this.formatEffectiveResolution(advancedWindowSetup));
        String string3 = "";
        String string4 = "";
        try {
            object = (SpectralSetupParameters)advancedWindowSetup.getParent().getParent();
            ReceiverBand receiverBand = null;
            if (object != null) {
                receiverBand = ((SpectralSetupParameters)((Object)object)).getReceiverBand();
            }
            if (receiverBand != null) {
                Speed speed = Speed.getSpeedResolution(this.getEffectiveBandwidth(), frequency);
                string3 = String.format("%s", this.formatSpeed(speed, 4, 0));
                string4 = String.format("%s", this.formatEffectiveVelocity(frequency, advancedWindowSetup));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(string);
        if (string3.length() > 0) {
            ((StringBuffer)object).append("(").append(string3).append(")");
        }
        ((StringBuffer)object).append(", ");
        ((StringBuffer)object).append(string2);
        if (string4.length() > 0) {
            ((StringBuffer)object).append("(").append(string4).append(")");
        }
        return ((StringBuffer)object).toString();
    }

    public static String formatChannel(int n) {
        return String.format("%d", n);
    }

    public String formatBandwidth() {
        return CorrConfigMode.formatBandwidth(this.getEffectiveBandwidth().getContentInMHz());
    }

    public static String formatBandwidth(Frequency frequency) {
        return CorrConfigMode.formatBandwidth(frequency.getContentInMHz());
    }

    public static String formatBandwidth(double d) {
        return TextUtils.format(Frequency.createFrequencyMHZ(d), 3, 3);
    }

    public static String formatResolution(Frequency frequency) {
        return CorrConfigMode.formatResolution(frequency.getContentInMHz());
    }

    public static String formatResolution(double d) {
        return TextUtils.format(Frequency.createFrequencyMHZ(d).convertToFriendlyUnit(), 3, 3);
    }

    public String formatEffectiveResolution(AdvancedWindowSetup advancedWindowSetup) {
        return CorrConfigMode.formatResolution(this.getEffectiveResolution(advancedWindowSetup).getContentInMHz());
    }

    public String formatEffectiveVelocity(Frequency frequency, AdvancedWindowSetup advancedWindowSetup) {
        Speed speed = Speed.getSpeedResolution(this.getEffectiveResolution(advancedWindowSetup), frequency);
        return this.formatSpeed(speed, 2, 3);
    }

    public String formatSpeed(Speed speed, int n, int n2) {
        return TextUtils.format(speed, n, n2);
    }

    public int getMode() {
        return this.mode;
    }

    public Frequency getNominalBandwidth() {
        return this.nominalBandwidth;
    }

    public CorrBits getBits() {
        return this.bits;
    }

    public CorrPolarization getPolarization() {
        return this.polarization;
    }

    public CorrFilter getFilter() {
        return this.filter;
    }

    static {
        InitServices.initModelSupportClasses();
        modeSet = new TreeSet<CorrConfigMode>();
        modeMap = new TreeMap();
        decoder = new ConfigModeDecoderImpl();
        for (int n : decoder.getKnownModes()) {
            try {
                double d = decoder.getNominalBandwidthGHz(n);
                double d2 = decoder.getNominalBandwidthGHz(n, true);
                int n2 = (int)decoder.getChannels(n);
                int n3 = (int)decoder.getChannels(n, true);
                ConfigModeDecoder.eBits eBits2 = decoder.getBits(n);
                boolean bl = decoder.isOversampled(n);
                ConfigModeDecoder.ePolarization ePolarization2 = decoder.getPolarizationProducts(n);
                ConfigModeDecoder.eFilterMode eFilterMode2 = decoder.getFilterMode(n);
                double d3 = decoder.getBLEfficiency(n);
                double d4 = decoder.getACAEfficiency(n);
                CorrConfigMode corrConfigMode = new CorrConfigMode(n, d, n2, d2, n3, eBits2, bl, ePolarization2, eFilterMode2, d3, d4);
                modeSet.add(corrConfigMode);
                modeMap.put(n, corrConfigMode);
            }
            catch (ConfigModeDecoder.ConfigModeException configModeException) {
                Log.Logger logger = Log.logger(CorrConfigMode.class);
                logger.severe(configModeException.getMessage());
            }
        }
        INVALID_CORRCONFIGMODE = new CorrConfigMode(-1, 0.0, 0, 0.0, 0, null, false, null, ConfigModeDecoder.eFilterMode.FILTER_TDM, 0.0, 0.0);
        BW31MHZ = Frequency.createFrequencyMHZ(31.25);
    }
}

