/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.ScienceSpectralWindowFactory;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.valuetypes.Frequency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;

public class SpectralSetupFactory {
    public static void createB2BWindows(@NonNull Optional<SpectralSetupParameters> optional, @NonNull List<Frequency> list) {
        if (optional == null) {
            throw new NullPointerException("baseSSP is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("spwCentreFrequencies is marked non-null but is null");
        }
        SpectralSetupParameters spectralSetupParameters = optional.isPresent() ? optional.get() : SpectralSetupParameters.createSpectralSetupParameters();
        Stream.of(spectralSetupParameters.getAbstractScienceSpectralWindow()).forEach(abstractScienceSpectralWindow -> spectralSetupParameters.removeAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)abstractScienceSpectralWindow));
        int n = 0;
        for (Frequency frequency : list) {
            SpectralSetupFactory.createSingleB2BSpectralLineWindow(spectralSetupParameters, n++, frequency);
        }
    }

    private static ScienceSpectralWindow createSingleB2BSpectralLineWindow(@NonNull SpectralSetupParameters spectralSetupParameters, int n, @NonNull Frequency frequency) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("b2bSSP is marked non-null but is null");
        }
        if (frequency == null) {
            throw new NullPointerException("centreFrequency is marked non-null but is null");
        }
        ScienceSpectralWindow[] scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindowGroup(n);
        Stream.of(scienceSpectralWindowArray).forEach(scienceSpectralWindow -> spectralSetupParameters.removeAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow)));
        ScienceSpectralWindow scienceSpectralWindow2 = ScienceSpectralWindowFactory.createSingleB2BSpectralLineWindow();
        scienceSpectralWindow2.getCenterFrequency().setContentAndUnit((ValueUnitPair)frequency);
        spectralSetupParameters.addScienceSpectralWindow(n, 0, scienceSpectralWindow2);
        return scienceSpectralWindow2;
    }
}

