/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.configuration;

import alma.observatorycharacteristics.configuration.Angle;
import alma.observatorycharacteristics.configuration.AntennaAssignment;
import alma.observatorycharacteristics.configuration.ArrayConfigurationType;
import alma.observatorycharacteristics.configuration.ArrayMultiplierType;
import alma.observatorycharacteristics.configuration.DataRateLimitType;
import alma.observatorycharacteristics.configuration.Frequency;
import alma.observatorycharacteristics.configuration.FrequencyList;
import alma.observatorycharacteristics.configuration.OTTime;
import alma.observatorycharacteristics.configuration.ProposalType;
import alma.observatorycharacteristics.configuration.ScienceKeywordGroup;
import alma.observatorycharacteristics.configuration.VLBIFrequencyBands;
import alma.observatorycharacteristics.configuration.ValidBandTag;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"siteCharacteristics", "telescopePolicies", "telescopeCapabilities", "scheduleBlockConfiguration", "arrayConfigurations", "shadowing"})
@XmlRootElement(name="OTConfiguration", namespace="http://www.stfc.ac.uk/OTConfiguration")
public class OTConfiguration {
    @XmlElement(name="SiteCharacteristics", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
    protected SiteCharacteristics siteCharacteristics;
    @XmlElement(name="TelescopePolicies", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
    protected TelescopePolicies telescopePolicies;
    @XmlElement(name="TelescopeCapabilities", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
    protected TelescopeCapabilities telescopeCapabilities;
    @XmlElement(name="ScheduleBlockConfiguration", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
    protected ScheduleBlockConfiguration scheduleBlockConfiguration;
    @XmlElement(name="ArrayConfigurations", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
    protected ArrayConfigurations arrayConfigurations;
    @XmlElement(name="Shadowing", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
    protected Shadowing shadowing;

    public SiteCharacteristics getSiteCharacteristics() {
        return this.siteCharacteristics;
    }

    public void setSiteCharacteristics(SiteCharacteristics siteCharacteristics) {
        this.siteCharacteristics = siteCharacteristics;
    }

    public TelescopePolicies getTelescopePolicies() {
        return this.telescopePolicies;
    }

    public void setTelescopePolicies(TelescopePolicies telescopePolicies) {
        this.telescopePolicies = telescopePolicies;
    }

    public TelescopeCapabilities getTelescopeCapabilities() {
        return this.telescopeCapabilities;
    }

    public void setTelescopeCapabilities(TelescopeCapabilities telescopeCapabilities) {
        this.telescopeCapabilities = telescopeCapabilities;
    }

    public ScheduleBlockConfiguration getScheduleBlockConfiguration() {
        return this.scheduleBlockConfiguration;
    }

    public void setScheduleBlockConfiguration(ScheduleBlockConfiguration scheduleBlockConfiguration) {
        this.scheduleBlockConfiguration = scheduleBlockConfiguration;
    }

    public ArrayConfigurations getArrayConfigurations() {
        return this.arrayConfigurations;
    }

    public void setArrayConfigurations(ArrayConfigurations arrayConfigurations) {
        this.arrayConfigurations = arrayConfigurations;
    }

    public Shadowing getShadowing() {
        return this.shadowing;
    }

    public void setShadowing(Shadowing shadowing) {
        this.shadowing = shadowing;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"isVLBISpectralLineEnabled", "nominalSBLength", "tpNominalSBLength", "integrationTimeForSolarSource", "tpMaxTOSPerSB", "ddtCycleNumber", "cycleNumber", "supplementalCallEnabled", "supplementalCallCycleNumber", "scienceCategories", "standardProposalTypes", "observatoryProposalTypes", "minTimeOnSource", "maxNoOfPointings", "warningNoOfPointings", "maxTimeOfStandardProject", "maxWordsInAbstract", "maxCharactersInAbstract", "maxCharactersInTJField", "minCharactersInTJField", "maxTextAreaCharacters", "maxScienceCasePages", "maxManagementPlanPages", "maxScienceCasePagesLargeProgram", "maxScienceGoals", "maxTuningsPerScienceGoal", "maxSourcesPerScienceGoal", "maxConeDiameter", "maxConeDiameterLongBaseline", "dataRateConstraints", "minTimeOnSourcePerSB", "minTimeForPolarisationSG", "minAdvisedTimeMargin", "scienceKeywords", "minLargeProgramTimeWithSACA", "minLargeProgramTimeNoSACA", "maxPointingSeparationFromSourceCoordinate", "tjRequired", "sourceParametersRequired", "nominalTotalToScienceRatio", "nominalTotalToScienceRatioForMultipleTunings", "nominalTotalToScienceRatioForFullPolarization", "nominalTotalToScienceRatioForACA7M", "nominalTotalToScienceRatioForWalsh"})
    public static class TelescopePolicies {
        @XmlElement(namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected boolean isVLBISpectralLineEnabled;
        @XmlElement(name="NominalSBLength", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected OTTime nominalSBLength;
        @XmlElement(name="TPNominalSBLength", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected OTTime tpNominalSBLength;
        @XmlElement(name="IntegrationTimeForSolarSource", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected OTTime integrationTimeForSolarSource;
        @XmlElement(name="TPMaxTOSPerSB", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected OTTime tpMaxTOSPerSB;
        @XmlElement(name="DDTCycleNumber", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected String ddtCycleNumber;
        @XmlElement(name="CycleNumber", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected String cycleNumber;
        @XmlElement(name="SupplementalCallEnabled", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected boolean supplementalCallEnabled;
        @XmlElement(name="SupplementalCallCycleNumber", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected String supplementalCallCycleNumber;
        @XmlElement(name="ScienceCategories", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected ScienceCategories scienceCategories;
        @XmlElement(name="StandardProposalTypes", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected StandardProposalTypes standardProposalTypes;
        @XmlElement(name="ObservatoryProposalTypes", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected ObservatoryProposalTypes observatoryProposalTypes;
        @XmlElement(name="MinTimeOnSource", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected OTTime minTimeOnSource;
        @XmlElement(name="MaxNoOfPointings", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger maxNoOfPointings;
        @XmlElement(name="WarningNoOfPointings", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger warningNoOfPointings;
        @XmlElement(name="MaxTimeOfStandardProject", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected OTTime maxTimeOfStandardProject;
        @XmlElement(name="MaxWordsInAbstract", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger maxWordsInAbstract;
        @XmlElement(name="MaxCharactersInAbstract", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger maxCharactersInAbstract;
        @XmlElement(name="MaxCharactersInTJField", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger maxCharactersInTJField;
        @XmlElement(name="MinCharactersInTJField", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger minCharactersInTJField;
        @XmlElement(name="MaxTextAreaCharacters", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger maxTextAreaCharacters;
        @XmlElement(name="MaxScienceCasePages", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger maxScienceCasePages;
        @XmlElement(name="MaxManagementPlanPages", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger maxManagementPlanPages;
        @XmlElement(name="MaxScienceCasePagesLargeProgram", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger maxScienceCasePagesLargeProgram;
        @XmlElement(name="MaxScienceGoals", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger maxScienceGoals;
        @XmlElement(name="MaxTuningsPerScienceGoal", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger maxTuningsPerScienceGoal;
        @XmlElement(name="MaxSourcesPerScienceGoal", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger maxSourcesPerScienceGoal;
        @XmlElement(name="MaxConeDiameter", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected Angle maxConeDiameter;
        @XmlElement(name="MaxConeDiameterLongBaseline", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected Angle maxConeDiameterLongBaseline;
        @XmlElement(name="DataRateConstraints", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected DataRateConstraints dataRateConstraints;
        @XmlElement(name="MinTimeOnSourcePerSB", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected OTTime minTimeOnSourcePerSB;
        @XmlElement(name="MinTimeForPolarisationSG", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected OTTime minTimeForPolarisationSG;
        @XmlElement(name="MinAdvisedTimeMargin", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected OTTime minAdvisedTimeMargin;
        @XmlElement(name="ScienceKeywords", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected ScienceKeywords scienceKeywords;
        @XmlElement(name="MinLargeProgramTimeWithSACA", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected OTTime minLargeProgramTimeWithSACA;
        @XmlElement(name="MinLargeProgramTimeNoSACA", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected OTTime minLargeProgramTimeNoSACA;
        @XmlElement(name="MaxPointingSeparationFromSourceCoordinate", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected Angle maxPointingSeparationFromSourceCoordinate;
        @XmlElement(name="TJRequired", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected boolean tjRequired;
        @XmlElement(name="SourceParametersRequired", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected boolean sourceParametersRequired;
        @XmlElement(name="NominalTotalToScienceRatio", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected double nominalTotalToScienceRatio;
        @XmlElement(name="NominalTotalToScienceRatioForMultipleTunings", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected double nominalTotalToScienceRatioForMultipleTunings;
        @XmlElement(name="NominalTotalToScienceRatioForFullPolarization", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected double nominalTotalToScienceRatioForFullPolarization;
        @XmlElement(name="NominalTotalToScienceRatioForACA7m", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected double nominalTotalToScienceRatioForACA7M;
        @XmlElement(name="NominalTotalToScienceRatioForWalsh", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected double nominalTotalToScienceRatioForWalsh;

        public boolean isIsVLBISpectralLineEnabled() {
            return this.isVLBISpectralLineEnabled;
        }

        public void setIsVLBISpectralLineEnabled(boolean bl) {
            this.isVLBISpectralLineEnabled = bl;
        }

        public OTTime getNominalSBLength() {
            return this.nominalSBLength;
        }

        public void setNominalSBLength(OTTime oTTime) {
            this.nominalSBLength = oTTime;
        }

        public OTTime getTPNominalSBLength() {
            return this.tpNominalSBLength;
        }

        public void setTPNominalSBLength(OTTime oTTime) {
            this.tpNominalSBLength = oTTime;
        }

        public OTTime getIntegrationTimeForSolarSource() {
            return this.integrationTimeForSolarSource;
        }

        public void setIntegrationTimeForSolarSource(OTTime oTTime) {
            this.integrationTimeForSolarSource = oTTime;
        }

        public OTTime getTPMaxTOSPerSB() {
            return this.tpMaxTOSPerSB;
        }

        public void setTPMaxTOSPerSB(OTTime oTTime) {
            this.tpMaxTOSPerSB = oTTime;
        }

        public String getDDTCycleNumber() {
            return this.ddtCycleNumber;
        }

        public void setDDTCycleNumber(String string) {
            this.ddtCycleNumber = string;
        }

        public String getCycleNumber() {
            return this.cycleNumber;
        }

        public void setCycleNumber(String string) {
            this.cycleNumber = string;
        }

        public boolean isSupplementalCallEnabled() {
            return this.supplementalCallEnabled;
        }

        public void setSupplementalCallEnabled(boolean bl) {
            this.supplementalCallEnabled = bl;
        }

        public String getSupplementalCallCycleNumber() {
            return this.supplementalCallCycleNumber;
        }

        public void setSupplementalCallCycleNumber(String string) {
            this.supplementalCallCycleNumber = string;
        }

        public ScienceCategories getScienceCategories() {
            return this.scienceCategories;
        }

        public void setScienceCategories(ScienceCategories scienceCategories) {
            this.scienceCategories = scienceCategories;
        }

        public StandardProposalTypes getStandardProposalTypes() {
            return this.standardProposalTypes;
        }

        public void setStandardProposalTypes(StandardProposalTypes standardProposalTypes) {
            this.standardProposalTypes = standardProposalTypes;
        }

        public ObservatoryProposalTypes getObservatoryProposalTypes() {
            return this.observatoryProposalTypes;
        }

        public void setObservatoryProposalTypes(ObservatoryProposalTypes observatoryProposalTypes) {
            this.observatoryProposalTypes = observatoryProposalTypes;
        }

        public OTTime getMinTimeOnSource() {
            return this.minTimeOnSource;
        }

        public void setMinTimeOnSource(OTTime oTTime) {
            this.minTimeOnSource = oTTime;
        }

        public BigInteger getMaxNoOfPointings() {
            return this.maxNoOfPointings;
        }

        public void setMaxNoOfPointings(BigInteger bigInteger) {
            this.maxNoOfPointings = bigInteger;
        }

        public BigInteger getWarningNoOfPointings() {
            return this.warningNoOfPointings;
        }

        public void setWarningNoOfPointings(BigInteger bigInteger) {
            this.warningNoOfPointings = bigInteger;
        }

        public OTTime getMaxTimeOfStandardProject() {
            return this.maxTimeOfStandardProject;
        }

        public void setMaxTimeOfStandardProject(OTTime oTTime) {
            this.maxTimeOfStandardProject = oTTime;
        }

        public BigInteger getMaxWordsInAbstract() {
            return this.maxWordsInAbstract;
        }

        public void setMaxWordsInAbstract(BigInteger bigInteger) {
            this.maxWordsInAbstract = bigInteger;
        }

        public BigInteger getMaxCharactersInAbstract() {
            return this.maxCharactersInAbstract;
        }

        public void setMaxCharactersInAbstract(BigInteger bigInteger) {
            this.maxCharactersInAbstract = bigInteger;
        }

        public BigInteger getMaxCharactersInTJField() {
            return this.maxCharactersInTJField;
        }

        public void setMaxCharactersInTJField(BigInteger bigInteger) {
            this.maxCharactersInTJField = bigInteger;
        }

        public BigInteger getMinCharactersInTJField() {
            return this.minCharactersInTJField;
        }

        public void setMinCharactersInTJField(BigInteger bigInteger) {
            this.minCharactersInTJField = bigInteger;
        }

        public BigInteger getMaxTextAreaCharacters() {
            return this.maxTextAreaCharacters;
        }

        public void setMaxTextAreaCharacters(BigInteger bigInteger) {
            this.maxTextAreaCharacters = bigInteger;
        }

        public BigInteger getMaxScienceCasePages() {
            return this.maxScienceCasePages;
        }

        public void setMaxScienceCasePages(BigInteger bigInteger) {
            this.maxScienceCasePages = bigInteger;
        }

        public BigInteger getMaxManagementPlanPages() {
            return this.maxManagementPlanPages;
        }

        public void setMaxManagementPlanPages(BigInteger bigInteger) {
            this.maxManagementPlanPages = bigInteger;
        }

        public BigInteger getMaxScienceCasePagesLargeProgram() {
            return this.maxScienceCasePagesLargeProgram;
        }

        public void setMaxScienceCasePagesLargeProgram(BigInteger bigInteger) {
            this.maxScienceCasePagesLargeProgram = bigInteger;
        }

        public BigInteger getMaxScienceGoals() {
            return this.maxScienceGoals;
        }

        public void setMaxScienceGoals(BigInteger bigInteger) {
            this.maxScienceGoals = bigInteger;
        }

        public BigInteger getMaxTuningsPerScienceGoal() {
            return this.maxTuningsPerScienceGoal;
        }

        public void setMaxTuningsPerScienceGoal(BigInteger bigInteger) {
            this.maxTuningsPerScienceGoal = bigInteger;
        }

        public BigInteger getMaxSourcesPerScienceGoal() {
            return this.maxSourcesPerScienceGoal;
        }

        public void setMaxSourcesPerScienceGoal(BigInteger bigInteger) {
            this.maxSourcesPerScienceGoal = bigInteger;
        }

        public Angle getMaxConeDiameter() {
            return this.maxConeDiameter;
        }

        public void setMaxConeDiameter(Angle angle) {
            this.maxConeDiameter = angle;
        }

        public Angle getMaxConeDiameterLongBaseline() {
            return this.maxConeDiameterLongBaseline;
        }

        public void setMaxConeDiameterLongBaseline(Angle angle) {
            this.maxConeDiameterLongBaseline = angle;
        }

        public DataRateConstraints getDataRateConstraints() {
            return this.dataRateConstraints;
        }

        public void setDataRateConstraints(DataRateConstraints dataRateConstraints) {
            this.dataRateConstraints = dataRateConstraints;
        }

        public OTTime getMinTimeOnSourcePerSB() {
            return this.minTimeOnSourcePerSB;
        }

        public void setMinTimeOnSourcePerSB(OTTime oTTime) {
            this.minTimeOnSourcePerSB = oTTime;
        }

        public OTTime getMinTimeForPolarisationSG() {
            return this.minTimeForPolarisationSG;
        }

        public void setMinTimeForPolarisationSG(OTTime oTTime) {
            this.minTimeForPolarisationSG = oTTime;
        }

        public OTTime getMinAdvisedTimeMargin() {
            return this.minAdvisedTimeMargin;
        }

        public void setMinAdvisedTimeMargin(OTTime oTTime) {
            this.minAdvisedTimeMargin = oTTime;
        }

        public ScienceKeywords getScienceKeywords() {
            return this.scienceKeywords;
        }

        public void setScienceKeywords(ScienceKeywords scienceKeywords) {
            this.scienceKeywords = scienceKeywords;
        }

        public OTTime getMinLargeProgramTimeWithSACA() {
            return this.minLargeProgramTimeWithSACA;
        }

        public void setMinLargeProgramTimeWithSACA(OTTime oTTime) {
            this.minLargeProgramTimeWithSACA = oTTime;
        }

        public OTTime getMinLargeProgramTimeNoSACA() {
            return this.minLargeProgramTimeNoSACA;
        }

        public void setMinLargeProgramTimeNoSACA(OTTime oTTime) {
            this.minLargeProgramTimeNoSACA = oTTime;
        }

        public Angle getMaxPointingSeparationFromSourceCoordinate() {
            return this.maxPointingSeparationFromSourceCoordinate;
        }

        public void setMaxPointingSeparationFromSourceCoordinate(Angle angle) {
            this.maxPointingSeparationFromSourceCoordinate = angle;
        }

        public boolean isTJRequired() {
            return this.tjRequired;
        }

        public void setTJRequired(boolean bl) {
            this.tjRequired = bl;
        }

        public boolean isSourceParametersRequired() {
            return this.sourceParametersRequired;
        }

        public void setSourceParametersRequired(boolean bl) {
            this.sourceParametersRequired = bl;
        }

        public double getNominalTotalToScienceRatio() {
            return this.nominalTotalToScienceRatio;
        }

        public void setNominalTotalToScienceRatio(double d) {
            this.nominalTotalToScienceRatio = d;
        }

        public double getNominalTotalToScienceRatioForMultipleTunings() {
            return this.nominalTotalToScienceRatioForMultipleTunings;
        }

        public void setNominalTotalToScienceRatioForMultipleTunings(double d) {
            this.nominalTotalToScienceRatioForMultipleTunings = d;
        }

        public double getNominalTotalToScienceRatioForFullPolarization() {
            return this.nominalTotalToScienceRatioForFullPolarization;
        }

        public void setNominalTotalToScienceRatioForFullPolarization(double d) {
            this.nominalTotalToScienceRatioForFullPolarization = d;
        }

        public double getNominalTotalToScienceRatioForACA7M() {
            return this.nominalTotalToScienceRatioForACA7M;
        }

        public void setNominalTotalToScienceRatioForACA7M(double d) {
            this.nominalTotalToScienceRatioForACA7M = d;
        }

        public double getNominalTotalToScienceRatioForWalsh() {
            return this.nominalTotalToScienceRatioForWalsh;
        }

        public void setNominalTotalToScienceRatioForWalsh(double d) {
            this.nominalTotalToScienceRatioForWalsh = d;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"proposalType"})
        public static class StandardProposalTypes {
            @XmlElement(name="ProposalType", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
            protected List<ProposalType> proposalType;

            public List<ProposalType> getProposalType() {
                if (this.proposalType == null) {
                    this.proposalType = new ArrayList<ProposalType>();
                }
                return this.proposalType;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"scienceGroup"})
        public static class ScienceKeywords {
            @XmlElement(name="ScienceGroup", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
            protected List<ScienceKeywordGroup> scienceGroup;

            public List<ScienceKeywordGroup> getScienceGroup() {
                if (this.scienceGroup == null) {
                    this.scienceGroup = new ArrayList<ScienceKeywordGroup>();
                }
                return this.scienceGroup;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"scienceCategory"})
        public static class ScienceCategories {
            @XmlElement(name="ScienceCategory", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
            protected List<ScienceCategory> scienceCategory;

            public List<ScienceCategory> getScienceCategory() {
                if (this.scienceCategory == null) {
                    this.scienceCategory = new ArrayList<ScienceCategory>();
                }
                return this.scienceCategory;
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            @XmlType(name="")
            public static class ScienceCategory {
                @XmlAttribute(name="index", required=true)
                @XmlSchemaType(name="nonNegativeInteger")
                protected BigInteger index;
                @XmlAttribute(name="category", required=true)
                protected String category;

                public BigInteger getIndex() {
                    return this.index;
                }

                public void setIndex(BigInteger bigInteger) {
                    this.index = bigInteger;
                }

                public String getCategory() {
                    return this.category;
                }

                public void setCategory(String string) {
                    this.category = string;
                }
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"proposalType"})
        public static class ObservatoryProposalTypes {
            @XmlElement(name="ProposalType", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
            protected List<ProposalType> proposalType;

            public List<ProposalType> getProposalType() {
                if (this.proposalType == null) {
                    this.proposalType = new ArrayList<ProposalType>();
                }
                return this.proposalType;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"dataRateConstraint"})
        public static class DataRateConstraints {
            @XmlElement(name="DataRateConstraint", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
            protected List<DataRateConstraint> dataRateConstraint;

            public List<DataRateConstraint> getDataRateConstraint() {
                if (this.dataRateConstraint == null) {
                    this.dataRateConstraint = new ArrayList<DataRateConstraint>();
                }
                return this.dataRateConstraint;
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            @XmlType(name="", propOrder={"limit", "array", "dataRateMBPS"})
            public static class DataRateConstraint {
                @XmlElement(name="Limit", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
                @XmlSchemaType(name="string")
                protected DataRateLimitType limit;
                @XmlElement(name="Array", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
                @XmlSchemaType(name="string")
                protected ArrayConfigurationType array;
                @XmlElement(name="DataRateMBPS", namespace="http://www.stfc.ac.uk/OTConfiguration")
                protected double dataRateMBPS;

                public DataRateLimitType getLimit() {
                    return this.limit;
                }

                public void setLimit(DataRateLimitType dataRateLimitType) {
                    this.limit = dataRateLimitType;
                }

                public ArrayConfigurationType getArray() {
                    return this.array;
                }

                public void setArray(ArrayConfigurationType arrayConfigurationType) {
                    this.array = arrayConfigurationType;
                }

                public double getDataRateMBPS() {
                    return this.dataRateMBPS;
                }

                public void setDataRateMBPS(double d) {
                    this.dataRateMBPS = d;
                }
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"noOf12MAntennas", "noOf7MAntennas", "noOfTPAntennas", "antennaBandAssignment", "antennaBandAssignmentForDataRates", "elevationLimit", "standardObservingModeList", "standardHolographyFrequencies", "availableReceiverBands", "availableCorrelatorModes", "maxNumberSPWs", "minElevationWarning", "maxElevationWarning", "minElevationWarningThreshold", "fullPolarisationAllowed", "fullPolarisationRestricted", "standardContinuumLO1Frequencies", "standardContinuumLO1PolarisationFrequencies", "standardVLBIFrequencies", "vlbiPhaserFrequencies", "spectralScanReceiverBands", "solarBands"})
    public static class TelescopeCapabilities {
        @XmlElement(name="NoOf12mAntennas", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger noOf12MAntennas;
        @XmlElement(name="NoOf7mAntennas", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger noOf7MAntennas;
        @XmlElement(name="NoOfTPAntennas", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="nonNegativeInteger")
        protected BigInteger noOfTPAntennas;
        @XmlElement(name="AntennaBandAssignment", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected AntennaAssignment antennaBandAssignment;
        @XmlElement(name="AntennaBandAssignmentForDataRates", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected AntennaAssignment antennaBandAssignmentForDataRates;
        @XmlElement(name="ElevationLimit", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected Angle elevationLimit;
        @XmlElement(name="StandardObservingModeList", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected String standardObservingModeList;
        @XmlElement(name="StandardHolographyFrequencies", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected FrequencyList standardHolographyFrequencies;
        @XmlElement(name="AvailableReceiverBands", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected AvailableReceiverBands availableReceiverBands;
        @XmlElement(name="AvailableCorrelatorModes", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected AvailableCorrelatorModes availableCorrelatorModes;
        @XmlElement(name="MaxNumberSPWs", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        @XmlSchemaType(name="positiveInteger")
        protected BigInteger maxNumberSPWs;
        @XmlElement(name="MinElevationWarning", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected Angle minElevationWarning;
        @XmlElement(name="MaxElevationWarning", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected Angle maxElevationWarning;
        @XmlElement(name="MinElevationWarningThreshold", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected Angle minElevationWarningThreshold;
        @XmlElement(name="FullPolarisationAllowed", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected boolean fullPolarisationAllowed;
        @XmlElement(name="FullPolarisationRestricted", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected boolean fullPolarisationRestricted;
        @XmlElement(name="StandardContinuumLO1Frequencies", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected FrequencyList standardContinuumLO1Frequencies;
        @XmlElement(name="StandardContinuumLO1PolarisationFrequencies", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected FrequencyList standardContinuumLO1PolarisationFrequencies;
        @XmlElement(name="StandardVLBIFrequencies", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected VLBIFrequencyBands standardVLBIFrequencies;
        @XmlElement(name="VLBIPhaserFrequencies", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected VLBIFrequencyBands vlbiPhaserFrequencies;
        @XmlElement(name="SpectralScanReceiverBands", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected SpectralScanReceiverBands spectralScanReceiverBands;
        @XmlElement(name="SolarBands", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected SolarBands solarBands;

        public BigInteger getNoOf12MAntennas() {
            return this.noOf12MAntennas;
        }

        public void setNoOf12MAntennas(BigInteger bigInteger) {
            this.noOf12MAntennas = bigInteger;
        }

        public BigInteger getNoOf7MAntennas() {
            return this.noOf7MAntennas;
        }

        public void setNoOf7MAntennas(BigInteger bigInteger) {
            this.noOf7MAntennas = bigInteger;
        }

        public BigInteger getNoOfTPAntennas() {
            return this.noOfTPAntennas;
        }

        public void setNoOfTPAntennas(BigInteger bigInteger) {
            this.noOfTPAntennas = bigInteger;
        }

        public AntennaAssignment getAntennaBandAssignment() {
            return this.antennaBandAssignment;
        }

        public void setAntennaBandAssignment(AntennaAssignment antennaAssignment) {
            this.antennaBandAssignment = antennaAssignment;
        }

        public AntennaAssignment getAntennaBandAssignmentForDataRates() {
            return this.antennaBandAssignmentForDataRates;
        }

        public void setAntennaBandAssignmentForDataRates(AntennaAssignment antennaAssignment) {
            this.antennaBandAssignmentForDataRates = antennaAssignment;
        }

        public Angle getElevationLimit() {
            return this.elevationLimit;
        }

        public void setElevationLimit(Angle angle) {
            this.elevationLimit = angle;
        }

        public String getStandardObservingModeList() {
            return this.standardObservingModeList;
        }

        public void setStandardObservingModeList(String string) {
            this.standardObservingModeList = string;
        }

        public FrequencyList getStandardHolographyFrequencies() {
            return this.standardHolographyFrequencies;
        }

        public void setStandardHolographyFrequencies(FrequencyList frequencyList) {
            this.standardHolographyFrequencies = frequencyList;
        }

        public AvailableReceiverBands getAvailableReceiverBands() {
            return this.availableReceiverBands;
        }

        public void setAvailableReceiverBands(AvailableReceiverBands availableReceiverBands) {
            this.availableReceiverBands = availableReceiverBands;
        }

        public AvailableCorrelatorModes getAvailableCorrelatorModes() {
            return this.availableCorrelatorModes;
        }

        public void setAvailableCorrelatorModes(AvailableCorrelatorModes availableCorrelatorModes) {
            this.availableCorrelatorModes = availableCorrelatorModes;
        }

        public BigInteger getMaxNumberSPWs() {
            return this.maxNumberSPWs;
        }

        public void setMaxNumberSPWs(BigInteger bigInteger) {
            this.maxNumberSPWs = bigInteger;
        }

        public Angle getMinElevationWarning() {
            return this.minElevationWarning;
        }

        public void setMinElevationWarning(Angle angle) {
            this.minElevationWarning = angle;
        }

        public Angle getMaxElevationWarning() {
            return this.maxElevationWarning;
        }

        public void setMaxElevationWarning(Angle angle) {
            this.maxElevationWarning = angle;
        }

        public Angle getMinElevationWarningThreshold() {
            return this.minElevationWarningThreshold;
        }

        public void setMinElevationWarningThreshold(Angle angle) {
            this.minElevationWarningThreshold = angle;
        }

        public boolean isFullPolarisationAllowed() {
            return this.fullPolarisationAllowed;
        }

        public void setFullPolarisationAllowed(boolean bl) {
            this.fullPolarisationAllowed = bl;
        }

        public boolean isFullPolarisationRestricted() {
            return this.fullPolarisationRestricted;
        }

        public void setFullPolarisationRestricted(boolean bl) {
            this.fullPolarisationRestricted = bl;
        }

        public FrequencyList getStandardContinuumLO1Frequencies() {
            return this.standardContinuumLO1Frequencies;
        }

        public void setStandardContinuumLO1Frequencies(FrequencyList frequencyList) {
            this.standardContinuumLO1Frequencies = frequencyList;
        }

        public FrequencyList getStandardContinuumLO1PolarisationFrequencies() {
            return this.standardContinuumLO1PolarisationFrequencies;
        }

        public void setStandardContinuumLO1PolarisationFrequencies(FrequencyList frequencyList) {
            this.standardContinuumLO1PolarisationFrequencies = frequencyList;
        }

        public VLBIFrequencyBands getStandardVLBIFrequencies() {
            return this.standardVLBIFrequencies;
        }

        public void setStandardVLBIFrequencies(VLBIFrequencyBands vLBIFrequencyBands) {
            this.standardVLBIFrequencies = vLBIFrequencyBands;
        }

        public VLBIFrequencyBands getVLBIPhaserFrequencies() {
            return this.vlbiPhaserFrequencies;
        }

        public void setVLBIPhaserFrequencies(VLBIFrequencyBands vLBIFrequencyBands) {
            this.vlbiPhaserFrequencies = vLBIFrequencyBands;
        }

        public SpectralScanReceiverBands getSpectralScanReceiverBands() {
            return this.spectralScanReceiverBands;
        }

        public void setSpectralScanReceiverBands(SpectralScanReceiverBands spectralScanReceiverBands) {
            this.spectralScanReceiverBands = spectralScanReceiverBands;
        }

        public SolarBands getSolarBands() {
            return this.solarBands;
        }

        public void setSolarBands(SolarBands solarBands) {
            this.solarBands = solarBands;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"band"})
        public static class SpectralScanReceiverBands {
            @XmlElement(name="Band", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
            @XmlSchemaType(name="string")
            protected List<ValidBandTag> band;

            public List<ValidBandTag> getBand() {
                if (this.band == null) {
                    this.band = new ArrayList<ValidBandTag>();
                }
                return this.band;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"solarBand"})
        public static class SolarBands {
            @XmlElement(name="SolarBand", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
            protected List<SolarBand> solarBand;

            public List<SolarBand> getSolarBand() {
                if (this.solarBand == null) {
                    this.solarBand = new ArrayList<SolarBand>();
                }
                return this.solarBand;
            }

            @XmlAccessorType(value=XmlAccessType.FIELD)
            @XmlType(name="", propOrder={"standardFrequency", "tIntScan", "tTpScan", "ttMax"})
            public static class SolarBand {
                @XmlElement(name="StandardFrequency", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
                protected Frequency standardFrequency;
                @XmlElement(name="t_int_scan", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
                protected OTTime tIntScan;
                @XmlElement(name="t_tp_scan", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
                protected OTTime tTpScan;
                @XmlElement(name="t_t_max", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
                protected OTTime ttMax;
                @XmlAttribute(name="band", required=true)
                protected int band;
                @XmlAttribute(name="isFullPolarizationEnabled")
                protected Boolean isFullPolarizationEnabled;

                public Frequency getStandardFrequency() {
                    return this.standardFrequency;
                }

                public void setStandardFrequency(Frequency frequency) {
                    this.standardFrequency = frequency;
                }

                public OTTime getTIntScan() {
                    return this.tIntScan;
                }

                public void setTIntScan(OTTime oTTime) {
                    this.tIntScan = oTTime;
                }

                public OTTime getTTpScan() {
                    return this.tTpScan;
                }

                public void setTTpScan(OTTime oTTime) {
                    this.tTpScan = oTTime;
                }

                public OTTime getTTMax() {
                    return this.ttMax;
                }

                public void setTTMax(OTTime oTTime) {
                    this.ttMax = oTTime;
                }

                public int getBand() {
                    return this.band;
                }

                public void setBand(int n) {
                    this.band = n;
                }

                public boolean isIsFullPolarizationEnabled() {
                    if (this.isFullPolarizationEnabled == null) {
                        return false;
                    }
                    return this.isFullPolarizationEnabled;
                }

                public void setIsFullPolarizationEnabled(Boolean bl) {
                    this.isFullPolarizationEnabled = bl;
                }
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"band"})
        public static class AvailableReceiverBands {
            @XmlElement(name="Band", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
            @XmlSchemaType(name="string")
            protected List<ValidBandTag> band;

            public List<ValidBandTag> getBand() {
                if (this.band == null) {
                    this.band = new ArrayList<ValidBandTag>();
                }
                return this.band;
            }
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"mode"})
        public static class AvailableCorrelatorModes {
            @XmlElement(name="Mode", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
            @XmlSchemaType(name="positiveInteger")
            protected List<BigInteger> mode;

            public List<BigInteger> getMode() {
                if (this.mode == null) {
                    this.mode = new ArrayList<BigInteger>();
                }
                return this.mode;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"observatoryName", "observatoryLatitude", "observatoryLongitude"})
    public static class SiteCharacteristics {
        @XmlElement(name="ObservatoryName", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected String observatoryName;
        @XmlElement(name="ObservatoryLatitude", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected double observatoryLatitude;
        @XmlElement(name="ObservatoryLongitude", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected double observatoryLongitude;

        public String getObservatoryName() {
            return this.observatoryName;
        }

        public void setObservatoryName(String string) {
            this.observatoryName = string;
        }

        public double getObservatoryLatitude() {
            return this.observatoryLatitude;
        }

        public void setObservatoryLatitude(double d) {
            this.observatoryLatitude = d;
        }

        public double getObservatoryLongitude() {
            return this.observatoryLongitude;
        }

        public void setObservatoryLongitude(double d) {
            this.observatoryLongitude = d;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"configuration"})
    public static class Shadowing {
        @XmlElement(name="Configuration", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected List<String> configuration;

        public List<String> getConfiguration() {
            if (this.configuration == null) {
                this.configuration = new ArrayList<String>();
            }
            return this.configuration;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"tpAmpCalSBBands"})
    public static class ScheduleBlockConfiguration {
        @XmlElement(name="TPAmpCalSBBands", namespace="http://www.stfc.ac.uk/OTConfiguration")
        protected TPAmpCalSBBands tpAmpCalSBBands;

        public TPAmpCalSBBands getTPAmpCalSBBands() {
            return this.tpAmpCalSBBands;
        }

        public void setTPAmpCalSBBands(TPAmpCalSBBands tPAmpCalSBBands) {
            this.tpAmpCalSBBands = tPAmpCalSBBands;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"receiverBand"})
        public static class TPAmpCalSBBands {
            @XmlElement(name="ReceiverBand", namespace="http://www.stfc.ac.uk/OTConfiguration", type=Integer.class)
            @XmlSchemaType(name="nonNegativeInteger")
            protected List<Integer> receiverBand;

            public List<Integer> getReceiverBand() {
                if (this.receiverBand == null) {
                    this.receiverBand = new ArrayList<Integer>();
                }
                return this.receiverBand;
            }
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"arrayConfiguration"})
    public static class ArrayConfigurations {
        @XmlElement(name="ArrayConfiguration", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
        protected List<ArrayConfiguration> arrayConfiguration;

        public List<ArrayConfiguration> getArrayConfiguration() {
            if (this.arrayConfiguration == null) {
                this.arrayConfiguration = new ArrayList<ArrayConfiguration>();
            }
            return this.arrayConfiguration;
        }

        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlType(name="", propOrder={"arrayMultiplier", "configurationType", "validReceiverBand", "solarCompatibleReceiverBand"})
        public static class ArrayConfiguration {
            @XmlElement(name="ArrayMultiplier", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
            protected List<ArrayMultiplierType> arrayMultiplier;
            @XmlElement(name="ConfigurationType", namespace="http://www.stfc.ac.uk/OTConfiguration", required=true)
            @XmlSchemaType(name="string")
            protected ArrayConfigurationType configurationType;
            @XmlElement(name="ValidReceiverBand", namespace="http://www.stfc.ac.uk/OTConfiguration", type=Integer.class)
            @XmlSchemaType(name="nonNegativeInteger")
            protected List<Integer> validReceiverBand;
            @XmlElement(name="SolarCompatibleReceiverBand", namespace="http://www.stfc.ac.uk/OTConfiguration", type=Integer.class)
            @XmlSchemaType(name="nonNegativeInteger")
            protected List<Integer> solarCompatibleReceiverBand;
            @XmlAttribute(name="configurationNumber", required=true)
            protected int configurationNumber;
            @XmlAttribute(name="isEnabled")
            protected Boolean isEnabled;
            @XmlAttribute(name="isACAAllowed", required=true)
            protected boolean isACAAllowed;
            @XmlAttribute(name="configurationName", required=true)
            protected String configurationName;
            @XmlAttribute(name="isLongBaselineConfiguration")
            protected Boolean isLongBaselineConfiguration;
            @XmlAttribute(name="isShadowingAdjusted")
            protected Boolean isShadowingAdjusted;
            @XmlAttribute(name="compactConfiguration")
            protected String compactConfiguration;
            @XmlAttribute(name="maxBaseline", required=true)
            protected double maxBaseline;
            @XmlAttribute(name="minBaseline", required=true)
            protected double minBaseline;
            @XmlAttribute(name="isVLBIConfiguration")
            protected Boolean isVLBIConfiguration;

            public List<ArrayMultiplierType> getArrayMultiplier() {
                if (this.arrayMultiplier == null) {
                    this.arrayMultiplier = new ArrayList<ArrayMultiplierType>();
                }
                return this.arrayMultiplier;
            }

            public ArrayConfigurationType getConfigurationType() {
                return this.configurationType;
            }

            public void setConfigurationType(ArrayConfigurationType arrayConfigurationType) {
                this.configurationType = arrayConfigurationType;
            }

            public List<Integer> getValidReceiverBand() {
                if (this.validReceiverBand == null) {
                    this.validReceiverBand = new ArrayList<Integer>();
                }
                return this.validReceiverBand;
            }

            public List<Integer> getSolarCompatibleReceiverBand() {
                if (this.solarCompatibleReceiverBand == null) {
                    this.solarCompatibleReceiverBand = new ArrayList<Integer>();
                }
                return this.solarCompatibleReceiverBand;
            }

            public int getConfigurationNumber() {
                return this.configurationNumber;
            }

            public void setConfigurationNumber(int n) {
                this.configurationNumber = n;
            }

            public boolean isIsEnabled() {
                if (this.isEnabled == null) {
                    return true;
                }
                return this.isEnabled;
            }

            public void setIsEnabled(Boolean bl) {
                this.isEnabled = bl;
            }

            public boolean isIsACAAllowed() {
                return this.isACAAllowed;
            }

            public void setIsACAAllowed(boolean bl) {
                this.isACAAllowed = bl;
            }

            public String getConfigurationName() {
                return this.configurationName;
            }

            public void setConfigurationName(String string) {
                this.configurationName = string;
            }

            public boolean isIsLongBaselineConfiguration() {
                if (this.isLongBaselineConfiguration == null) {
                    return false;
                }
                return this.isLongBaselineConfiguration;
            }

            public void setIsLongBaselineConfiguration(Boolean bl) {
                this.isLongBaselineConfiguration = bl;
            }

            public boolean isIsShadowingAdjusted() {
                if (this.isShadowingAdjusted == null) {
                    return false;
                }
                return this.isShadowingAdjusted;
            }

            public void setIsShadowingAdjusted(Boolean bl) {
                this.isShadowingAdjusted = bl;
            }

            public String getCompactConfiguration() {
                return this.compactConfiguration;
            }

            public void setCompactConfiguration(String string) {
                this.compactConfiguration = string;
            }

            public double getMaxBaseline() {
                return this.maxBaseline;
            }

            public void setMaxBaseline(double d) {
                this.maxBaseline = d;
            }

            public double getMinBaseline() {
                return this.minBaseline;
            }

            public void setMinBaseline(double d) {
                this.minBaseline = d;
            }

            public boolean isIsVLBIConfiguration() {
                if (this.isVLBIConfiguration == null) {
                    return false;
                }
                return this.isVLBIConfiguration;
            }

            public void setIsVLBIConfiguration(Boolean bl) {
                this.isVLBIConfiguration = bl;
            }
        }
    }
}

