/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject.data;

import alma.entity.xmlbinding.obsproject.QuerySourceT;
import alma.entity.xmlbinding.obsproject.types.QuerySourceTIntendedUseType;
import alma.entity.xmlbinding.valuetypes.AngleT;
import alma.entity.xmlbinding.valuetypes.FluxT;
import alma.entity.xmlbinding.valuetypes.FrequencyT;
import alma.entity.xmlbinding.valuetypes.SkyCoordinatesT;
import alma.entity.xmlbinding.valuetypes.TimeT;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.CompositionChild;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceableProxy;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import java.util.Arrays;
import java.util.List;

public abstract class QuerySourceData
extends BusinessObject
implements IBusinessObject,
CompositionChild {
    public static final String INTENDEDUSE_AMPLITUDE = QuerySourceTIntendedUseType.AMPLITUDE.toString();
    public static final String INTENDEDUSE_ATMOSPHERIC = QuerySourceTIntendedUseType.ATMOSPHERIC.toString();
    public static final String INTENDEDUSE_BANDPASS = QuerySourceTIntendedUseType.BANDPASS.toString();
    public static final String INTENDEDUSE_PHASE = QuerySourceTIntendedUseType.PHASE.toString();
    public static final String INTENDEDUSE_POINTING = QuerySourceTIntendedUseType.POINTING.toString();
    public static final String INTENDEDUSE_FOCUS = QuerySourceTIntendedUseType.FOCUS.toString();
    public static final String INTENDEDUSE_POLARIZATION = QuerySourceTIntendedUseType.POLARIZATION.toString();
    public static final String INTENDEDUSE_DELAY = QuerySourceTIntendedUseType.DELAY.toString();
    public static final String INTENDEDUSE_SIDEBANDRATIO = QuerySourceTIntendedUseType.SIDEBANDRATIO.toString();
    public static final String INTENDEDUSE_CHECKSOURCE = QuerySourceTIntendedUseType.CHECKSOURCE.toString();
    public static final String INTENDEDUSE_DGCREFERENCE = QuerySourceTIntendedUseType.DGCREFERENCE.toString();
    public static final String INTENDEDUSE_DGCSCIENCE = QuerySourceTIntendedUseType.DGCSCIENCE.toString();
    protected static String[] knownIntendedUseList = new String[]{INTENDEDUSE_AMPLITUDE, INTENDEDUSE_ATMOSPHERIC, INTENDEDUSE_BANDPASS, INTENDEDUSE_PHASE, INTENDEDUSE_POINTING, INTENDEDUSE_FOCUS, INTENDEDUSE_POLARIZATION, INTENDEDUSE_DELAY, INTENDEDUSE_SIDEBANDRATIO, INTENDEDUSE_CHECKSOURCE, INTENDEDUSE_DGCREFERENCE, INTENDEDUSE_DGCSCIENCE};
    private static List<Class> parentTypes = Arrays.asList(CalibrationSetupParameters.class, ObservatoryGoal.class);
    private SkyCoordinates boQueryCenter = null;
    private Angle boSearchRadius = null;
    private Frequency boMinFrequency = null;
    private Frequency boMaxFrequency = null;
    private Flux boMinFlux = null;
    private Flux boMaxFlux = null;
    private Time boMinTimeSinceObserved = null;
    private Time boMaxTimeSinceObserved = null;

    protected QuerySourceData(QuerySourceT castorObject) {
        super(castorObject);
    }

    public static QuerySourceT testsupport_createQuerySourceT() {
        return QuerySource.createQuerySourceT();
    }

    protected static final QuerySourceT createQuerySourceT() {
        QuerySourceT ret = new QuerySourceT();
        QuerySource.patchQuerySourceT((QuerySourceT)ret);
        return ret;
    }

    protected static final void patchQuerySourceT(QuerySourceT castorObject) {
        castorObject.setMaxSources(1);
        castorObject.setIndex(0);
    }

    private static final QuerySource createUnitializedQuerySource() {
        QuerySourceT so = QuerySource.createQuerySourceT();
        QuerySource ret = new QuerySource(so);
        return ret;
    }

    public static QuerySource createQuerySource() {
        QuerySourceT so = QuerySource.createQuerySourceT();
        QuerySource ret = new QuerySource(so);
        ret.initAsNew();
        return ret;
    }

    private void wrapQueryCenter() {
        SkyCoordinatesT subSo = this.getCastorObject().getQueryCenter();
        if (subSo != null) {
            SkyCoordinates subBo;
            this.boQueryCenter = subBo = new SkyCoordinates(subSo);
        }
    }

    public void setQueryCenter(SkyCoordinates newValue) {
        QuerySourceT castorObject = this.getCastorObject();
        SkyCoordinatesT subCastorObject = newValue.getCastorObject();
        castorObject.setQueryCenter(subCastorObject);
        this.boQueryCenter = newValue;
        String propName = "alma.obsprep.bo.obsproject.QuerySource.queryCenter";
        SkyCoordinates propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.queryCenter", propValue);
    }

    public SkyCoordinates gettrueQueryCenter() {
        SkyCoordinates ret = this.boQueryCenter;
        return ret;
    }

    public SkyCoordinates getQueryCenter() {
        SkyCoordinates ret = this.gettrueQueryCenter();
        if (ret == null) {
            ret = SkyCoordinates.createSkyCoordinates();
            this.setQueryCenter(ret);
        }
        return ret;
    }

    private void wrapSearchRadius() {
        AngleT subSo = this.getCastorObject().getSearchRadius();
        if (subSo != null) {
            Angle subBo;
            this.boSearchRadius = subBo = new Angle(subSo);
        }
    }

    public void setSearchRadius(Angle newValue) {
        QuerySourceT castorObject = this.getCastorObject();
        AngleT subCastorObject = newValue.getCastorObject();
        castorObject.setSearchRadius(subCastorObject);
        this.boSearchRadius = newValue;
        String propName = "alma.obsprep.bo.obsproject.QuerySource.searchRadius";
        Angle propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.searchRadius", propValue);
    }

    public Angle gettrueSearchRadius() {
        Angle ret = this.boSearchRadius;
        return ret;
    }

    public Angle getSearchRadius() {
        Angle ret = this.gettrueSearchRadius();
        if (ret == null) {
            ret = Angle.createAngle();
            this.setSearchRadius(ret);
        }
        return ret;
    }

    private void wrapMinFrequency() {
        FrequencyT subSo = this.getCastorObject().getMinFrequency();
        if (subSo != null) {
            Frequency subBo;
            this.boMinFrequency = subBo = new Frequency(subSo);
        }
    }

    public void setMinFrequency(Frequency newValue) {
        QuerySourceT castorObject = this.getCastorObject();
        FrequencyT subCastorObject = newValue.getCastorObject();
        castorObject.setMinFrequency(subCastorObject);
        this.boMinFrequency = newValue;
        String propName = "alma.obsprep.bo.obsproject.QuerySource.minFrequency";
        Frequency propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.minFrequency", propValue);
    }

    public Frequency gettrueMinFrequency() {
        Frequency ret = this.boMinFrequency;
        return ret;
    }

    public Frequency getMinFrequency() {
        Frequency ret = this.gettrueMinFrequency();
        if (ret == null) {
            ret = Frequency.createFrequency();
            this.setMinFrequency(ret);
        }
        return ret;
    }

    private void wrapMaxFrequency() {
        FrequencyT subSo = this.getCastorObject().getMaxFrequency();
        if (subSo != null) {
            Frequency subBo;
            this.boMaxFrequency = subBo = new Frequency(subSo);
        }
    }

    public void setMaxFrequency(Frequency newValue) {
        QuerySourceT castorObject = this.getCastorObject();
        FrequencyT subCastorObject = newValue.getCastorObject();
        castorObject.setMaxFrequency(subCastorObject);
        this.boMaxFrequency = newValue;
        String propName = "alma.obsprep.bo.obsproject.QuerySource.maxFrequency";
        Frequency propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.maxFrequency", propValue);
    }

    public Frequency gettrueMaxFrequency() {
        Frequency ret = this.boMaxFrequency;
        return ret;
    }

    public Frequency getMaxFrequency() {
        Frequency ret = this.gettrueMaxFrequency();
        if (ret == null) {
            ret = Frequency.createFrequency();
            this.setMaxFrequency(ret);
        }
        return ret;
    }

    private void wrapMinFlux() {
        FluxT subSo = this.getCastorObject().getMinFlux();
        if (subSo != null) {
            Flux subBo;
            this.boMinFlux = subBo = new Flux(subSo);
        }
    }

    public void setMinFlux(Flux newValue) {
        QuerySourceT castorObject = this.getCastorObject();
        FluxT subCastorObject = newValue.getCastorObject();
        castorObject.setMinFlux(subCastorObject);
        this.boMinFlux = newValue;
        String propName = "alma.obsprep.bo.obsproject.QuerySource.minFlux";
        Flux propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.minFlux", propValue);
    }

    public Flux gettrueMinFlux() {
        Flux ret = this.boMinFlux;
        return ret;
    }

    public Flux getMinFlux() {
        Flux ret = this.gettrueMinFlux();
        if (ret == null) {
            ret = Flux.createFlux();
            this.setMinFlux(ret);
        }
        return ret;
    }

    private void wrapMaxFlux() {
        FluxT subSo = this.getCastorObject().getMaxFlux();
        if (subSo != null) {
            Flux subBo;
            this.boMaxFlux = subBo = new Flux(subSo);
        }
    }

    public void setMaxFlux(Flux newValue) {
        QuerySourceT castorObject = this.getCastorObject();
        FluxT subCastorObject = newValue.getCastorObject();
        castorObject.setMaxFlux(subCastorObject);
        this.boMaxFlux = newValue;
        String propName = "alma.obsprep.bo.obsproject.QuerySource.maxFlux";
        Flux propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.maxFlux", propValue);
    }

    public Flux gettrueMaxFlux() {
        Flux ret = this.boMaxFlux;
        return ret;
    }

    public Flux getMaxFlux() {
        Flux ret = this.gettrueMaxFlux();
        if (ret == null) {
            ret = Flux.createFlux();
            this.setMaxFlux(ret);
        }
        return ret;
    }

    private void wrapMinTimeSinceObserved() {
        TimeT subSo = this.getCastorObject().getMinTimeSinceObserved();
        if (subSo != null) {
            Time subBo;
            this.boMinTimeSinceObserved = subBo = new Time(subSo);
        }
    }

    public void setMinTimeSinceObserved(Time newValue) {
        QuerySourceT castorObject = this.getCastorObject();
        TimeT subCastorObject = newValue.getCastorObject();
        castorObject.setMinTimeSinceObserved(subCastorObject);
        this.boMinTimeSinceObserved = newValue;
        String propName = "alma.obsprep.bo.obsproject.QuerySource.minTimeSinceObserved";
        Time propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.minTimeSinceObserved", propValue);
    }

    public Time gettrueMinTimeSinceObserved() {
        Time ret = this.boMinTimeSinceObserved;
        return ret;
    }

    public Time getMinTimeSinceObserved() {
        Time ret = this.gettrueMinTimeSinceObserved();
        if (ret == null) {
            ret = Time.createTime();
            this.setMinTimeSinceObserved(ret);
        }
        return ret;
    }

    private void wrapMaxTimeSinceObserved() {
        TimeT subSo = this.getCastorObject().getMaxTimeSinceObserved();
        if (subSo != null) {
            Time subBo;
            this.boMaxTimeSinceObserved = subBo = new Time(subSo);
        }
    }

    public void setMaxTimeSinceObserved(Time newValue) {
        QuerySourceT castorObject = this.getCastorObject();
        TimeT subCastorObject = newValue.getCastorObject();
        castorObject.setMaxTimeSinceObserved(subCastorObject);
        this.boMaxTimeSinceObserved = newValue;
        String propName = "alma.obsprep.bo.obsproject.QuerySource.maxTimeSinceObserved";
        Time propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.maxTimeSinceObserved", propValue);
    }

    public Time gettrueMaxTimeSinceObserved() {
        Time ret = this.boMaxTimeSinceObserved;
        return ret;
    }

    public Time getMaxTimeSinceObserved() {
        Time ret = this.gettrueMaxTimeSinceObserved();
        if (ret == null) {
            ret = Time.createTime();
            this.setMaxTimeSinceObserved(ret);
        }
        return ret;
    }

    public void setUse(String newValue) {
        QuerySourceT castorObject = this.getCastorObject();
        castorObject.setUse(newValue);
        String propName = "alma.obsprep.bo.obsproject.QuerySource.use";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.use", propValue);
    }

    public String gettrueUse() {
        QuerySourceT castorObject = this.getCastorObject();
        String ret = castorObject.getUse();
        return ret;
    }

    public String getUse() {
        String ret = this.gettrueUse();
        if (ret == null) {
            ret = "";
            this.setUse(ret);
        }
        return ret;
    }

    public void setMaxSources(int newValue) {
        QuerySourceT castorObject = this.getCastorObject();
        castorObject.setMaxSources(newValue);
        String propName = "alma.obsprep.bo.obsproject.QuerySource.maxSources";
        Integer propValue = new Integer(newValue);
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.maxSources", propValue);
    }

    public int gettrueMaxSources() {
        QuerySourceT castorObject = this.getCastorObject();
        int ret = castorObject.getMaxSources();
        return ret;
    }

    public int getMaxSources() {
        int ret = this.gettrueMaxSources();
        return ret;
    }

    public boolean hasMaxSources() {
        QuerySourceT castorObject = this.getCastorObject();
        boolean ret = castorObject.hasMaxSources();
        return ret;
    }

    public void setIntendedUse(String newValue) throws IllegalArgumentException {
        QuerySourceT castorObject = this.getCastorObject();
        QuerySourceTIntendedUseType castorEnumElement = QuerySourceTIntendedUseType.valueOf(newValue);
        castorObject.setIntendedUse(castorEnumElement);
        String propName = "alma.obsprep.bo.obsproject.QuerySource.intendedUse";
        String propValue = newValue;
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.intendedUse", propValue);
    }

    public String getIntendedUse() {
        QuerySourceT castorObject = this.getCastorObject();
        QuerySourceTIntendedUseType value = castorObject.getIntendedUse();
        String ret = value == null ? null : value.toString();
        return ret;
    }

    public static String[] getKnownIntendedUseList() {
        return knownIntendedUseList;
    }

    public void setIndex(int newValue) {
        QuerySourceT castorObject = this.getCastorObject();
        castorObject.setIndex(newValue);
        String propName = "alma.obsprep.bo.obsproject.QuerySource.index";
        Integer propValue = new Integer(newValue);
        this.firePropertyChangeEvent(this, "alma.obsprep.bo.obsproject.QuerySource.index", propValue);
    }

    public int gettrueIndex() {
        QuerySourceT castorObject = this.getCastorObject();
        int ret = castorObject.getIndex();
        return ret;
    }

    public int getIndex() {
        int ret = this.gettrueIndex();
        return ret;
    }

    public boolean hasIndex() {
        QuerySourceT castorObject = this.getCastorObject();
        boolean ret = castorObject.hasIndex();
        return ret;
    }

    @Override
    public QuerySourceT getCastorObject() {
        return (QuerySourceT)this.storageObject;
    }

    public QuerySource deepCopy() throws CopyException {
        return (QuerySource)super.deepCopy();
    }

    protected QuerySource invokeCreateUnitialized() throws CopyException {
        return QuerySourceData.createUnitializedQuerySource();
    }

    @Override
    protected void initAttribsAndPartsFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initAttribsAndPartsFrom(original, copier);
        QuerySourceData orig = (QuerySourceData)original;
        if (orig.gettrueQueryCenter() != null) {
            this.setQueryCenter((SkyCoordinates)copier.cpAttr((BusinessObject)orig.gettrueQueryCenter()));
        }
        if (orig.gettrueSearchRadius() != null) {
            this.setSearchRadius((Angle)copier.cpAttr((BusinessObject)orig.gettrueSearchRadius()));
        }
        if (orig.gettrueMinFrequency() != null) {
            this.setMinFrequency((Frequency)copier.cpAttr((BusinessObject)orig.gettrueMinFrequency()));
        }
        if (orig.gettrueMaxFrequency() != null) {
            this.setMaxFrequency((Frequency)copier.cpAttr((BusinessObject)orig.gettrueMaxFrequency()));
        }
        if (orig.gettrueMinFlux() != null) {
            this.setMinFlux((Flux)copier.cpAttr((BusinessObject)orig.gettrueMinFlux()));
        }
        if (orig.gettrueMaxFlux() != null) {
            this.setMaxFlux((Flux)copier.cpAttr((BusinessObject)orig.gettrueMaxFlux()));
        }
        if (orig.gettrueMinTimeSinceObserved() != null) {
            this.setMinTimeSinceObserved((Time)copier.cpAttr((BusinessObject)orig.gettrueMinTimeSinceObserved()));
        }
        if (orig.gettrueMaxTimeSinceObserved() != null) {
            this.setMaxTimeSinceObserved((Time)copier.cpAttr((BusinessObject)orig.gettrueMaxTimeSinceObserved()));
        }
        if (orig.gettrueUse() != null) {
            this.setUse(orig.gettrueUse());
        }
        if (orig.hasMaxSources()) {
            this.setMaxSources(orig.getMaxSources());
        }
        if (orig.getIntendedUse() != null) {
            this.setIntendedUse(orig.getIntendedUse());
        }
        if (orig.hasIndex()) {
            this.setIndex(orig.getIndex());
        }
    }

    @Override
    protected void initEntityReferencesFrom(IBusinessObject original, Copier copier) throws CopyException {
        super.initEntityReferencesFrom(original, copier);
        QuerySourceData orig = (QuerySourceData)original;
    }

    @Override
    public void wrapObjects(ReferenceablesMap referencedObjects, List<ReferenceableProxy<? extends IBusinessObject>> referrers) {
        super.wrapObjects(referencedObjects, referrers);
        this.wrapQueryCenter();
        this.wrapSearchRadius();
        this.wrapMinFrequency();
        this.wrapMaxFrequency();
        this.wrapMinFlux();
        this.wrapMaxFlux();
        this.wrapMinTimeSinceObserved();
        this.wrapMaxTimeSinceObserved();
    }

    @Override
    public List<IBusinessObject> referencedBOs(Referring.By ... bys) {
        List<IBusinessObject> r = super.referencedBOs(bys);
        block5: for (Referring.By by : bys) {
            switch (by) {
                case UmlComposition: {
                    continue block5;
                }
                case UmlUnidir: {
                    continue block5;
                }
                case UmlAttribution: {
                    this.addToCollection(r, this.gettrueQueryCenter());
                    this.addToCollection(r, this.gettrueSearchRadius());
                    this.addToCollection(r, this.gettrueMinFrequency());
                    this.addToCollection(r, this.gettrueMaxFrequency());
                    this.addToCollection(r, this.gettrueMinFlux());
                    this.addToCollection(r, this.gettrueMaxFlux());
                    this.addToCollection(r, this.gettrueMinTimeSinceObserved());
                    this.addToCollection(r, this.gettrueMaxTimeSinceObserved());
                }
            }
        }
        return r;
    }

    @Override
    public List<Class> getParentTypes() {
        return parentTypes;
    }

    @Override
    public void addToParent(IBusinessObject newParent) {
        if (newParent == null) {
            return;
        }
        if (newParent instanceof CalibrationSetupParameters) {
            CalibrationSetupParameters p = (CalibrationSetupParameters)newParent;
            p.addQuerySource((QuerySource)this);
        } else if (newParent instanceof ObservatoryGoal) {
            ObservatoryGoal p = (ObservatoryGoal)newParent;
            p.setObservatoryGoalQueryParameters((QuerySource)this);
        } else {
            throw new ClassCastException("not a legal parent type: " + newParent.getClass());
        }
    }

    @Override
    public void removeFromParent() {
        BusinessObject oldParent = this.getParent();
        if (oldParent == null) {
            return;
        }
        if (oldParent instanceof CalibrationSetupParameters) {
            CalibrationSetupParameters p = (CalibrationSetupParameters)oldParent;
            p.removeQuerySource((QuerySource)this);
        } else if (oldParent instanceof ObservatoryGoal) {
            ObservatoryGoal p = (ObservatoryGoal)oldParent;
            if (p.gettrueObservatoryGoalQueryParameters() != this) {
                Log.logger(this).warning("bo inconsistency: " + this + " believes to have parent " + p + ", but the parent doesn't think so");
                return;
            }
            p.setObservatoryGoalQueryParameters((QuerySource)null);
        }
    }
}

