/*
 * Decompiled with CFR 0.152.
 */
package alma.entity.xmlbinding.schedblock;

import alma.entity.xmlbinding.schedblock.SpectralLineT;
import alma.entity.xmlbinding.schedblock.types.AbstractSpectralWindowTPolnProductsType;
import alma.entity.xmlbinding.schedblock.types.AbstractSpectralWindowTSideBandType;
import alma.entity.xmlbinding.schedblock.types.AbstractSpectralWindowTWindowFunctionType;
import alma.entity.xmlbinding.valuetypes.FrequencyT;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class AbstractSpectralWindowT
implements Serializable {
    private AbstractSpectralWindowTSideBandType _sideBand = AbstractSpectralWindowTSideBandType.valueOf("NOSB");
    private AbstractSpectralWindowTWindowFunctionType _windowFunction = AbstractSpectralWindowTWindowFunctionType.valueOf("HANNING");
    private AbstractSpectralWindowTPolnProductsType _polnProducts = AbstractSpectralWindowTPolnProductsType.valueOf("XX,YY");
    private FrequencyT _centerFrequency;
    private int _spectralAveragingFactor = 1;
    private boolean _has_spectralAveragingFactor;
    private String _name;
    private FrequencyT _effectiveBandwidth;
    private int _effectiveNumberOfChannels;
    private boolean _has_effectiveNumberOfChannels;
    private int _associatedSpectralWindowNumberInPair = 0;
    private boolean _has_associatedSpectralWindowNumberInPair;
    private boolean _useThisSpectralWindow = true;
    private boolean _has_useThisSpectralWindow;
    private FrequencyT _desiredCenterFrequency;
    private boolean _representativeWindow = false;
    private boolean _has_representativeWindow;
    private ArrayList _spectralLineList;

    public AbstractSpectralWindowT() {
        this.setSideBand(AbstractSpectralWindowTSideBandType.valueOf("NOSB"));
        this.setWindowFunction(AbstractSpectralWindowTWindowFunctionType.valueOf("HANNING"));
        this.setPolnProducts(AbstractSpectralWindowTPolnProductsType.valueOf("XX,YY"));
        this._spectralLineList = new ArrayList();
    }

    public void addSpectralLine(SpectralLineT vSpectralLine) throws IndexOutOfBoundsException {
        this._spectralLineList.add(vSpectralLine);
    }

    public void addSpectralLine(int index, SpectralLineT vSpectralLine) throws IndexOutOfBoundsException {
        this._spectralLineList.add(index, vSpectralLine);
    }

    public void clearSpectralLine() {
        this._spectralLineList.clear();
    }

    public void deleteAssociatedSpectralWindowNumberInPair() {
        this._has_associatedSpectralWindowNumberInPair = false;
    }

    public void deleteEffectiveNumberOfChannels() {
        this._has_effectiveNumberOfChannels = false;
    }

    public void deleteRepresentativeWindow() {
        this._has_representativeWindow = false;
    }

    public void deleteSpectralAveragingFactor() {
        this._has_spectralAveragingFactor = false;
    }

    public void deleteUseThisSpectralWindow() {
        this._has_useThisSpectralWindow = false;
    }

    public Enumeration enumerateSpectralLine() {
        return new IteratorEnumeration(this._spectralLineList.iterator());
    }

    public int getAssociatedSpectralWindowNumberInPair() {
        return this._associatedSpectralWindowNumberInPair;
    }

    public FrequencyT getCenterFrequency() {
        return this._centerFrequency;
    }

    public FrequencyT getDesiredCenterFrequency() {
        return this._desiredCenterFrequency;
    }

    public FrequencyT getEffectiveBandwidth() {
        return this._effectiveBandwidth;
    }

    public int getEffectiveNumberOfChannels() {
        return this._effectiveNumberOfChannels;
    }

    public String getName() {
        return this._name;
    }

    public AbstractSpectralWindowTPolnProductsType getPolnProducts() {
        return this._polnProducts;
    }

    public boolean getRepresentativeWindow() {
        return this._representativeWindow;
    }

    public AbstractSpectralWindowTSideBandType getSideBand() {
        return this._sideBand;
    }

    public int getSpectralAveragingFactor() {
        return this._spectralAveragingFactor;
    }

    public SpectralLineT getSpectralLine(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._spectralLineList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (SpectralLineT)this._spectralLineList.get(index);
    }

    public SpectralLineT[] getSpectralLine() {
        int size = this._spectralLineList.size();
        SpectralLineT[] mArray = new SpectralLineT[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (SpectralLineT)this._spectralLineList.get(index);
        }
        return mArray;
    }

    public int getSpectralLineCount() {
        return this._spectralLineList.size();
    }

    public boolean getUseThisSpectralWindow() {
        return this._useThisSpectralWindow;
    }

    public AbstractSpectralWindowTWindowFunctionType getWindowFunction() {
        return this._windowFunction;
    }

    public boolean hasAssociatedSpectralWindowNumberInPair() {
        return this._has_associatedSpectralWindowNumberInPair;
    }

    public boolean hasEffectiveNumberOfChannels() {
        return this._has_effectiveNumberOfChannels;
    }

    public boolean hasRepresentativeWindow() {
        return this._has_representativeWindow;
    }

    public boolean hasSpectralAveragingFactor() {
        return this._has_spectralAveragingFactor;
    }

    public boolean hasUseThisSpectralWindow() {
        return this._has_useThisSpectralWindow;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeSpectralLine(SpectralLineT vSpectralLine) {
        boolean removed = this._spectralLineList.remove(vSpectralLine);
        return removed;
    }

    public void setAssociatedSpectralWindowNumberInPair(int associatedSpectralWindowNumberInPair) {
        this._associatedSpectralWindowNumberInPair = associatedSpectralWindowNumberInPair;
        this._has_associatedSpectralWindowNumberInPair = true;
    }

    public void setCenterFrequency(FrequencyT centerFrequency) {
        this._centerFrequency = centerFrequency;
    }

    public void setDesiredCenterFrequency(FrequencyT desiredCenterFrequency) {
        this._desiredCenterFrequency = desiredCenterFrequency;
    }

    public void setEffectiveBandwidth(FrequencyT effectiveBandwidth) {
        this._effectiveBandwidth = effectiveBandwidth;
    }

    public void setEffectiveNumberOfChannels(int effectiveNumberOfChannels) {
        this._effectiveNumberOfChannels = effectiveNumberOfChannels;
        this._has_effectiveNumberOfChannels = true;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPolnProducts(AbstractSpectralWindowTPolnProductsType polnProducts) {
        this._polnProducts = polnProducts;
    }

    public void setRepresentativeWindow(boolean representativeWindow) {
        this._representativeWindow = representativeWindow;
        this._has_representativeWindow = true;
    }

    public void setSideBand(AbstractSpectralWindowTSideBandType sideBand) {
        this._sideBand = sideBand;
    }

    public void setSpectralAveragingFactor(int spectralAveragingFactor) {
        this._spectralAveragingFactor = spectralAveragingFactor;
        this._has_spectralAveragingFactor = true;
    }

    public void setSpectralLine(int index, SpectralLineT vSpectralLine) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._spectralLineList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._spectralLineList.set(index, vSpectralLine);
    }

    public void setSpectralLine(SpectralLineT[] spectralLineArray) {
        this._spectralLineList.clear();
        for (int i = 0; i < spectralLineArray.length; ++i) {
            this._spectralLineList.add(spectralLineArray[i]);
        }
    }

    public void setUseThisSpectralWindow(boolean useThisSpectralWindow) {
        this._useThisSpectralWindow = useThisSpectralWindow;
        this._has_useThisSpectralWindow = true;
    }

    public void setWindowFunction(AbstractSpectralWindowTWindowFunctionType windowFunction) {
        this._windowFunction = windowFunction;
    }

    public static AbstractSpectralWindowT unmarshalAbstractSpectralWindowT(Reader reader) throws MarshalException, ValidationException {
        return (AbstractSpectralWindowT)Unmarshaller.unmarshal(AbstractSpectralWindowT.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

