/*
 * Decompiled with CFR 0.152.
 */
package alma.entity.xmlbinding.obsproject;

import alma.entity.xmlbinding.obsproject.CalibrationTargetPropertiesT;
import alma.entity.xmlbinding.valuetypes.FluxT;
import alma.entity.xmlbinding.valuetypes.FrequencyT;
import alma.entity.xmlbinding.valuetypes.SkyCoordinatesT;
import alma.entity.xmlbinding.valuetypes.VelocityT;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class ObservatoryGoalTargetParametersT
implements Serializable {
    private String _sourceName;
    private SkyCoordinatesT _sourceCoordinates;
    private FluxT _flux;
    private VelocityT _sourceVelocity;
    private int _index = 0;
    private boolean _has_index;
    private FrequencyT _frequency;
    private ArrayList _calibrationTargetPropertiesList = new ArrayList();

    public void addCalibrationTargetProperties(CalibrationTargetPropertiesT vCalibrationTargetProperties) throws IndexOutOfBoundsException {
        this._calibrationTargetPropertiesList.add(vCalibrationTargetProperties);
    }

    public void addCalibrationTargetProperties(int index, CalibrationTargetPropertiesT vCalibrationTargetProperties) throws IndexOutOfBoundsException {
        this._calibrationTargetPropertiesList.add(index, vCalibrationTargetProperties);
    }

    public void clearCalibrationTargetProperties() {
        this._calibrationTargetPropertiesList.clear();
    }

    public void deleteIndex() {
        this._has_index = false;
    }

    public Enumeration enumerateCalibrationTargetProperties() {
        return new IteratorEnumeration(this._calibrationTargetPropertiesList.iterator());
    }

    public CalibrationTargetPropertiesT getCalibrationTargetProperties(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._calibrationTargetPropertiesList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (CalibrationTargetPropertiesT)this._calibrationTargetPropertiesList.get(index);
    }

    public CalibrationTargetPropertiesT[] getCalibrationTargetProperties() {
        int size = this._calibrationTargetPropertiesList.size();
        CalibrationTargetPropertiesT[] mArray = new CalibrationTargetPropertiesT[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (CalibrationTargetPropertiesT)this._calibrationTargetPropertiesList.get(index);
        }
        return mArray;
    }

    public int getCalibrationTargetPropertiesCount() {
        return this._calibrationTargetPropertiesList.size();
    }

    public FluxT getFlux() {
        return this._flux;
    }

    public FrequencyT getFrequency() {
        return this._frequency;
    }

    public int getIndex() {
        return this._index;
    }

    public SkyCoordinatesT getSourceCoordinates() {
        return this._sourceCoordinates;
    }

    public String getSourceName() {
        return this._sourceName;
    }

    public VelocityT getSourceVelocity() {
        return this._sourceVelocity;
    }

    public boolean hasIndex() {
        return this._has_index;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeCalibrationTargetProperties(CalibrationTargetPropertiesT vCalibrationTargetProperties) {
        boolean removed = this._calibrationTargetPropertiesList.remove(vCalibrationTargetProperties);
        return removed;
    }

    public void setCalibrationTargetProperties(int index, CalibrationTargetPropertiesT vCalibrationTargetProperties) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._calibrationTargetPropertiesList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._calibrationTargetPropertiesList.set(index, vCalibrationTargetProperties);
    }

    public void setCalibrationTargetProperties(CalibrationTargetPropertiesT[] calibrationTargetPropertiesArray) {
        this._calibrationTargetPropertiesList.clear();
        for (int i = 0; i < calibrationTargetPropertiesArray.length; ++i) {
            this._calibrationTargetPropertiesList.add(calibrationTargetPropertiesArray[i]);
        }
    }

    public void setFlux(FluxT flux) {
        this._flux = flux;
    }

    public void setFrequency(FrequencyT frequency) {
        this._frequency = frequency;
    }

    public void setIndex(int index) {
        this._index = index;
        this._has_index = true;
    }

    public void setSourceCoordinates(SkyCoordinatesT sourceCoordinates) {
        this._sourceCoordinates = sourceCoordinates;
    }

    public void setSourceName(String sourceName) {
        this._sourceName = sourceName;
    }

    public void setSourceVelocity(VelocityT sourceVelocity) {
        this._sourceVelocity = sourceVelocity;
    }

    public static ObservatoryGoalTargetParametersT unmarshalObservatoryGoalTargetParametersT(Reader reader) throws MarshalException, ValidationException {
        return (ObservatoryGoalTargetParametersT)Unmarshaller.unmarshal(ObservatoryGoalTargetParametersT.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

